;; -*- Scheme -*-
;;
;; $Id: mawk06.scm,v 1.1 1998/03/16 07:58:44 foner Exp $

;;----------

(require 'string:search:find-string)
(require 'string:search:find-char)
(require 'string:search:find-chars)
(require 'string:search:find)
(require 'string:search:find$)
(require 'string:search:match-string)
(require 'string:search:match-char)
(require 'string:search:match-chars)
(require 'string:search:match)
(require 'string:search:match$)
(require 'string:search:skip-string*)
(require 'string:search:skip-char*)
(require 'string:search:skip-chars*)
(require 'string:search:skip-int)
(require 'string:search:skip*)
(require 'string:search:skip-char+)
(require 'string:search:skip-chars+)
(require 'string:search:skip+)
(require 'string:search:save-string)
(require 'string:search:save-pos)

;;-----------

;;+doc
;; procedure: mawk:pattern:find-string
;; arguments: string
;;
;; Attempts to find the given STRING anywhere to the right of the current
;; position in the line being scanned.  Leaves the implicit position at
;; the position where the first character of STRING is found.
;;-doc

(define mawk:pattern:find-string string:search:find-string)


;;+doc
;; procedure: mawk:pattern:find-char
;; arguments: character
;;
;; Attempts to find the given CHARACTER anywhere to the right of the current
;; position in the line being scanned.  Leaves the implicit position at
;; the position of CHARACTER in the line.
;;-doc

(define mawk:pattern:find-char string:search:find-char)


;;+doc
;; procedure: mawk:pattern:find-chars
;; arguments: char-set
;;
;; Attempts to find a member of CHAR-SET anywhere to the right of the current
;; position in the line being scanned.  Leaves the implicit position at
;; the position of CHARACTER found in the line.
;;-doc

(define mawk:pattern:find-chars string:search:find-chars)


;;+doc
;; procedure: mawk:pattern:find$
;; arguments: none
;;
;; Locates the right end of the line.
;;-doc

(define mawk:pattern:find$ string:search:find$)


;;+doc
;; procedure: mawk:pattern:find
;; arguments: (string|char-set|char)
;;
;; Does the equivalent of FIND-STRING, FIND-CHARS or FIND-CHAR depending
;; on the type of the argument.
;;-doc

(define mawk:pattern:find string:search:find)


;;+doc
;; procedure: mawk:pattern:match-string
;; arguments: string
;;
;; Attempts to match the given STRING against the substring of the 
;; same length taken from the current line starting at the implicit position.
;; If the substring matches, leaves the implicit position at the first
;; character after the end of the string.  Note this is different from 
;; the action of FIND-STRING and is done purposely to follow the precedent set 
;; by Icon on which these routines are based.
;;-doc

(define mawk:pattern:match-string string:search:match-string)


;;+doc
;; procedure: mawk:pattern:match-char
;; arguments: character
;;
;; Attempts to match the given CHARACTER against the character at the
;; implicit position.  If the character matches, the implicit position
;; is left at the position of the next character.
;; Note this is different from the action of FIND-CHAR and is done purposely 
;; to follow the precedent set by Icon on which these routines are based.
;;-doc

(define mawk:pattern:match-char string:search:match-char)


;;+doc
;; procedure: mawk:pattern:match-chars
;; arguments: char-set
;;
;; Attempts to match the character at the implicit position against any
;; character in CHAR-SET.  If the character matches, the implicit position
;; is left at the position of the next character.
;; Note this is different from the action of FIND-CHARS and is done purposely 
;; to follow the precedent set by Icon on which these routines are based.
;;-doc

(define mawk:pattern:match-chars string:search:match-chars)


;;+doc
;; procedure: mawk:pattern:match$
;; arguments: none
;;
;; Succeeds if current position is the end of the line.
;;-doc

(define mawk:pattern:match$ string:search:match$)


;;+doc
;; procedure: mawk:pattern:match
;; arguments: (string|char-set|char)
;;
;; Does the equivalent of MATCH-STRING, MATCH-CHARS or MATCH-CHAR depending
;; on the type of the argument.
;;-doc

(define mawk:pattern:match string:search:match)


;;+doc
;; procedure: mawk:pattern:skip-string*
;; arguments: string
;;
;; Starting at the implicit position, skips repeated occurrences of
;; STRING.  Leaves the implicit position at the start of the first 
;; substring which does not match STRING.  For example, given the following
;; pattern :-
;;
;; > (mawk:pattern:skip-string* "foo")
;;
;; and a line containing "foobar foofoofo foo" where the starting position
;; is 7 (i.e. the start of the second "foo"), then the result will be a
;; shift of the implicit position to position 13.
;; The `*' in the name is meant to signify that it is valid not to skip
;; any instances of STRING.
;;-doc

(define mawk:pattern:skip-string* string:search:skip-string*)


;;+doc
;; procedure: mawk:pattern:skip-char*
;; arguments: char
;;
;; Starting at the implicit position, skips repeated occurrences of
;; CHAR.  Leaves the implicit position at the start of the first 
;; character which does not match CHAR.
;; The `*' in the name is meant to signify that it is valid not to skip
;; any instances of CHAR.
;;-doc

(define mawk:pattern:skip-char* string:search:skip-char*)


;;+doc
;; procedure: mawk:pattern:skip-chars*
;; arguments: char-set
;;
;; Starting at the implicit position, skips any characters that are in
;; CHAR-SET.  Leaves the implicit position at the position of the first
;; character which is not in CHAR-SET.  The `*' in the name is meant to
;; signify that it is valid to skip no characters at all.
;;-doc

(define mawk:pattern:skip-chars* string:search:skip-chars*)


;;+doc
;; procedure: mawk:pattern:skip-int
;; arguments: n
;; signature: int
;;
;; Skips N characters in the line.
;;-doc

(define mawk:pattern:skip-int string:search:skip-int)


;;+doc
;; procedure: mawk:pattern:skip*
;; arguments: (string|char|char-set|int)
;;
;; Depending on the type does the equivalent of SKIP-STRING*, SKIP-CHAR*
;; SKIP-CHARS* or SKIP-INT.
;;-doc

(define mawk:pattern:skip* string:search:skip*)


;;+doc
;; procedure: mawk:pattern:skip-char+
;; arguments: char
;;
;; Starting at the implicit position, skips repeated occurrences of
;; CHAR.  Leaves the implicit position at the start of the first 
;; character which does not match CHAR.
;; The `+' in the name is meant to signify that at least one character
;; must be skipped.
;;-doc

(define mawk:pattern:skip-char+ string:search:skip-char+)


;;+doc
;; procedure: mawk:pattern:skip-chars+
;; arguments: char-set
;;
;; Starting at the implicit position, skips any characters that are in
;; CHAR-SET.  Leaves the implicit position at the position of the first
;; character which is not in CHAR-SET.  The `+' in the name is meant to
;; signify that at least one character must be skipped.
;;-doc

(define mawk:pattern:skip-chars+ string:search:skip-chars+)


;;+doc
;; procedure: mawk:pattern:skip+
;; arguments: (string|char|char-set|int)
;;
;; Depending on the type does the equivalent of SKIP-STRING+, SKIP-CHAR+
;; SKIP-CHARS+ or SKIP-INT.
;;-doc

(define mawk:pattern:skip+ string:search:skip+)


;;+doc
;; procedure: mawk:pattern:extract
;; argument: actions ...
;; 
;; Save the string that is delimited by the implicit position
;; and the point left at the end of the implicit actions.
;; Leaves the implicit position at the end marked by the actions and
;; leaves the result containing the string preceded by any additions
;; to the result done whilst performing ACTIONS
;;-doc

(define mawk:pattern:extract string:search:save-string)


;;+doc
;; procedure: mawk:pattern:pos
;;
;; Save the current position.
;;-doc

(define mawk:pattern:pos string:search:save-pos)


;;+doc
;; procedure: mawk:pattern:make
;; arguments: pattern ...
;; signature: pattern* -> mawk:pattern
;;
;; Converts the optional arguments into a MAWK pattern.
;;
;; For example, the following constructs a pattern 
;;
;;   (mawk:pattern:make 
;;     (m #\#) (s* ws) (m "include") (s* ws) (m #\") pos (f #\") pos)
;;
;; that will match the following regular expression
;;
;;      ^#[\t ]*include[\t ]*"\(.*\)"
;;
;; ... XXX finish this.
;;
;; where m   = mawk:pattern:match
;;       s*  = mawk:pattern:skip*
;;       f   = mawk:pattern:find
;;       pos = mawk:pattern:save-pos
;;       ws  = char-set:whitespace
;;-doc

(define mawk:pattern:make list)


;;+doc
;; procedure: mawk:pattern:any
;; arguments: none
;; signature: () -> mawk:pattern
;;
;; A pattern that is guaranteed to match any line
;;-doc

(define mawk:pattern:any (mawk:pattern:make))

;------------
;exports mawk:pattern

;; eof
