AC_DEFUN(AC_FIND_UNEXEC,
[
dnl Figuring out which unexec to use is hard, so we just steal a lot from
dnl Emacs here.

#### Given the configuration name, set machfile and opsysfile to the
#### names of the m/*.h and s/*.h files we should use.

### Canonicalize the configuration name.

canonical=$host
configuration=$host_alias

changequote(, )dnl

### If you add support for a new configuration, add code to this
### switch statement to recognize your configuration name and select
### the appropriate operating system and machine description files.

### You would hope that you could choose an m/*.h file pretty much
### based on the machine portion of the configuration name, and an s-
### file based on the operating system portion.  However, it turns out
### that each m/*.h file is pretty manufacturer-specific - for
### example, apollo.h, hp9000s300.h, mega68k, news.h, and tad68k are
### all 68000 machines; mips.h, pmax.h, and news-risc are all MIPS
### machines.  So we basically have to have a special case for each
### configuration name.
###
### As far as handling version numbers on operating systems is
### concerned, make sure things will fail in a fixable way.  If
### /etc/MACHINES doesn't say anything about version numbers, be
### prepared to handle anything reasonably.  If version numbers
### matter, be sure /etc/MACHINES says something about it.
###
### Eric Raymond says we should accept strings like "sysvr4" to mean
### "System V Release 4"; he writes, "The old convention encouraged
### confusion between `system' and `release' levels'."

machine='' opsys='' unported=no
case "${canonical}" in

  ## NetBSD ports
  *-*-netbsd* )
    opsys=netbsd
    case "${canonical}" in
      i[3456]86-*-netbsd*) machine=intel386 ;;
      m68k-*-netbsd*)
			# This is somewhat bogus.
			machine=hp9000s300 ;;
      mips-*-netbsd*)	machine=pmax ;;
      ns32k-*-netbsd*)	machine=ns32000 ;;
      sparc-*-netbsd*)	machine=sparc ;;
    esac
  ;;

  ## Acorn RISCiX:
  arm-acorn-riscix1.1* )
    machine=acorn opsys=riscix1-1
  ;;
  arm-acorn-riscix1.2* | arm-acorn-riscix )
    machine=acorn opsys=riscix1-2
  ;;

  ## Alliant machines
  ## Strictly speaking, we need the version of the alliant operating
  ## system to choose the right machine file, but currently the
  ## configuration name doesn't tell us enough to choose the right
  ## one; we need to give alliants their own operating system name to
  ## do this right.  When someone cares, they can help us.
  fx80-alliant-* )
    machine=alliant4 opsys=bsd4-2
  ;;
  i860-alliant-* )
    machine=alliant-2800 opsys=bsd4-3
  ;;

  ## Alpha (DEC) machines.
  alpha-dec-osf* )
    machine=alpha opsys=osf1
    # This is needed to find X11R6.1 libraries for certain tests.
    NON_GCC_LINK_TEST_OPTIONS=-Wl,-rpath,/usr/X11R6/lib
    GCC_LINK_TEST_OPTIONS=-Wl,-rpath,/usr/X11R6/lib
  ;;

  alpha-*-linux-gnu* )
    machine=alpha opsys=gnu-linux
  ;;

  ## Altos 3068
  m68*-altos-sysv* )
    machine=altos opsys=usg5-2
  ;;

  ## Amdahl UTS
  580-amdahl-sysv* )
    machine=amdahl opsys=usg5-2-2
  ;;

  ## Apollo, Domain/OS
  m68*-apollo-* )
    machine=apollo opsys=bsd4-3
  ;;

  ## AT&T 3b2, 3b5, 3b15, 3b20
  we32k-att-sysv* )
    machine=att3b opsys=usg5-2-2
  ;;

  ## AT&T 3b1 - The Mighty Unix PC!
  m68*-att-sysv* )
    machine=7300 opsys=usg5-2-2
  ;;

  ## Bull dpx20
  rs6000-bull-bosx* )
    machine=ibmrs6000 opsys=aix3-2
  ;;

  ## Bull dpx2
  m68*-bull-sysv3* )
    machine=dpx2 opsys=usg5-3
  ;;

  ## Bull sps7
  m68*-bull-sysv2* )
    machine=sps7 opsys=usg5-2
  ;;

  ## CCI 5/32, 6/32 -- see "Tahoe".

  ## Celerity
  ## I don't know what configuration name to use for this; config.sub
  ## doesn't seem to know anything about it.  Hey, Celerity users, get
  ## in touch with us!
  celerity-celerity-bsd* )
    machine=celerity opsys=bsd4-2
  ;;

  ## Clipper
  ## What operating systems does this chip run that Emacs has been
  ## tested on?
  clipper-* )
    machine=clipper
    ## We'll use the catch-all code at the bottom to guess the
    ## operating system.
  ;;

  ## Convex
  *-convex-bsd* | *-convex-convexos* )
    machine=convex opsys=bsd4-3
    ## Prevents spurious white space in makefiles - d.m.cooke@larc.nasa.gov
    NON_GNU_CPP="cc -E -P"
  ;;

  ## Cubix QBx/386
  i[3456]86-cubix-sysv* )
    machine=intel386 opsys=usg5-3
  ;;

  ## Cydra 5
  cydra*-cydrome-sysv* )
    machine=cydra5 opsys=usg5-3
  ;;

  ## Data General AViiON Machines
  m88k-dg-dgux5.4R3* | m88k-dg-dgux5.4.3* )
    machine=aviion opsys=dgux5-4r3
  ;;
  m88k-dg-dgux5.4R2* | m88k-dg-dgux5.4.2* )
    machine=aviion opsys=dgux5-4r2
  ;;
  m88k-dg-dgux* )
    machine=aviion opsys=dgux
  ;;

  ## DECstations
  mips-dec-ultrix[0-3].* | mips-dec-ultrix4.0* | mips-dec-bsd4.2* )
    machine=pmax opsys=bsd4-2
  ;;
  mips-dec-ultrix4.[12]* | mips-dec-bsd* )
    machine=pmax opsys=bsd4-3
  ;;
  mips-dec-ultrix* )
    machine=pmax opsys=ultrix4-3
  ;;
  mips-dec-osf* )
    machine=pmax opsys=osf1
  ;;
  mips-dec-mach_bsd4.3* )
    machine=pmax opsys=mach-bsd4-3
  ;;

  ## Motorola Delta machines
  m68k-motorola-sysv* | m68000-motorola-sysv* )
    machine=delta opsys=usg5-3
    if test -z "`type gnucc | grep 'not found'`"
    then
      if test -s /etc/167config
      then CC="gnucc -m68040"
      else CC="gnucc -m68881"
      fi
    else
      if test -z "`type gcc | grep 'not found'`"
      then CC=gcc
      else CC=cc
      fi
    fi
  ;;
  m88k-motorola-sysv4* )
    # jbotte@bnr.ca says that UNIX_System_V <hostName> 4.0 R40V4.3 m88k mc88110
    # needs POSIX_SIGNALS and therefore needs usg5-4-2.
    # I hope there are not other 4.0 versions for this machine
    # which really need usg5-4 instead.
    machine=delta88k opsys=usg5-4-2
  ;;
  m88k-motorola-sysv* | m88k-motorola-m88kbcs* )
    machine=delta88k opsys=usg5-3
  ;;

  ## Dual machines
  m68*-dual-sysv* )
    machine=dual opsys=usg5-2
  ;;
  m68*-dual-uniplus* )
    machine=dual opsys=unipl5-2
  ;;

  ## Elxsi 6400
  elxsi-elxsi-sysv* )
    machine=elxsi opsys=usg5-2
  ;;

  ## Encore machines
  ns16k-encore-bsd* )
    machine=ns16000 opsys=umax
  ;;

  ## The GEC 93 - apparently, this port isn't really finished yet.

  ## Gould Power Node and NP1
  pn-gould-bsd4.2* )
    machine=gould opsys=bsd4-2
  ;;
  pn-gould-bsd4.3* )
    machine=gould opsys=bsd4-3
  ;;
  np1-gould-bsd* )
    machine=gould-np1 opsys=bsd4-3
  ;;

  ## Harris Night Hawk machines running CX/UX (a 5000 looks just like a 4000
  ## as far as Emacs is concerned).
  m88k-harris-cxux* )
    # Build needs to be different on 7.0 and later releases
    case "`uname -r`" in
       [56].[0-9] ) machine=nh4000 opsys=cxux ;;
       [7].[0-9] ) machine=nh4000 opsys=cxux7 ;;
    esac
    NON_GNU_CPP="/lib/cpp"
  ;;
  ## Harris ecx or gcx running CX/UX (Series 1200, Series 3000)
  m68k-harris-cxux* )
    machine=nh3000 opsys=cxux
  ;;
  ## Harris power pc NightHawk running Power UNIX (Series 6000)
  powerpc-harris-powerunix )
    machine=nh6000 opsys=powerunix
    NON_GNU_CPP="cc -Xo -E -P"
  ;;

  ## Honeywell XPS100
  xps*-honeywell-sysv* )
    machine=xps100 opsys=usg5-2
  ;;

  ## HP 9000 series 200 or 300
  m68*-hp-bsd* )
    machine=hp9000s300 opsys=bsd4-3
  ;;
  ## HP/UX 7, 8, 9, and 10 are supported on these machines.
  m68*-hp-hpux* )
    case "`uname -r`" in
      ## Someone's system reports A.B8.05 for this.
      ## I wonder what other possibilities there are.
      *.B8.* ) machine=hp9000s300 opsys=hpux8 ;;
      *.08.* ) machine=hp9000s300 opsys=hpux8 ;;
      *.09.* ) machine=hp9000s300 opsys=hpux9 ;;
      *.10.* ) machine=hp9000s300 opsys=hpux9shr ;;
      *) machine=hp9000s300 opsys=hpux ;;
    esac
  ;;

  ## HP 9000 series 700 and 800, running HP/UX
  hppa*-hp-hpux7* )
    machine=hp800 opsys=hpux
  ;;
  hppa*-hp-hpux8* )
    machine=hp800 opsys=hpux8
  ;;
  hppa*-hp-hpux9shr* )
    machine=hp800 opsys=hpux9shr
  ;;
  hppa*-hp-hpux9* )
    machine=hp800 opsys=hpux9
  ;;
  hppa*-hp-hpux10* )
    machine=hp800 opsys=hpux10
  ;;

  ## HP 9000 series 700 and 800, running HP/UX
  hppa*-hp-hpux* )
    ## Cross-compilation?  Nah!
    case "`uname -r`" in
      ## Someone's system reports A.B8.05 for this.
      ## I wonder what other possibilities there are.
      *.B8.* ) machine=hp800 opsys=hpux8 ;;
      *.08.* ) machine=hp800 opsys=hpux8 ;;
      *.09.* ) machine=hp800 opsys=hpux9 ;;
      *) machine=hp800 opsys=hpux ;;
    esac
  ;;
  hppa-*-nextstep* )
    machine=hp800 opsys=nextstep
  ;;

  ## Orion machines
  orion-orion-bsd* )
    machine=orion opsys=bsd4-2
  ;;
  clipper-orion-bsd* )
    machine=orion105 opsys=bsd4-2
  ;;

  ## IBM machines
  i[3456]86-ibm-aix1.1* )
    machine=ibmps2-aix opsys=usg5-2-2
  ;;
  i[3456]86-ibm-aix1.[23]* | i[3456]86-ibm-aix* )
    machine=ibmps2-aix opsys=usg5-3
  ;;
  i370-ibm-aix*)
    machine=ibm370aix opsys=usg5-3
  ;;
  rs6000-ibm-aix3.1* | powerpc-ibm-aix3.1*  )
    machine=ibmrs6000 opsys=aix3-1
  ;;
  rs6000-ibm-aix3.2.5 | powerpc-ibm-aix3.2.5 )
    machine=ibmrs6000 opsys=aix3-2-5
  ;;
  rs6000-ibm-aix4.1* | powerpc-ibm-aix4.1*  )
    machine=ibmrs6000 opsys=aix4-1
  ;;
  rs6000-ibm-aix4* | powerpc-ibm-aix4*  )
    machine=ibmrs6000 opsys=aix4
  ;;
  rs6000-ibm-aix* | powerpc-ibm-aix* )
    machine=ibmrs6000 opsys=aix3-2
  ;;
  romp-ibm-bsd4.3* )
    machine=ibmrt opsys=bsd4-3
  ;;
  romp-ibm-bsd4.2* )
    machine=ibmrt opsys=bsd4-2
  ;;
  romp-ibm-aos4.3* )
    machine=ibmrt opsys=bsd4-3
  ;;
  romp-ibm-aos4.2* )
    machine=ibmrt opsys=bsd4-2
  ;;
  romp-ibm-aos* )
    machine=ibmrt opsys=bsd4-3
  ;;
  romp-ibm-bsd* )
    machine=ibmrt opsys=bsd4-3
  ;;
  romp-ibm-aix* )
    machine=ibmrt-aix opsys=usg5-2-2
  ;;

  ## Integrated Solutions `Optimum V'
  m68*-isi-bsd4.2* )
    machine=isi-ov opsys=bsd4-2
  ;;
  m68*-isi-bsd4.3* )
    machine=isi-ov opsys=bsd4-3
  ;;

  ## Intel 386 machines where we do care about the manufacturer
  i[3456]86-intsys-sysv* )
    machine=is386 opsys=usg5-2-2
  ;;

  ## Prime EXL
  i[3456]86-prime-sysv* )
    machine=i386 opsys=usg5-3
  ;;

  ## Sequent Symmetry running Dynix
  i[3456]86-sequent-bsd* )
    machine=symmetry opsys=bsd4-3
  ;;

  ## Sequent Symmetry running ptx 4, which is a modified SVR4.
  i[3456]86-sequent-ptx4* | i[3456]86-sequent-sysv4* )
    machine=sequent-ptx opsys=ptx4
    NON_GNU_CPP=/lib/cpp
  ;;

  ## Sequent Symmetry running DYNIX/ptx
  ## Use the old cpp rather than the newer ANSI one.
  i[3456]86-sequent-ptx* )
    machine=sequent-ptx opsys=ptx
    NON_GNU_CPP="/lib/cpp"
  ;;

  ## ncr machine running svr4.3.
  i[3456]86-ncr-sysv4.3 )
    machine=ncr386 opsys=usg5-4-3
  ;;

  ## Unspecified sysv on an ncr machine defaults to svr4.2.
  ## (Plain usg5-4 doesn't turn on POSIX signals, which we need.)
  i[3456]86-ncr-sysv* )
    machine=ncr386 opsys=usg5-4-2
  ;;

  ## Intel Paragon OSF/1
  i860-intel-osf1* )
    machine=paragon opsys=osf1 NON_GNU_CPP=/usr/mach/lib/cpp
  ;;

  ## Intel 860
  i860-*-sysv4* )
    machine=i860 opsys=usg5-4
    NON_GNU_CC="/bin/cc" # Ie, not the one in /usr/ucb/cc.
    NON_GNU_CPP="/usr/ccs/lib/cpp" # cc -E tokenizes macro expansion.
  ;;

  ## Masscomp machines
  m68*-masscomp-rtu* )
    machine=masscomp opsys=rtu
  ;;

  ## Megatest machines
  m68*-megatest-bsd* )
    machine=mega68 opsys=bsd4-2
  ;;

  ## Workstations sold by MIPS
  ## This is not necessarily all workstations using the MIPS processor -
  ## Irises are produced by SGI, and DECstations by DEC.

  ## etc/MACHINES lists mips.h and mips4.h as possible machine files,
  ## and usg5-2-2 and bsd4-3 as possible OS files.  The only guidance
  ## it gives for choosing between the alternatives seems to be "Use
  ## -machine=mips4 for RISCOS version 4; use -opsystem=bsd4-3 with
  ## the BSD world."  I'll assume that these are instructions for
  ## handling two odd situations, and that every other situation
  ## should use mips.h and usg5-2-2, they being listed first.
  mips-mips-usg* )
    machine=mips4
    ## Fall through to the general code at the bottom to decide on the OS.
  ;;
  mips-mips-riscos4* )
    machine=mips4 opsys=bsd4-3
    NON_GNU_CC="cc -systype bsd43"
    NON_GNU_CPP="cc -systype bsd43 -E"
  ;;
  mips-mips-riscos5* )
    machine=mips4 opsys=riscos5
    NON_GNU_CC="cc -systype bsd43"
    NON_GNU_CPP="cc -systype bsd43 -E"
  ;;
  mips-mips-bsd* )
    machine=mips opsys=bsd4-3
  ;;
  mips-mips-* )
    machine=mips opsys=usg5-2-2
  ;;

  ## NeXT
  m68*-next-* | m68k-*-nextstep* )
    machine=m68k opsys=nextstep
  ;;

  ## The complete machine from National Semiconductor
  ns32k-ns-genix* )
    machine=ns32000 opsys=usg5-2
  ;;

  ## NCR machines
  m68*-ncr-sysv2* | m68*-ncr-sysvr2* )
    machine=tower32 opsys=usg5-2-2
  ;;
  m68*-ncr-sysv3* | m68*-ncr-sysvr3* )
    machine=tower32v3 opsys=usg5-3
  ;;

  ## Nixdorf Targon 31
  m68*-nixdorf-sysv* )
    machine=targon31 opsys=usg5-2-2
  ;;

  ## Nu (TI or LMI)
  m68*-nu-sysv* )
    machine=nu opsys=usg5-2
  ;;

  ## Plexus
  m68*-plexus-sysv* )
    machine=plexus opsys=usg5-2
  ;;

  ## Pyramid machines
  ## I don't really have any idea what sort of processor the Pyramid has,
  ## so I'm assuming it is its own architecture.
  pyramid-pyramid-bsd* )
    machine=pyramid opsys=bsd4-2
  ;;

  ## Sequent Balance
  ns32k-sequent-bsd4.2* )
    machine=sequent opsys=bsd4-2
  ;;
  ns32k-sequent-bsd4.3* )
    machine=sequent opsys=bsd4-3
  ;;

  ## Siemens Nixdorf
  mips-siemens-sysv* | mips-sni-sysv*)
    machine=mips-siemens opsys=usg5-4
    NON_GNU_CC=/usr/ccs/bin/cc
    NON_GNU_CPP=/usr/ccs/lib/cpp
  ;;

  ## Silicon Graphics machines
  ## Iris 2500 and Iris 2500 Turbo (aka the Iris 3030)
  m68*-sgi-iris3.5* )
    machine=irist opsys=iris3-5
  ;;
  m68*-sgi-iris3.6* | m68*-sgi-iris*)
    machine=irist opsys=iris3-6
  ;;
  ## Iris 4D
  mips-sgi-irix3* )
    machine=iris4d opsys=irix3-3
  ;;
  mips-sgi-irix4* )
    machine=iris4d opsys=irix4-0
  ;;
  mips-sgi-irix6* )
    machine=iris4d opsys=irix6-0
    NON_GNU_CPP=/lib/cpp
    NON_GCC_TEST_OPTIONS=-32
  ;;
  mips-sgi-irix5.[01]* )
    machine=iris4d opsys=irix5-0
  ;;
  mips-sgi-irix5* | mips-sgi-irix* )
    machine=iris4d opsys=irix5-2
  ;;

  ## SONY machines
  m68*-sony-bsd4.2* )
    machine=news opsys=bsd4-2
  ;;
  m68*-sony-bsd4.3* )
    machine=news opsys=bsd4-3
  ;;
  m68*-sony-newsos3* | m68*-sony-news3*)
    machine=news opsys=bsd4-3
  ;;
  mips-sony-bsd* | mips-sony-newsos4* | mips-sony-news4*)
    machine=news-risc opsys=bsd4-3
  ;;
  mips-sony-news* )
    machine=news-risc opsys=newsos5
  ;;

  ## Stride
  m68*-stride-sysv* )
    machine=stride opsys=usg5-2
  ;;

  ## Suns
  sparc-*-linux-gnu* )
    machine=sparc opsys=gnu-linux
  ;;

  *-sun-sunos* | *-sun-bsd* | *-sun-solaris* \
    | i[3456]86-*-solaris2* | i[3456]86-*-sunos5* | powerpc*-*-solaris2* \
    | rs6000-*-solaris2*)
    case "${canonical}" in
      m68*-sunos1* )	machine=sun1 ;;
      m68*-sunos2* )	machine=sun2 ;;
      m68* )		machine=sun3 ;;
      i[3456]86-sun-sunos[34]* )	machine=sun386 ;;
      i[3456]86-*-* )     machine=intel386 ;;
      powerpc* | rs6000* )  machine=ibmrs6000 ;;
      sparc* )		machine=sparc ;;
      * )		unported=yes ;;
    esac
    case "${canonical}" in
      ## The Sun386 didn't get past 4.0.
      i[3456]86-*-sunos4	  ) opsys=sunos4-0 ;;
      *-sunos4.0*	  ) opsys=sunos4-0 ;;
      *-sunos4.1.[3-9]*noshare )
		opsys=sunos4-1-3
		NON_GNU_CPP=/usr/lib/cpp
		NON_GCC_TEST_OPTIONS=-Bstatic
		GCC_TEST_OPTIONS=-static
		;;
      *-sunos4.1.[3-9]* | *-sunos4shr*)
		opsys=sunos4shr
		NON_GNU_CPP=/usr/lib/cpp
		;;
      *-sunos4* | *-sunos )
		opsys=sunos4-1
		NON_GCC_TEST_OPTIONS=-Bstatic
		GCC_TEST_OPTIONS=-static
		;;
      *-sunos5.3* | *-solaris2.3* )
		opsys=sol2-3
		NON_GNU_CPP=/usr/ccs/lib/cpp
		;;
      *-sunos5.4* | *-solaris2.4* )
		opsys=sol2-4
		NON_GNU_CPP=/usr/ccs/lib/cpp
		RANLIB="ar -ts"
		;;
      *-sunos5.5* | *-solaris2.5* )
		opsys=sol2-5
		NON_GNU_CPP=/usr/ccs/lib/cpp
		RANLIB="ar -ts"
		;;
      *-sunos5* | *-solaris* )
		opsys=sol2-4
		NON_GNU_CPP=/usr/ccs/lib/cpp
		;;
      *			  ) opsys=bsd4-2   ;;
    esac
    ## Watch out for a compiler that we know will not work.
    case "${canonical}" in
     *-solaris* | *-sunos5* )
		if [ "x$CC" = x/usr/ucb/cc ]; then
		  ## /usr/ucb/cc doesn't work;
		  ## we should find some other compiler that does work.
		  unset CC
		fi
		;;
      *) ;;
    esac
  ;;
  sparc-*-nextstep* )
    machine=sparc opsys=nextstep
  ;;

  ## Tadpole 68k
  m68*-tadpole-sysv* )
    machine=tad68k opsys=usg5-3
  ;;

  ## Tahoe machines
  tahoe-tahoe-bsd4.2* )
    machine=tahoe opsys=bsd4-2
  ;;
  tahoe-tahoe-bsd4.3* )
    machine=tahoe opsys=bsd4-3
  ;;

  ## Tandem Integrity S2
  mips-tandem-sysv* )
    machine=tandem-s2 opsys=usg5-3
  ;;

  ## Tektronix XD88
  m88k-tektronix-sysv3* )
  machine=tekxd88 opsys=usg5-3
  ;;

  ## Tektronix 16000 box (6130?)
  ns16k-tektronix-bsd* )
    machine=ns16000 opsys=bsd4-2
  ;;
  ## Tektronix 4300
  ## src/m/tek4300.h hints that this is a m68k machine.
  m68*-tektronix-bsd* )
    machine=tek4300 opsys=bsd4-3
  ;;

  ## Titan P2 or P3
  ## We seem to have lost the machine-description file titan.h!
  titan-titan-sysv* )
    machine=titan opsys=usg5-3
  ;;

  ## Ustation E30 (SS5E)
  m68*-unisys-uniplus* )
    machine=ustation opsystem=unipl5-2
  ;;

  ## Vaxen.
  vax-dec-* )
    machine=vax
    case "${canonical}" in
      *-bsd4.1* ) 					opsys=bsd4-1 ;;
      *-bsd4.2* | *-ultrix[0-3].* | *-ultrix4.0* )	opsys=bsd4-2 ;;
      *-bsd4.3* | *-ultrix* ) 				opsys=bsd4-3 ;;
      *-sysv[01]* | *-sysvr[01]* ) 			opsys=usg5-0 ;;
      *-sysv2* | *-sysvr2* )				opsys=usg5-2 ;;
      *-vms* ) 						opsys=vms ;;
      * ) 						unported=yes
    esac
  ;;

  ## Whitechapel MG1
  ns16k-whitechapel-* )
    machine=mg1
    ## We don't know what sort of OS runs on these; we'll let the
    ## operating system guessing code below try.
  ;;

  ## Wicat
  m68*-wicat-sysv* )
    machine=wicat opsys=usg5-2
  ;;

  ## Intel 386 machines where we don't care about the manufacturer
  i[3456]86-*-* )
    machine=intel386
    case "${canonical}" in
      *-isc1.* | *-isc2.[01]* )	opsys=386-ix ;;
      *-isc2.2* )		opsys=isc2-2 ;;
      *-isc4.0* )		opsys=isc4-0 ;;
      *-isc4.* )		opsys=isc4-1
				GCC_TEST_OPTIONS=-posix
				NON_GCC_TEST_OPTIONS=-Xp
				;;
      *-isc* )			opsys=isc3-0 ;;
      *-esix5* )		opsys=esix5r4; NON_GNU_CPP=/usr/lib/cpp ;;
      *-esix* )			opsys=esix ;;
      *-xenix* )		opsys=xenix ;;
      *-linux-gnu* )		opsys=gnu-linux ;;
      *-sco3.2v4* )		opsys=sco4 ; NON_GNU_CPP=/lib/cpp  ;;
      *-sco3.2v5* )		opsys=sco5 
				NON_GNU_CPP=/lib/cpp
				# Prevent -belf from being passed to $CPP.
				# /lib/cpp does not accept it.
				OVERRIDE_CPPFLAGS=" "
				;;
      *-bsd386* | *-bsdi1* )	opsys=bsd386 ;;
      *-bsdi2.0* )		opsys=bsdos2 ;;
      *-bsdi2* )		opsys=bsdos2-1 ;;
      *-386bsd* )	        opsys=386bsd ;;
      *-freebsd* )	        opsys=freebsd ;;
      *-nextstep* )             opsys=nextstep ;;
      ## Otherwise, we'll fall through to the generic opsys code at the bottom.
    esac
  ;;

  ## Linux/68k-based GNU system
  m68k-*-linux-gnu* )
    machine=m68k opsys=gnu-linux
  ;;

  * )
    unported=yes
  ;;
esac

### If the code above didn't choose an operating system, just choose
### an operating system based on the configuration name.  You really
### only want to use this when you have no idea what the right
### operating system is; if you know what operating systems a machine
### runs, it's cleaner to make it explicit in the case statement
### above.
if test x"${opsys}" = x; then
  case "${canonical}" in
    *-gnu* )				opsys=gnu ;;
    *-bsd4.[01] )			opsys=bsd4-1 ;;
    *-bsd4.2 )				opsys=bsd4-2 ;;
    *-bsd4.3 )				opsys=bsd4-3 ;;
    *-sysv0 | *-sysvr0 )		opsys=usg5-0 ;;
    *-sysv2 | *-sysvr2 )		opsys=usg5-2 ;;
    *-sysv2.2 | *-sysvr2.2 )		opsys=usg5-2-2 ;;
    *-sysv3* | *-sysvr3* )		opsys=usg5-3 ;;
    *-sysv4.1* | *-sysvr4.1* )
	NON_GNU_CPP=/usr/lib/cpp
	opsys=usg5-4 ;;
    *-sysv4.[2-9]* | *-sysvr4.[2-9]* )
	if [ x$NON_GNU_CPP = x ]; then
	  if [ -f /usr/ccs/lib/cpp ]; then
	    NON_GNU_CPP=/usr/ccs/lib/cpp
	  else
	    NON_GNU_CPP=/lib/cpp
	  fi
	fi
	opsys=usg5-4-2 ;;
    *-sysv4* | *-sysvr4* )		opsys=usg5-4 ;;
    * )
      unported=yes
    ;;
  esac
fi

if test "x$RANLIB" = x; then
  RANLIB=ranlib
fi

changequote([, ])dnl

if test $unported = yes; then
  AC_MSG_ERROR([Emacs hasn't been ported to \`${canonical}' systems.
Check \`etc/MACHINES' for recognized configuration names.])
fi

machfile="m/${machine}.h"
opsysfile="s/${opsys}.h"

tempcname="conftest.c"

echo '
#include "'${srcdir}'/'${opsysfile}'"
#include "'${srcdir}'/'${machfile}'"
#ifdef UNEXEC
configure___ unexec=UNEXEC
#else
configure___ unexec=unexec.o
#endif
' > ${tempcname}

# The value of CPP is a quoted variable reference, so we need to do this
# to get its actual value...
CPP=`eval "echo $CPP"`
changequote(, )dnl
eval `${CPP} -Isrc ${tempcname} \
       | sed -n -e 's/^configure___ \([^=]*=\)\(.*\)$/\1"\2"/p'`
if test "x$SPECIFIED_CFLAGS" = x; then
  eval `${CPP} -Isrc -DTHIS_IS_CONFIGURE ${tempcname} \
	 | sed -n -e 's/^configure___ \([^=]*=\)\(.*\)$/\1"\2"/p'`
else
  REAL_CFLAGS="$CFLAGS"
fi
changequote([, ])dnl
rm ${tempcname}

UNEXEC=$unexec
UNEXEC_SRC="`echo ${unexec} | sed 's/\.o/.c/'`"
AC_SUBST(UNEXEC)
AC_SUBST(UNEXEC_SRC)
])
