#ifndef _CSTR_H_
#define _CSTR_H_

/* A general-purpose string "class" for C */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef struct cstr_alloc_st {
  void * (* alloc)(int);
  void (* free)(void *);
} cstr_allocator;

typedef struct cstr_st {
  char * data;	/* Okay to access data and length fields directly */
  int length;
  int cap;
  int ref;	/* Simple reference counter */
  cstr_allocator * allocator;
} cstr;

extern void cstr_set_allocator(cstr_allocator * alloc);

extern cstr * cstr_new();
extern cstr * cstr_new_alloc(cstr_allocator * alloc);
extern cstr * cstr_dup(const cstr * str);
extern cstr * cstr_dup_alloc(const cstr * str, cstr_allocator * alloc);
extern cstr * cstr_create(const char * s);
extern cstr * cstr_createn(const char * s, int len);
extern void cstr_use(cstr * str);
extern void cstr_free(cstr * str);
extern void cstr_clear_free(cstr * str);
extern void cstr_empty(cstr * str);
extern int cstr_copy(cstr * dst, const cstr * src);
extern int cstr_set(cstr * str, const char * s);
extern int cstr_setn(cstr * str, const char * s, int len);
extern int cstr_set_length(cstr * str, int len);
extern int cstr_append(cstr * str, const char * s);
extern int cstr_appendn(cstr * str, const char * s, int len);
extern int cstr_append_str(cstr * dst, const cstr * src);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _CSTR_H_ */
