/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skipvar.c	1.7 96/04/18 Sun Microsystems"

/*
 * System includes
 */
#include <skip_os.h>

/*
 * SKIP includes
 */
#include <skip_proto.h>
#include <skip_types.h>
#include <skip_ioctl.h>
#include <skip_acl.h>
#include <skip_lib.h>

char		*progname;
extern int	errno;

/*
 * Format error message if invalid options
 */
static void
usage(char *prog)
{
	fprintf(stderr, "%s: variable\n", prog);
	fprintf(stderr, "%s: variable value\n", prog);
}


/*
 * skipvar tool 
 */
int
SKIPVAR(int argc, char **argv)
{
	int		value;
	char		*default_interface = skip_default_if();

	progname = argv[0];

	if (argc < 2 || argc > 3) {
		usage(argv[0]);
		return(1);
	}

	if (strlen(argv[1]) >= (size_t)MAXVARNAMELG) {
		fprintf(stderr, "%s: variable name should not be longer than"
				" %d characters\n", progname, MAXVARNAMELG);
		return(1);
	}

	if (argc == 2) {
		/*
		 * Get kernel variable value
		 */
		if (skip_var_get(default_interface, argv[1], &value)) {
			fprintf(stderr, "%s\n", skip_errmsg);
			return(1);
		}

		printf("%s: %s value is %d\n", argv[0], argv[1], value);
	} else {
		/*
		 * Set kernel variable value
		 */
		sscanf(argv[2], "%d", &value);
	
		if (skip_var_set(default_interface, argv[1], value)) {
			fprintf(stderr, "%s\n", skip_errmsg);
			return(1);
		}
	}

	return(0);
}
