/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
/*
 * skiptool_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `skiptool.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include "skiptool_ui.h"

/*
 * Create object `stats_menu' in the specified instance.
 */
Xv_opaque
skiptool_stats_menu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	skiptool_stats_menu_item0_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_stats_menu_item1_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_stats_menu_item2_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_stats_menu_item3_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_stats_menu_item4_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_stats_menu_item5_callback(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, owner ? "" : "SKIP Statistics",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Network Interface Stats",
			MENU_GEN_PROC, skiptool_stats_menu_item0_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Header Stats",
			MENU_GEN_PROC, skiptool_stats_menu_item1_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Key Stats",
			MENU_GEN_PROC, skiptool_stats_menu_item2_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Encryption Stats (version 1)",
			MENU_GEN_PROC, skiptool_stats_menu_item3_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Encryption Stats",
			MENU_GEN_PROC, skiptool_stats_menu_item4_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Authentication Stats",
			MENU_GEN_PROC, skiptool_stats_menu_item5_callback,
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "SKIP Statistics",
		NULL);
	return obj;
}

/*
 * Create object `menu' in the specified instance.
 */
Xv_opaque
skiptool_menu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	skiptool_menu_item0_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_menu_item1_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_menu_item3_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_menu_item4_callback(Menu_item, Menu_generate);
	extern Xv_opaque	skiptool_stats_menu_create(caddr_t, Xv_opaque);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, owner ? "" : "File",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Load",
			MENU_GEN_PROC, skiptool_menu_item0_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Key Management...",
			MENU_GEN_PROC, skiptool_menu_item1_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "SKIP Statistics",
			MENU_PULLRIGHT, skiptool_stats_menu_create(ip, owner),
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Save",
			MENU_GEN_PROC, skiptool_menu_item3_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Exit",
			MENU_GEN_PROC, skiptool_menu_item4_callback,
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "File",
		NULL);
	return obj;
}

/*
 * Create object `version_menu' in the specified instance.
 */
Xv_opaque
skiptool_version_menu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	skiptool_version_menu_item0_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_version_menu_item1_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_version_menu_item2_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_version_menu_item3_callback(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Host Security...",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Off",
			MENU_GEN_PROC, skiptool_version_menu_item0_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "SKIP",
			MENU_GEN_PROC, skiptool_version_menu_item1_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "SKIP (version 1)",
			MENU_GEN_PROC, skiptool_version_menu_item2_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "ESP/AH (manual keying)",
			MENU_GEN_PROC, skiptool_version_menu_item3_callback,
			NULL,
		MENU_DEFAULT, 2,
		NULL);
	return obj;
}

/*
 * Create object `version_menu_nom' in the specified instance.
 */
Xv_opaque
skiptool_version_menu_nom_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	skiptool_version_menu_nom_item0_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_version_menu_nom_item1_callback(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Nomadic Security...",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "SKIP",
			MENU_GEN_PROC, skiptool_version_menu_nom_item0_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "SKIP (version 1)",
			MENU_GEN_PROC, skiptool_version_menu_nom_item1_callback,
			NULL,
		MENU_DEFAULT, 2,
		NULL);
	return obj;
}

/*
 * Create object `version_menu_net' in the specified instance.
 */
Xv_opaque
skiptool_version_menu_net_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	skiptool_version_menu_net_item0_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_version_menu_net_item1_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_version_menu_net_item2_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_version_menu_net_item3_callback(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Network Security...",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Off",
			MENU_GEN_PROC, skiptool_version_menu_net_item0_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "SKIP",
			MENU_GEN_PROC, skiptool_version_menu_net_item1_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "SKIP (version 1)",
			MENU_GEN_PROC, skiptool_version_menu_net_item2_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "ESP/AH (manual keying)",
			MENU_GEN_PROC, skiptool_version_menu_net_item3_callback,
			NULL,
		MENU_DEFAULT, 2,
		NULL);
	return obj;
}

/*
 * Create object `add_menu' in the specified instance.
 */
Xv_opaque
skiptool_add_menu_create(caddr_t ip, Xv_opaque owner)
{
	extern Xv_opaque	skiptool_version_menu_create(caddr_t, Xv_opaque);
	extern Xv_opaque	skiptool_version_menu_net_create(caddr_t, Xv_opaque);
	extern Xv_opaque	skiptool_version_menu_nom_create(caddr_t, Xv_opaque);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, owner ? "" : "Add...",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Host",
			MENU_PULLRIGHT, skiptool_version_menu_create(ip, owner),
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Network",
			MENU_PULLRIGHT, skiptool_version_menu_net_create(ip, owner),
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Nomadic",
			MENU_PULLRIGHT, skiptool_version_menu_nom_create(ip, owner),
			NULL,
		MENU_DEFAULT, 2,
		MENU_GEN_PIN_WINDOW, owner, "Add...",
		NULL);
	return obj;
}

/*
 * Create object `xversion_menu_nom' in the specified instance.
 */
Xv_opaque
skiptool_xversion_menu_nom_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	skiptool_xversion_menu_nom_item0_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_xversion_menu_nom_item1_callback(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Nomadic Security...",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "SKIP ",
			MENU_GEN_PROC, skiptool_xversion_menu_nom_item0_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "SKIP (version 1)",
			MENU_GEN_PROC, skiptool_xversion_menu_nom_item1_callback,
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `exc_menu' in the specified instance.
 */
Xv_opaque
skiptool_exc_menu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	skiptool_exc_menu_item0_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_exc_menu_item1_callback(Menu_item, Menu_generate);
	extern Xv_opaque	skiptool_xversion_menu_nom_create(caddr_t, Xv_opaque);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, owner ? "" : "Exclude...",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Host...",
			MENU_GEN_PROC, skiptool_exc_menu_item0_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Network...",
			MENU_GEN_PROC, skiptool_exc_menu_item1_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Nomadic",
			MENU_PULLRIGHT, skiptool_xversion_menu_nom_create(ip, owner),
			NULL,
		MENU_DEFAULT, 2,
		MENU_GEN_PIN_WINDOW, owner, "Exclude...",
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `base_window'.
 */
skiptool_base_window_objects *
skiptool_base_window_objects_initialize(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (skiptool_base_window_objects *) calloc(1, sizeof (skiptool_base_window_objects))))
		return (skiptool_base_window_objects *) NULL;
	if (!ip->base_window)
		ip->base_window = skiptool_base_window_base_window_create(ip, owner);
	if (!ip->host_panel)
		ip->host_panel = skiptool_base_window_host_panel_create(ip, ip->base_window);
	if (!ip->settings_button)
		ip->settings_button = skiptool_base_window_settings_button_create(ip, ip->host_panel);
	if (!ip->about_button)
		ip->about_button = skiptool_base_window_about_button_create(ip, ip->host_panel);
	if (!ip->controls1)
		ip->controls1 = skiptool_base_window_controls1_create(ip, ip->base_window);
	if (!ip->skip_icon)
		ip->skip_icon = skiptool_base_window_skip_icon_create(ip, ip->controls1);
	if (!ip->access_ctrl)
		ip->access_ctrl = skiptool_base_window_access_ctrl_create(ip, ip->controls1);
	if (!ip->message6)
		ip->message6 = skiptool_base_window_message6_create(ip, ip->controls1);
	if (!ip->access_mode)
		ip->access_mode = skiptool_base_window_access_mode_create(ip, ip->controls1);
	if (!ip->message12)
		ip->message12 = skiptool_base_window_message12_create(ip, ip->controls1);
	if (!ip->remote_panel)
		ip->remote_panel = skiptool_base_window_remote_panel_create(ip, ip->base_window);
	if (!ip->hostlist)
		ip->hostlist = skiptool_base_window_hostlist_create(ip, ip->remote_panel);
	if (!ip->xhostlist)
		ip->xhostlist = skiptool_base_window_xhostlist_create(ip, ip->remote_panel);
	if (!ip->to_x)
		ip->to_x = skiptool_base_window_to_x_create(ip, ip->remote_panel);
	if (!ip->to_a)
		ip->to_a = skiptool_base_window_to_a_create(ip, ip->remote_panel);
	if (!ip->controls8)
		ip->controls8 = skiptool_base_window_controls8_create(ip, ip->base_window);
	if (!ip->add_host_button)
		ip->add_host_button = skiptool_base_window_add_host_button_create(ip, ip->controls8);
	if (!ip->delete_button)
		ip->delete_button = skiptool_base_window_delete_button_create(ip, ip->controls8);
	if (!ip->add_xhost_button)
		ip->add_xhost_button = skiptool_base_window_add_xhost_button_create(ip, ip->controls8);
	if (!ip->delete_xbutton)
		ip->delete_xbutton = skiptool_base_window_delete_xbutton_create(ip, ip->controls8);
	return ip;
}

/*
 * Create object `base_window' in the specified instance.
 */
Xv_opaque
skiptool_base_window_base_window_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	base_window_image;
#include "skiptool_small.xbm"
	
	base_window_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, skiptool_small_bits,
		XV_WIDTH, skiptool_small_width,
		XV_HEIGHT, skiptool_small_height,
		NULL);
	obj = xv_create(owner, FRAME,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 535,
		XV_HEIGHT, 380,
		XV_LABEL, "Solaris SKIP ()",
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_ICON, xv_create(XV_NULL, ICON,
			ICON_IMAGE, base_window_image,
			XV_LABEL, "skip",
			NULL),
		NULL);
	return obj;
}

/*
 * Create object `host_panel' in the specified instance.
 */
Xv_opaque
skiptool_base_window_host_panel_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 40,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `settings_button' in the specified instance.
 */
Xv_opaque
skiptool_base_window_settings_button_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern Xv_opaque	skiptool_menu_create(caddr_t, Xv_opaque);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 8,
		PANEL_LABEL_STRING, "File",
		PANEL_ITEM_MENU, skiptool_menu_create((caddr_t) ip, ip->base_window),
		NULL);
	return obj;
}

/*
 * Create object `about_button' in the specified instance.
 */
Xv_opaque
skiptool_base_window_about_button_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_base_window_about_button_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 448,
		XV_Y, 8,
		PANEL_LABEL_STRING, "About...",
		PANEL_NOTIFY_PROC, skiptool_base_window_about_button_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `controls1' in the specified instance.
 */
Xv_opaque
skiptool_base_window_controls1_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 33,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 74,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_icon' in the specified instance.
 */
Xv_opaque
skiptool_base_window_skip_icon_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	skip_icon_image;
#include "skiptool_small.xbm"
	
	skip_icon_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, skiptool_small_bits,
		XV_WIDTH, skiptool_small_width,
		XV_HEIGHT, skiptool_small_height,
		NULL);
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 22,
		XV_Y, 10,
		PANEL_LABEL_IMAGE, skip_icon_image,
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `access_ctrl' in the specified instance.
 */
Xv_opaque
skiptool_base_window_access_ctrl_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_base_window_access_ctrl_notify_callback(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 280,
		XV_Y, 12,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_NOTIFY_PROC, skiptool_base_window_access_ctrl_notify_callback,
		PANEL_CHOICE_STRINGS,
			"disabled",
			"enabled",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `message6' in the specified instance.
 */
Xv_opaque
skiptool_base_window_message6_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 108,
		XV_Y, 17,
		PANEL_LABEL_STRING, "Access control is:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `access_mode' in the specified instance.
 */
Xv_opaque
skiptool_base_window_access_mode_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_base_window_access_mode_notify_callback(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 280,
		XV_Y, 36,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_NOTIFY_PROC, skiptool_base_window_access_mode_notify_callback,
		PANEL_CHOICE_STRINGS,
			"No access",
			"Ask for confirmation",
			"Add automatically",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `message12' in the specified instance.
 */
Xv_opaque
skiptool_base_window_message12_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 108,
		XV_Y, 40,
		PANEL_LABEL_STRING, "Unauthorized systems:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `remote_panel' in the specified instance.
 */
Xv_opaque
skiptool_base_window_remote_panel_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 102,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 249,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `hostlist' in the specified instance.
 */
Xv_opaque
skiptool_base_window_hostlist_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern int		hostlist_notify(Panel_item, char *, Xv_opaque, Panel_list_op, Event *, int);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_LIST,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 18,
		XV_Y, 18,
		PANEL_LIST_WIDTH, 210,
		PANEL_LIST_DISPLAY_ROWS, 9,
		PANEL_LABEL_STRING, "Authorized Systems:",
		PANEL_LAYOUT, PANEL_VERTICAL,
		PANEL_READ_ONLY, TRUE,
		PANEL_CHOOSE_ONE, TRUE,
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_NOTIFY_PROC, hostlist_notify,
		NULL);
	return obj;
}

/*
 * Create object `xhostlist' in the specified instance.
 */
Xv_opaque
skiptool_base_window_xhostlist_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern int		xhostlist_notify(Panel_item, char *, Xv_opaque, Panel_list_op, Event *, int);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_LIST,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 294,
		XV_Y, 18,
		PANEL_LIST_WIDTH, 210,
		PANEL_LIST_DISPLAY_ROWS, 9,
		PANEL_LABEL_STRING, "Excluded Systems:",
		PANEL_LAYOUT, PANEL_VERTICAL,
		PANEL_READ_ONLY, TRUE,
		PANEL_CHOOSE_ONE, TRUE,
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_NOTIFY_PROC, xhostlist_notify,
		NULL);
	return obj;
}

/*
 * Create object `to_x' in the specified instance.
 */
Xv_opaque
skiptool_base_window_to_x_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_base_window_to_x_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 252,
		XV_Y, 102,
		PANEL_LABEL_STRING, ">>",
		PANEL_INACTIVE, TRUE,
		PANEL_NOTIFY_PROC, skiptool_base_window_to_x_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `to_a' in the specified instance.
 */
Xv_opaque
skiptool_base_window_to_a_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_base_window_to_a_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 252,
		XV_Y, 132,
		PANEL_LABEL_STRING, "<<",
		PANEL_INACTIVE, TRUE,
		PANEL_NOTIFY_PROC, skiptool_base_window_to_a_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `controls8' in the specified instance.
 */
Xv_opaque
skiptool_base_window_controls8_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 345,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `add_host_button' in the specified instance.
 */
Xv_opaque
skiptool_base_window_add_host_button_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern Xv_opaque	skiptool_add_menu_create(caddr_t, Xv_opaque);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 48,
		XV_Y, 8,
		PANEL_LABEL_STRING, "Add",
		PANEL_ITEM_MENU, skiptool_add_menu_create((caddr_t) ip, ip->base_window),
		NULL);
	return obj;
}

/*
 * Create object `delete_button' in the specified instance.
 */
Xv_opaque
skiptool_base_window_delete_button_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_base_window_delete_button_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 126,
		XV_Y, 8,
		PANEL_LABEL_STRING, "Delete",
		PANEL_INACTIVE, TRUE,
		PANEL_NOTIFY_PROC, skiptool_base_window_delete_button_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `add_xhost_button' in the specified instance.
 */
Xv_opaque
skiptool_base_window_add_xhost_button_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern Xv_opaque	skiptool_exc_menu_create(caddr_t, Xv_opaque);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 336,
		XV_Y, 8,
		PANEL_LABEL_STRING, "Add",
		PANEL_ITEM_MENU, skiptool_exc_menu_create((caddr_t) ip, ip->base_window),
		NULL);
	return obj;
}

/*
 * Create object `delete_xbutton' in the specified instance.
 */
Xv_opaque
skiptool_base_window_delete_xbutton_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_base_window_delete_xbutton_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 414,
		XV_Y, 8,
		PANEL_LABEL_STRING, "Delete",
		PANEL_INACTIVE, TRUE,
		PANEL_NOTIFY_PROC, skiptool_base_window_delete_xbutton_notify_callback,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `key_params_win'.
 */
skiptool_key_params_win_objects *
skiptool_key_params_win_objects_initialize(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (skiptool_key_params_win_objects *) calloc(1, sizeof (skiptool_key_params_win_objects))))
		return (skiptool_key_params_win_objects *) NULL;
	if (!ip->key_params_win)
		ip->key_params_win = skiptool_key_params_win_key_params_win_create(ip, owner);
	if (!ip->controls4)
		ip->controls4 = skiptool_key_params_win_controls4_create(ip, ip->key_params_win);
	if (!ip->skip_key_max_use)
		ip->skip_key_max_use = skiptool_key_params_win_skip_key_max_use_create(ip, ip->controls4);
	if (!ip->message3)
		ip->message3 = skiptool_key_params_win_message3_create(ip, ip->controls4);
	if (!ip->message12)
		ip->message12 = skiptool_key_params_win_message12_create(ip, ip->controls4);
	if (!ip->skip_key_max_idle)
		ip->skip_key_max_idle = skiptool_key_params_win_skip_key_max_idle_create(ip, ip->controls4);
	if (!ip->message14)
		ip->message14 = skiptool_key_params_win_message14_create(ip, ip->controls4);
	if (!ip->message4)
		ip->message4 = skiptool_key_params_win_message4_create(ip, ip->controls4);
	if (!ip->skip_key_max_bytes)
		ip->skip_key_max_bytes = skiptool_key_params_win_skip_key_max_bytes_create(ip, ip->controls4);
	if (!ip->message15)
		ip->message15 = skiptool_key_params_win_message15_create(ip, ip->controls4);
	if (!ip->message2)
		ip->message2 = skiptool_key_params_win_message2_create(ip, ip->controls4);
	if (!ip->key_apply)
		ip->key_apply = skiptool_key_params_win_key_apply_create(ip, ip->controls4);
	if (!ip->key_default)
		ip->key_default = skiptool_key_params_win_key_default_create(ip, ip->controls4);
	if (!ip->key_cancel)
		ip->key_cancel = skiptool_key_params_win_key_cancel_create(ip, ip->controls4);
	return ip;
}

/*
 * Create object `key_params_win' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_key_params_win_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 414,
		XV_HEIGHT, 130,
		XV_LABEL, "Key Management Parameters",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `controls4' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_controls4_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `skip_key_max_use' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_skip_key_max_use_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 220,
		XV_Y, 16,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 100,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 30,
		PANEL_INACTIVE, TRUE,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `message3' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_message3_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 15,
		XV_Y, 17,
		PANEL_LABEL_STRING, "Change transmit keys every:",
		PANEL_LABEL_BOLD, TRUE,
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message12' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_message12_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 304,
		XV_Y, 18,
		PANEL_LABEL_STRING, "seconds",
		PANEL_LABEL_BOLD, TRUE,
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_key_max_idle' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_skip_key_max_idle_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 220,
		XV_Y, 40,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 10000,
		PANEL_MIN_VALUE, 5,
		PANEL_VALUE, 30,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `message14' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_message14_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 35,
		XV_Y, 42,
		PANEL_LABEL_STRING, "Delete unused keys after:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message4' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_message4_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 304,
		XV_Y, 42,
		PANEL_LABEL_STRING, "seconds",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_key_max_bytes' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_skip_key_max_bytes_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 220,
		XV_Y, 66,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 10000,
		PANEL_MIN_VALUE, 1,
		PANEL_VALUE, 512,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `message15' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_message15_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 89,
		XV_Y, 67,
		PANEL_LABEL_STRING, "Transmit at most:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message2' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_message2_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 304,
		XV_Y, 67,
		PANEL_LABEL_STRING, "kbytes per key",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `key_apply' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_key_apply_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_key_params_win_key_apply_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 85,
		XV_Y, 104,
		PANEL_LABEL_STRING, "Apply",
		PANEL_NOTIFY_PROC, skiptool_key_params_win_key_apply_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `key_default' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_key_default_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_key_params_win_key_default_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 175,
		XV_Y, 104,
		PANEL_LABEL_STRING, "Default",
		PANEL_NOTIFY_PROC, skiptool_key_params_win_key_default_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `key_cancel' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_key_cancel_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 277,
		XV_Y, 104,
		PANEL_LABEL_STRING, "Cancel",
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `required_win'.
 */
skiptool_required_win_objects *
skiptool_required_win_objects_initialize(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (skiptool_required_win_objects *) calloc(1, sizeof (skiptool_required_win_objects))))
		return (skiptool_required_win_objects *) NULL;
	if (!ip->required_win)
		ip->required_win = skiptool_required_win_required_win_create(ip, owner);
	if (!ip->controls5)
		ip->controls5 = skiptool_required_win_controls5_create(ip, ip->required_win);
	if (!ip->skip_icon)
		ip->skip_icon = skiptool_required_win_skip_icon_create(ip, ip->controls5);
	if (!ip->required_message)
		ip->required_message = skiptool_required_win_required_message_create(ip, ip->controls5);
	if (!ip->controls11)
		ip->controls11 = skiptool_required_win_controls11_create(ip, ip->required_win);
	if (!ip->message5)
		ip->message5 = skiptool_required_win_message5_create(ip, ip->controls11);
	if (!ip->message13)
		ip->message13 = skiptool_required_win_message13_create(ip, ip->controls11);
	if (!ip->required_list)
		ip->required_list = skiptool_required_win_required_list_create(ip, ip->controls11);
	if (!ip->controls12)
		ip->controls12 = skiptool_required_win_controls12_create(ip, ip->required_win);
	if (!ip->required_add)
		ip->required_add = skiptool_required_win_required_add_create(ip, ip->controls12);
	if (!ip->required_cancel)
		ip->required_cancel = skiptool_required_win_required_cancel_create(ip, ip->controls12);
	return ip;
}

/*
 * Create object `required_win' in the specified instance.
 */
Xv_opaque
skiptool_required_win_required_win_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 350,
		XV_HEIGHT, 300,
		XV_LABEL, "Required systems",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `controls5' in the specified instance.
 */
Xv_opaque
skiptool_required_win_controls5_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 70,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_icon' in the specified instance.
 */
Xv_opaque
skiptool_required_win_skip_icon_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	skip_icon_image;
#include "skiptool_small.xbm"
	
	skip_icon_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, skiptool_small_bits,
		XV_WIDTH, skiptool_small_width,
		XV_HEIGHT, skiptool_small_height,
		NULL);
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 12,
		PANEL_LABEL_IMAGE, skip_icon_image,
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `required_message' in the specified instance.
 */
Xv_opaque
skiptool_required_win_required_message_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 100,
		XV_Y, 36,
		PANEL_LABEL_STRING, "0 addresses currently in use",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `controls11' in the specified instance.
 */
Xv_opaque
skiptool_required_win_controls11_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 64,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 198,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message5' in the specified instance.
 */
Xv_opaque
skiptool_required_win_message5_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 12,
		PANEL_LABEL_STRING, "The addresses below are currently in use and should",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `message13' in the specified instance.
 */
Xv_opaque
skiptool_required_win_message13_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 22,
		XV_Y, 28,
		PANEL_LABEL_STRING, "be added to the access control list:",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `required_list' in the specified instance.
 */
Xv_opaque
skiptool_required_win_required_list_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_LIST,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 22,
		XV_Y, 52,
		PANEL_LIST_WIDTH, 300,
		PANEL_LIST_DISPLAY_ROWS, 6,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_CHOOSE_ONE, FALSE,
		PANEL_CHOOSE_NONE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `controls12' in the specified instance.
 */
Xv_opaque
skiptool_required_win_controls12_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 259,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `required_add' in the specified instance.
 */
Xv_opaque
skiptool_required_win_required_add_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_required_win_required_add_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 100,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Add",
		PANEL_NOTIFY_PROC, skiptool_required_win_required_add_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `required_cancel' in the specified instance.
 */
Xv_opaque
skiptool_required_win_required_cancel_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_required_win_required_cancel_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 194,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Cancel",
		PANEL_NOTIFY_PROC, skiptool_required_win_required_cancel_notify_callback,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `about_win'.
 */
skiptool_about_win_objects *
skiptool_about_win_objects_initialize(skiptool_about_win_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (skiptool_about_win_objects *) calloc(1, sizeof (skiptool_about_win_objects))))
		return (skiptool_about_win_objects *) NULL;
	if (!ip->about_win)
		ip->about_win = skiptool_about_win_about_win_create(ip, owner);
	if (!ip->controls2)
		ip->controls2 = skiptool_about_win_controls2_create(ip, ip->about_win);
	if (!ip->skip_icon)
		ip->skip_icon = skiptool_about_win_skip_icon_create(ip, ip->controls2);
	if (!ip->message8)
		ip->message8 = skiptool_about_win_message8_create(ip, ip->controls2);
	return ip;
}

/*
 * Create object `about_win' in the specified instance.
 */
Xv_opaque
skiptool_about_win_about_win_create(skiptool_about_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 260,
		XV_HEIGHT, 80,
		XV_LABEL, "About SKIP",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `controls2' in the specified instance.
 */
Xv_opaque
skiptool_about_win_controls2_create(skiptool_about_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_icon' in the specified instance.
 */
Xv_opaque
skiptool_about_win_skip_icon_create(skiptool_about_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	skip_icon_image;
#include "skiptool_small.xbm"
	
	skip_icon_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, skiptool_small_bits,
		XV_WIDTH, skiptool_small_width,
		XV_HEIGHT, skiptool_small_height,
		NULL);
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 14,
		XV_Y, 16,
		PANEL_LABEL_IMAGE, skip_icon_image,
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message8' in the specified instance.
 */
Xv_opaque
skiptool_about_win_message8_create(skiptool_about_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 90,
		XV_Y, 36,
		PANEL_LABEL_STRING, "SKIP version 1.00",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `hostwin_v2'.
 */
skiptool_hostwin_v2_objects *
skiptool_hostwin_v2_objects_initialize(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (skiptool_hostwin_v2_objects *) calloc(1, sizeof (skiptool_hostwin_v2_objects))))
		return (skiptool_hostwin_v2_objects *) NULL;
	if (!ip->hostwin_v2)
		ip->hostwin_v2 = skiptool_hostwin_v2_hostwin_v2_create(ip, owner);
	if (!ip->host_panel)
		ip->host_panel = skiptool_hostwin_v2_host_panel_create(ip, ip->hostwin_v2);
	if (!ip->skip_icon)
		ip->skip_icon = skiptool_hostwin_v2_skip_icon_create(ip, ip->host_panel);
	if (!ip->host_label)
		ip->host_label = skiptool_hostwin_v2_host_label_create(ip, ip->host_panel);
	if (!ip->addr)
		ip->addr = skiptool_hostwin_v2_addr_create(ip, ip->host_panel);
	if (!ip->tunnel_transport_panel)
		ip->tunnel_transport_panel = skiptool_hostwin_v2_tunnel_transport_panel_create(ip, ip->hostwin_v2);
	if (!ip->skip_mode)
		ip->skip_mode = skiptool_hostwin_v2_skip_mode_create(ip, ip->tunnel_transport_panel);
	if (!ip->message16)
		ip->message16 = skiptool_hostwin_v2_message16_create(ip, ip->tunnel_transport_panel);
	if (!ip->tunnel_label)
		ip->tunnel_label = skiptool_hostwin_v2_tunnel_label_create(ip, ip->tunnel_transport_panel);
	if (!ip->tunnel_addr)
		ip->tunnel_addr = skiptool_hostwin_v2_tunnel_addr_create(ip, ip->tunnel_transport_panel);
	if (!ip->v2_remote_keyid_panel)
		ip->v2_remote_keyid_panel = skiptool_hostwin_v2_v2_remote_keyid_panel_create(ip, ip->hostwin_v2);
	if (!ip->r_nsid)
		ip->r_nsid = skiptool_hostwin_v2_r_nsid_create(ip, ip->v2_remote_keyid_panel);
	if (!ip->r_nsid_msg)
		ip->r_nsid_msg = skiptool_hostwin_v2_r_nsid_msg_create(ip, ip->v2_remote_keyid_panel);
	if (!ip->keyid)
		ip->keyid = skiptool_hostwin_v2_keyid_create(ip, ip->v2_remote_keyid_panel);
	if (!ip->v2_local_keyid_panel)
		ip->v2_local_keyid_panel = skiptool_hostwin_v2_v2_local_keyid_panel_create(ip, ip->hostwin_v2);
	if (!ip->s_nsid)
		ip->s_nsid = skiptool_hostwin_v2_s_nsid_create(ip, ip->v2_local_keyid_panel);
	if (!ip->s_nsid_msg)
		ip->s_nsid_msg = skiptool_hostwin_v2_s_nsid_msg_create(ip, ip->v2_local_keyid_panel);
	if (!ip->local_keyid)
		ip->local_keyid = skiptool_hostwin_v2_local_keyid_create(ip, ip->v2_local_keyid_panel);
	if (!ip->v2_algs_panel)
		ip->v2_algs_panel = skiptool_hostwin_v2_v2_algs_panel_create(ip, ip->hostwin_v2);
	if (!ip->kij_alg)
		ip->kij_alg = skiptool_hostwin_v2_kij_alg_create(ip, ip->v2_algs_panel);
	if (!ip->kp_alg_msg)
		ip->kp_alg_msg = skiptool_hostwin_v2_kp_alg_msg_create(ip, ip->v2_algs_panel);
	if (!ip->kp_alg)
		ip->kp_alg = skiptool_hostwin_v2_kp_alg_create(ip, ip->v2_algs_panel);
	if (!ip->kij_alg_msg)
		ip->kij_alg_msg = skiptool_hostwin_v2_kij_alg_msg_create(ip, ip->v2_algs_panel);
	if (!ip->mac_alg)
		ip->mac_alg = skiptool_hostwin_v2_mac_alg_create(ip, ip->v2_algs_panel);
	if (!ip->mac_alg_msg)
		ip->mac_alg_msg = skiptool_hostwin_v2_mac_alg_msg_create(ip, ip->v2_algs_panel);
	if (!ip->comp_alg)
		ip->comp_alg = skiptool_hostwin_v2_comp_alg_create(ip, ip->v2_algs_panel);
	if (!ip->message10)
		ip->message10 = skiptool_hostwin_v2_message10_create(ip, ip->v2_algs_panel);
	if (!ip->apply_cancel_panel)
		ip->apply_cancel_panel = skiptool_hostwin_v2_apply_cancel_panel_create(ip, ip->hostwin_v2);
	if (!ip->win_apply)
		ip->win_apply = skiptool_hostwin_v2_win_apply_create(ip, ip->apply_cancel_panel);
	if (!ip->win_cancel)
		ip->win_cancel = skiptool_hostwin_v2_win_cancel_create(ip, ip->apply_cancel_panel);
	return ip;
}

/*
 * Create object `hostwin_v2' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_hostwin_v2_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 340,
		XV_HEIGHT, 434,
		XV_LABEL, "SKIP host properties",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `host_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_host_panel_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 45,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_icon' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_skip_icon_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	skip_icon_image;
#include "icon_v2.xbm"
	
	skip_icon_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, icon_v2_bits,
		XV_WIDTH, icon_v2_width,
		XV_HEIGHT, icon_v2_height,
		NULL);
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 13,
		PANEL_LABEL_IMAGE, skip_icon_image,
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `host_label' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_host_label_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 52,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Hostname:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `addr' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_addr_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 16,
		PANEL_VALUE_DISPLAY_LENGTH, 23,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_transport_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_tunnel_transport_panel_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 44,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 70,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_mode' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_skip_mode_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_hostwin_v2_skip_mode_notify_callback(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 11,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_VERTICAL,
		PANEL_NOTIFY_PROC, skiptool_hostwin_v2_skip_mode_notify_callback,
		PANEL_CHOICE_STRINGS,
			"Whole packet",
			"Data only",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `message16' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_message16_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 15,
		PANEL_LABEL_STRING, "Secure:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_label' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_tunnel_label_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 41,
		PANEL_LABEL_STRING, "Tunnel address:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_addr' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_tunnel_addr_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 41,
		PANEL_VALUE_DISPLAY_LENGTH, 19,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `v2_remote_keyid_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_v2_remote_keyid_panel_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 113,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 70,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `r_nsid' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_r_nsid_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_hostwin_v2_r_nsid_notify_callback(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 13,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_NOTIFY_PROC, skiptool_hostwin_v2_r_nsid_notify_callback,
		PANEL_CHOICE_STRING, 0, "Not present",
		NULL);
	return obj;
}

/*
 * Create object `r_nsid_msg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_r_nsid_msg_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 15,
		PANEL_LABEL_STRING, "Remote Key ID:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `keyid' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_keyid_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 39,
		PANEL_VALUE_DISPLAY_LENGTH, 34,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "ID:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `v2_local_keyid_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_v2_local_keyid_panel_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 182,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 70,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `s_nsid' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_s_nsid_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_hostwin_v2_s_nsid_notify_callback(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 9,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_NOTIFY_PROC, skiptool_hostwin_v2_s_nsid_notify_callback,
		PANEL_CHOICE_STRING, 0, "Not present",
		NULL);
	return obj;
}

/*
 * Create object `s_nsid_msg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_s_nsid_msg_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 14,
		PANEL_LABEL_STRING, "Local Key ID:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `local_keyid' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_local_keyid_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 34,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_LABEL_STRING, "ID:",
		PANEL_CHOICE_STRING, 0, "default local key",
		NULL);
	return obj;
}

/*
 * Create object `v2_algs_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_v2_algs_panel_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 251,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 145,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kij_alg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_kij_alg_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 8,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "none",
		NULL);
	return obj;
}

/*
 * Create object `kp_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_kp_alg_msg_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 13,
		PANEL_LABEL_STRING, "Key encryption:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kp_alg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_kp_alg_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 40,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "none",
		NULL);
	return obj;
}

/*
 * Create object `kij_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_kij_alg_msg_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 45,
		PANEL_LABEL_STRING, "Traffic encryption:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `mac_alg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_mac_alg_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 72,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "Off",
		NULL);
	return obj;
}

/*
 * Create object `mac_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_mac_alg_msg_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 77,
		PANEL_LABEL_STRING, "Authentication:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `comp_alg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_comp_alg_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 104,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "Off",
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message10' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_message10_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 109,
		PANEL_LABEL_STRING, "Compression:",
		PANEL_LABEL_BOLD, TRUE,
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `apply_cancel_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_apply_cancel_panel_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 394,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `win_apply' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_win_apply_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_hostwin_v2_win_apply_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 81,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Apply",
		PANEL_NOTIFY_PROC, skiptool_hostwin_v2_win_apply_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `win_cancel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v2_win_cancel_create(skiptool_hostwin_v2_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_hostwin_v2_win_cancel_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 201,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Cancel",
		PANEL_NOTIFY_PROC, skiptool_hostwin_v2_win_cancel_notify_callback,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `hostwin_raw'.
 */
skiptool_hostwin_raw_objects *
skiptool_hostwin_raw_objects_initialize(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (skiptool_hostwin_raw_objects *) calloc(1, sizeof (skiptool_hostwin_raw_objects))))
		return (skiptool_hostwin_raw_objects *) NULL;
	if (!ip->hostwin_raw)
		ip->hostwin_raw = skiptool_hostwin_raw_hostwin_raw_create(ip, owner);
	if (!ip->host_panel)
		ip->host_panel = skiptool_hostwin_raw_host_panel_create(ip, ip->hostwin_raw);
	if (!ip->skip_icon)
		ip->skip_icon = skiptool_hostwin_raw_skip_icon_create(ip, ip->host_panel);
	if (!ip->host_label)
		ip->host_label = skiptool_hostwin_raw_host_label_create(ip, ip->host_panel);
	if (!ip->addr)
		ip->addr = skiptool_hostwin_raw_addr_create(ip, ip->host_panel);
	if (!ip->tunnel_transport_panel)
		ip->tunnel_transport_panel = skiptool_hostwin_raw_tunnel_transport_panel_create(ip, ip->hostwin_raw);
	if (!ip->skip_mode)
		ip->skip_mode = skiptool_hostwin_raw_skip_mode_create(ip, ip->tunnel_transport_panel);
	if (!ip->message1)
		ip->message1 = skiptool_hostwin_raw_message1_create(ip, ip->tunnel_transport_panel);
	if (!ip->tunnel_label)
		ip->tunnel_label = skiptool_hostwin_raw_tunnel_label_create(ip, ip->tunnel_transport_panel);
	if (!ip->tunnel_addr)
		ip->tunnel_addr = skiptool_hostwin_raw_tunnel_addr_create(ip, ip->tunnel_transport_panel);
	if (!ip->local_spi_panel)
		ip->local_spi_panel = skiptool_hostwin_raw_local_spi_panel_create(ip, ip->hostwin_raw);
	if (!ip->local_keyid)
		ip->local_keyid = skiptool_hostwin_raw_local_keyid_create(ip, ip->local_spi_panel);
	if (!ip->s_nsid_msg)
		ip->s_nsid_msg = skiptool_hostwin_raw_s_nsid_msg_create(ip, ip->local_spi_panel);
	if (!ip->remote_spi_panel)
		ip->remote_spi_panel = skiptool_hostwin_raw_remote_spi_panel_create(ip, ip->hostwin_raw);
	if (!ip->keyid)
		ip->keyid = skiptool_hostwin_raw_keyid_create(ip, ip->remote_spi_panel);
	if (!ip->r_nsid_msg)
		ip->r_nsid_msg = skiptool_hostwin_raw_r_nsid_msg_create(ip, ip->remote_spi_panel);
	if (!ip->raw_algs_panel)
		ip->raw_algs_panel = skiptool_hostwin_raw_raw_algs_panel_create(ip, ip->hostwin_raw);
	if (!ip->kp_alg)
		ip->kp_alg = skiptool_hostwin_raw_kp_alg_create(ip, ip->raw_algs_panel);
	if (!ip->kij_alg_msg)
		ip->kij_alg_msg = skiptool_hostwin_raw_kij_alg_msg_create(ip, ip->raw_algs_panel);
	if (!ip->mac_alg)
		ip->mac_alg = skiptool_hostwin_raw_mac_alg_create(ip, ip->raw_algs_panel);
	if (!ip->mac_alg_msg)
		ip->mac_alg_msg = skiptool_hostwin_raw_mac_alg_msg_create(ip, ip->raw_algs_panel);
	if (!ip->apply_cancel_panel)
		ip->apply_cancel_panel = skiptool_hostwin_raw_apply_cancel_panel_create(ip, ip->hostwin_raw);
	if (!ip->win_apply)
		ip->win_apply = skiptool_hostwin_raw_win_apply_create(ip, ip->apply_cancel_panel);
	if (!ip->win_cancel)
		ip->win_cancel = skiptool_hostwin_raw_win_cancel_create(ip, ip->apply_cancel_panel);
	return ip;
}

/*
 * Create object `hostwin_raw' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_hostwin_raw_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 340,
		XV_HEIGHT, 320,
		XV_LABEL, "ESP/AH host properties",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `host_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_host_panel_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 45,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_icon' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_skip_icon_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	skip_icon_image;
#include "unknown.xbm"
	
	skip_icon_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, unknown_bits,
		XV_WIDTH, unknown_width,
		XV_HEIGHT, unknown_height,
		NULL);
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 13,
		PANEL_LABEL_IMAGE, skip_icon_image,
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `host_label' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_host_label_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 52,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Hostname:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `addr' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_addr_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 16,
		PANEL_VALUE_DISPLAY_LENGTH, 23,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_transport_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_tunnel_transport_panel_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 44,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 70,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_mode' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_skip_mode_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_hostwin_raw_skip_mode_notify_callback(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 11,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_VERTICAL,
		PANEL_NOTIFY_PROC, skiptool_hostwin_raw_skip_mode_notify_callback,
		PANEL_CHOICE_STRINGS,
			"Whole packet",
			"Data only",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `message1' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_message1_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 15,
		PANEL_LABEL_STRING, "Secure:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_label' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_tunnel_label_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 41,
		PANEL_LABEL_STRING, "Tunnel address:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_addr' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_tunnel_addr_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 41,
		PANEL_VALUE_DISPLAY_LENGTH, 19,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `local_spi_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_local_spi_panel_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 106,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 40,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `local_keyid' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_local_keyid_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 106,
		XV_Y, 13,
		PANEL_VALUE_DISPLAY_LENGTH, 16,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `s_nsid_msg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_s_nsid_msg_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 14,
		PANEL_LABEL_STRING, "Local SPI:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `remote_spi_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_remote_spi_panel_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 145,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 45,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `keyid' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_keyid_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 106,
		XV_Y, 15,
		PANEL_VALUE_DISPLAY_LENGTH, 16,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `r_nsid_msg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_r_nsid_msg_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Remote SPI:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `raw_algs_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_raw_algs_panel_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 189,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 92,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kp_alg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_kp_alg_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 16,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "none",
		NULL);
	return obj;
}

/*
 * Create object `kij_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_kij_alg_msg_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 21,
		PANEL_LABEL_STRING, "Traffic encryption:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `mac_alg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_mac_alg_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 48,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "Off",
		NULL);
	return obj;
}

/*
 * Create object `mac_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_mac_alg_msg_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 53,
		PANEL_LABEL_STRING, "Authentication:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `apply_cancel_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_apply_cancel_panel_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 280,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `win_apply' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_win_apply_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_hostwin_raw_win_apply_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 81,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Apply",
		PANEL_NOTIFY_PROC, skiptool_hostwin_raw_win_apply_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `win_cancel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_raw_win_cancel_create(skiptool_hostwin_raw_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_hostwin_raw_win_cancel_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 201,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Cancel",
		PANEL_NOTIFY_PROC, skiptool_hostwin_raw_win_cancel_notify_callback,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `hostwin_v1'.
 */
skiptool_hostwin_v1_objects *
skiptool_hostwin_v1_objects_initialize(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (skiptool_hostwin_v1_objects *) calloc(1, sizeof (skiptool_hostwin_v1_objects))))
		return (skiptool_hostwin_v1_objects *) NULL;
	if (!ip->hostwin_v1)
		ip->hostwin_v1 = skiptool_hostwin_v1_hostwin_v1_create(ip, owner);
	if (!ip->host_panel)
		ip->host_panel = skiptool_hostwin_v1_host_panel_create(ip, ip->hostwin_v1);
	if (!ip->skip_icon)
		ip->skip_icon = skiptool_hostwin_v1_skip_icon_create(ip, ip->host_panel);
	if (!ip->host_label)
		ip->host_label = skiptool_hostwin_v1_host_label_create(ip, ip->host_panel);
	if (!ip->addr)
		ip->addr = skiptool_hostwin_v1_addr_create(ip, ip->host_panel);
	if (!ip->v1_remote_keyid_panel)
		ip->v1_remote_keyid_panel = skiptool_hostwin_v1_v1_remote_keyid_panel_create(ip, ip->hostwin_v1);
	if (!ip->keyid)
		ip->keyid = skiptool_hostwin_v1_keyid_create(ip, ip->v1_remote_keyid_panel);
	if (!ip->message24)
		ip->message24 = skiptool_hostwin_v1_message24_create(ip, ip->v1_remote_keyid_panel);
	if (!ip->v1_local_keyid_panel)
		ip->v1_local_keyid_panel = skiptool_hostwin_v1_v1_local_keyid_panel_create(ip, ip->hostwin_v1);
	if (!ip->local_keyid)
		ip->local_keyid = skiptool_hostwin_v1_local_keyid_create(ip, ip->v1_local_keyid_panel);
	if (!ip->message23)
		ip->message23 = skiptool_hostwin_v1_message23_create(ip, ip->v1_local_keyid_panel);
	if (!ip->tunnel_address_panel)
		ip->tunnel_address_panel = skiptool_hostwin_v1_tunnel_address_panel_create(ip, ip->hostwin_v1);
	if (!ip->tunnel_label)
		ip->tunnel_label = skiptool_hostwin_v1_tunnel_label_create(ip, ip->tunnel_address_panel);
	if (!ip->tunnel_addr)
		ip->tunnel_addr = skiptool_hostwin_v1_tunnel_addr_create(ip, ip->tunnel_address_panel);
	if (!ip->v1_algs_panel)
		ip->v1_algs_panel = skiptool_hostwin_v1_v1_algs_panel_create(ip, ip->hostwin_v1);
	if (!ip->kij_alg)
		ip->kij_alg = skiptool_hostwin_v1_kij_alg_create(ip, ip->v1_algs_panel);
	if (!ip->kp_alg_msg)
		ip->kp_alg_msg = skiptool_hostwin_v1_kp_alg_msg_create(ip, ip->v1_algs_panel);
	if (!ip->kp_alg)
		ip->kp_alg = skiptool_hostwin_v1_kp_alg_create(ip, ip->v1_algs_panel);
	if (!ip->kij_alg_msg)
		ip->kij_alg_msg = skiptool_hostwin_v1_kij_alg_msg_create(ip, ip->v1_algs_panel);
	if (!ip->apply_cancel_panel)
		ip->apply_cancel_panel = skiptool_hostwin_v1_apply_cancel_panel_create(ip, ip->hostwin_v1);
	if (!ip->win_apply)
		ip->win_apply = skiptool_hostwin_v1_win_apply_create(ip, ip->apply_cancel_panel);
	if (!ip->win_cancel)
		ip->win_cancel = skiptool_hostwin_v1_win_cancel_create(ip, ip->apply_cancel_panel);
	return ip;
}

/*
 * Create object `hostwin_v1' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_hostwin_v1_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 340,
		XV_HEIGHT, 305,
		XV_LABEL, "SKIP version 1 properties",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `host_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_host_panel_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_icon' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_skip_icon_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	skip_icon_image;
#include "icon_v1.xbm"
	
	skip_icon_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, icon_v1_bits,
		XV_WIDTH, icon_v1_width,
		XV_HEIGHT, icon_v1_height,
		NULL);
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 13,
		PANEL_LABEL_IMAGE, skip_icon_image,
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `host_label' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_host_label_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 52,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Hostname:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `addr' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_addr_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 16,
		PANEL_VALUE_DISPLAY_LENGTH, 23,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `v1_remote_keyid_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_v1_remote_keyid_panel_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 44,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `keyid' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_keyid_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 15,
		PANEL_VALUE_DISPLAY_LENGTH, 23,
		PANEL_VALUE_STORED_LENGTH, 30,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `message24' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_message24_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Node ID:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `v1_local_keyid_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_v1_local_keyid_panel_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 88,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `local_keyid' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_local_keyid_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 11,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "default local key",
		NULL);
	return obj;
}

/*
 * Create object `message23' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_message23_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Local key ID:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_address_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_tunnel_address_panel_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 132,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_label' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_tunnel_label_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Tunnel Address:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_addr' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_tunnel_addr_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 16,
		PANEL_VALUE_DISPLAY_LENGTH, 20,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `v1_algs_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_v1_algs_panel_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 176,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kij_alg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_kij_alg_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 14,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "none",
		NULL);
	return obj;
}

/*
 * Create object `kp_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_kp_alg_msg_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 19,
		PANEL_LABEL_STRING, "Key encryption:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kp_alg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_kp_alg_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 46,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "none",
		NULL);
	return obj;
}

/*
 * Create object `kij_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_kij_alg_msg_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 51,
		PANEL_LABEL_STRING, "Traffic encryption:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `apply_cancel_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_apply_cancel_panel_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 265,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `win_apply' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_win_apply_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_hostwin_v1_win_apply_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 81,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Apply",
		PANEL_NOTIFY_PROC, skiptool_hostwin_v1_win_apply_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `win_cancel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_v1_win_cancel_create(skiptool_hostwin_v1_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_hostwin_v1_win_cancel_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 201,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Cancel",
		PANEL_NOTIFY_PROC, skiptool_hostwin_v1_win_cancel_notify_callback,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `hostwin'.
 */
skiptool_hostwin_objects *
skiptool_hostwin_objects_initialize(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (skiptool_hostwin_objects *) calloc(1, sizeof (skiptool_hostwin_objects))))
		return (skiptool_hostwin_objects *) NULL;
	if (!ip->hostwin)
		ip->hostwin = skiptool_hostwin_hostwin_create(ip, owner);
	if (!ip->host_panel)
		ip->host_panel = skiptool_hostwin_host_panel_create(ip, ip->hostwin);
	if (!ip->skip_icon)
		ip->skip_icon = skiptool_hostwin_skip_icon_create(ip, ip->host_panel);
	if (!ip->host_label)
		ip->host_label = skiptool_hostwin_host_label_create(ip, ip->host_panel);
	if (!ip->addr)
		ip->addr = skiptool_hostwin_addr_create(ip, ip->host_panel);
	if (!ip->apply_cancel_panel)
		ip->apply_cancel_panel = skiptool_hostwin_apply_cancel_panel_create(ip, ip->hostwin);
	if (!ip->win_apply)
		ip->win_apply = skiptool_hostwin_win_apply_create(ip, ip->apply_cancel_panel);
	if (!ip->win_cancel)
		ip->win_cancel = skiptool_hostwin_win_cancel_create(ip, ip->apply_cancel_panel);
	return ip;
}

/*
 * Create object `hostwin' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_hostwin_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 340,
		XV_HEIGHT, 83,
		XV_LABEL, "Host properties",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `host_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_host_panel_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 44,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_icon' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_skip_icon_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	skip_icon_image;
#include "none.xbm"
	
	skip_icon_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, none_bits,
		XV_WIDTH, none_width,
		XV_HEIGHT, none_height,
		NULL);
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 13,
		PANEL_LABEL_IMAGE, skip_icon_image,
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `host_label' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_host_label_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 52,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Hostname:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `addr' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_addr_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 16,
		PANEL_VALUE_DISPLAY_LENGTH, 23,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `apply_cancel_panel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_apply_cancel_panel_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 42,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `win_apply' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_win_apply_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_hostwin_win_apply_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 81,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Apply",
		PANEL_NOTIFY_PROC, skiptool_hostwin_win_apply_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `win_cancel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_win_cancel_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_hostwin_win_cancel_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 201,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Cancel",
		PANEL_NOTIFY_PROC, skiptool_hostwin_win_cancel_notify_callback,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `netwin_raw'.
 */
skiptool_netwin_raw_objects *
skiptool_netwin_raw_objects_initialize(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (skiptool_netwin_raw_objects *) calloc(1, sizeof (skiptool_netwin_raw_objects))))
		return (skiptool_netwin_raw_objects *) NULL;
	if (!ip->netwin_raw)
		ip->netwin_raw = skiptool_netwin_raw_netwin_raw_create(ip, owner);
	if (!ip->net_panel)
		ip->net_panel = skiptool_netwin_raw_net_panel_create(ip, ip->netwin_raw);
	if (!ip->net_label)
		ip->net_label = skiptool_netwin_raw_net_label_create(ip, ip->net_panel);
	if (!ip->addr)
		ip->addr = skiptool_netwin_raw_addr_create(ip, ip->net_panel);
	if (!ip->skip_icon)
		ip->skip_icon = skiptool_netwin_raw_skip_icon_create(ip, ip->net_panel);
	if (!ip->mask_label)
		ip->mask_label = skiptool_netwin_raw_mask_label_create(ip, ip->net_panel);
	if (!ip->mask)
		ip->mask = skiptool_netwin_raw_mask_create(ip, ip->net_panel);
	if (!ip->tunnel_transport_panel)
		ip->tunnel_transport_panel = skiptool_netwin_raw_tunnel_transport_panel_create(ip, ip->netwin_raw);
	if (!ip->skip_mode)
		ip->skip_mode = skiptool_netwin_raw_skip_mode_create(ip, ip->tunnel_transport_panel);
	if (!ip->message9)
		ip->message9 = skiptool_netwin_raw_message9_create(ip, ip->tunnel_transport_panel);
	if (!ip->tunnel_label)
		ip->tunnel_label = skiptool_netwin_raw_tunnel_label_create(ip, ip->tunnel_transport_panel);
	if (!ip->tunnel_addr)
		ip->tunnel_addr = skiptool_netwin_raw_tunnel_addr_create(ip, ip->tunnel_transport_panel);
	if (!ip->local_spi_panel)
		ip->local_spi_panel = skiptool_netwin_raw_local_spi_panel_create(ip, ip->netwin_raw);
	if (!ip->local_keyid)
		ip->local_keyid = skiptool_netwin_raw_local_keyid_create(ip, ip->local_spi_panel);
	if (!ip->s_nsid_msg)
		ip->s_nsid_msg = skiptool_netwin_raw_s_nsid_msg_create(ip, ip->local_spi_panel);
	if (!ip->remote_spi_panel)
		ip->remote_spi_panel = skiptool_netwin_raw_remote_spi_panel_create(ip, ip->netwin_raw);
	if (!ip->keyid)
		ip->keyid = skiptool_netwin_raw_keyid_create(ip, ip->remote_spi_panel);
	if (!ip->r_nsid_msg)
		ip->r_nsid_msg = skiptool_netwin_raw_r_nsid_msg_create(ip, ip->remote_spi_panel);
	if (!ip->raw_algs_panel)
		ip->raw_algs_panel = skiptool_netwin_raw_raw_algs_panel_create(ip, ip->netwin_raw);
	if (!ip->kp_alg)
		ip->kp_alg = skiptool_netwin_raw_kp_alg_create(ip, ip->raw_algs_panel);
	if (!ip->kij_alg_msg)
		ip->kij_alg_msg = skiptool_netwin_raw_kij_alg_msg_create(ip, ip->raw_algs_panel);
	if (!ip->mac_alg)
		ip->mac_alg = skiptool_netwin_raw_mac_alg_create(ip, ip->raw_algs_panel);
	if (!ip->mac_alg_msg)
		ip->mac_alg_msg = skiptool_netwin_raw_mac_alg_msg_create(ip, ip->raw_algs_panel);
	if (!ip->apply_cancel_panel)
		ip->apply_cancel_panel = skiptool_netwin_raw_apply_cancel_panel_create(ip, ip->netwin_raw);
	if (!ip->win_apply)
		ip->win_apply = skiptool_netwin_raw_win_apply_create(ip, ip->apply_cancel_panel);
	if (!ip->win_cancel)
		ip->win_cancel = skiptool_netwin_raw_win_cancel_create(ip, ip->apply_cancel_panel);
	return ip;
}

/*
 * Create object `netwin_raw' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_netwin_raw_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 340,
		XV_HEIGHT, 343,
		XV_LABEL, "ESP/AH network properties",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `net_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_net_panel_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 67,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `net_label' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_net_label_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 60,
		XV_Y, 17,
		PANEL_LABEL_STRING, "Network:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `addr' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_addr_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 17,
		PANEL_VALUE_DISPLAY_LENGTH, 23,
		PANEL_VALUE_STORED_LENGTH, 24,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `skip_icon' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_skip_icon_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	skip_icon_image;
#include "unknown.xbm"
	
	skip_icon_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, unknown_bits,
		XV_WIDTH, unknown_width,
		XV_HEIGHT, unknown_height,
		NULL);
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 20,
		PANEL_LABEL_IMAGE, skip_icon_image,
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `mask_label' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_mask_label_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 60,
		XV_Y, 39,
		PANEL_LABEL_STRING, "Netmask:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `mask' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_mask_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 39,
		PANEL_VALUE_DISPLAY_LENGTH, 23,
		PANEL_VALUE_STORED_LENGTH, 24,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE, "255.255.255.0",
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_transport_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_tunnel_transport_panel_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 66,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 70,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_mode' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_skip_mode_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_netwin_raw_skip_mode_notify_callback(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 11,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_VERTICAL,
		PANEL_NOTIFY_PROC, skiptool_netwin_raw_skip_mode_notify_callback,
		PANEL_CHOICE_STRINGS,
			"Whole packet",
			"Data only",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `message9' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_message9_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 15,
		PANEL_LABEL_STRING, "Secure:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_label' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_tunnel_label_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 41,
		PANEL_LABEL_STRING, "Tunnel address:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_addr' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_tunnel_addr_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 41,
		PANEL_VALUE_DISPLAY_LENGTH, 19,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `local_spi_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_local_spi_panel_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 129,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 40,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `local_keyid' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_local_keyid_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 106,
		XV_Y, 13,
		PANEL_VALUE_DISPLAY_LENGTH, 16,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `s_nsid_msg' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_s_nsid_msg_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 14,
		PANEL_LABEL_STRING, "Local SPI:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `remote_spi_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_remote_spi_panel_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 168,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 45,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `keyid' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_keyid_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 106,
		XV_Y, 15,
		PANEL_VALUE_DISPLAY_LENGTH, 16,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `r_nsid_msg' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_r_nsid_msg_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Remote SPI:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `raw_algs_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_raw_algs_panel_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 212,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 92,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kp_alg' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_kp_alg_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 16,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "none",
		NULL);
	return obj;
}

/*
 * Create object `kij_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_kij_alg_msg_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 21,
		PANEL_LABEL_STRING, "Traffic encryption:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `mac_alg' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_mac_alg_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 48,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "Off",
		NULL);
	return obj;
}

/*
 * Create object `mac_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_mac_alg_msg_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 53,
		PANEL_LABEL_STRING, "Authentication:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `apply_cancel_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_apply_cancel_panel_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 303,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `win_apply' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_win_apply_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_netwin_raw_win_apply_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 81,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Apply",
		PANEL_NOTIFY_PROC, skiptool_netwin_raw_win_apply_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `win_cancel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_raw_win_cancel_create(skiptool_netwin_raw_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_netwin_raw_win_cancel_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 201,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Cancel",
		PANEL_NOTIFY_PROC, skiptool_netwin_raw_win_cancel_notify_callback,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `netwin'.
 */
skiptool_netwin_objects *
skiptool_netwin_objects_initialize(skiptool_netwin_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (skiptool_netwin_objects *) calloc(1, sizeof (skiptool_netwin_objects))))
		return (skiptool_netwin_objects *) NULL;
	if (!ip->netwin)
		ip->netwin = skiptool_netwin_netwin_create(ip, owner);
	if (!ip->net_panel)
		ip->net_panel = skiptool_netwin_net_panel_create(ip, ip->netwin);
	if (!ip->net_label)
		ip->net_label = skiptool_netwin_net_label_create(ip, ip->net_panel);
	if (!ip->addr)
		ip->addr = skiptool_netwin_addr_create(ip, ip->net_panel);
	if (!ip->skip_icon)
		ip->skip_icon = skiptool_netwin_skip_icon_create(ip, ip->net_panel);
	if (!ip->mask_label)
		ip->mask_label = skiptool_netwin_mask_label_create(ip, ip->net_panel);
	if (!ip->mask)
		ip->mask = skiptool_netwin_mask_create(ip, ip->net_panel);
	if (!ip->apply_cancel_panel)
		ip->apply_cancel_panel = skiptool_netwin_apply_cancel_panel_create(ip, ip->netwin);
	if (!ip->win_apply)
		ip->win_apply = skiptool_netwin_win_apply_create(ip, ip->apply_cancel_panel);
	if (!ip->win_cancel)
		ip->win_cancel = skiptool_netwin_win_cancel_create(ip, ip->apply_cancel_panel);
	return ip;
}

/*
 * Create object `netwin' in the specified instance.
 */
Xv_opaque
skiptool_netwin_netwin_create(skiptool_netwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 340,
		XV_HEIGHT, 109,
		XV_LABEL, "Network properties",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `net_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_net_panel_create(skiptool_netwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 70,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `net_label' in the specified instance.
 */
Xv_opaque
skiptool_netwin_net_label_create(skiptool_netwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 60,
		XV_Y, 17,
		PANEL_LABEL_STRING, "Network:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `addr' in the specified instance.
 */
Xv_opaque
skiptool_netwin_addr_create(skiptool_netwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 17,
		PANEL_VALUE_DISPLAY_LENGTH, 23,
		PANEL_VALUE_STORED_LENGTH, 24,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `skip_icon' in the specified instance.
 */
Xv_opaque
skiptool_netwin_skip_icon_create(skiptool_netwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	skip_icon_image;
#include "none.xbm"
	
	skip_icon_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, none_bits,
		XV_WIDTH, none_width,
		XV_HEIGHT, none_height,
		NULL);
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 20,
		PANEL_LABEL_IMAGE, skip_icon_image,
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `mask_label' in the specified instance.
 */
Xv_opaque
skiptool_netwin_mask_label_create(skiptool_netwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 60,
		XV_Y, 39,
		PANEL_LABEL_STRING, "Netmask:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `mask' in the specified instance.
 */
Xv_opaque
skiptool_netwin_mask_create(skiptool_netwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 39,
		PANEL_VALUE_DISPLAY_LENGTH, 23,
		PANEL_VALUE_STORED_LENGTH, 24,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE, "255.255.255.0",
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `apply_cancel_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_apply_cancel_panel_create(skiptool_netwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 69,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `win_apply' in the specified instance.
 */
Xv_opaque
skiptool_netwin_win_apply_create(skiptool_netwin_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_netwin_win_apply_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 81,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Apply",
		PANEL_NOTIFY_PROC, skiptool_netwin_win_apply_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `win_cancel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_win_cancel_create(skiptool_netwin_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_netwin_win_cancel_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 201,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Cancel",
		PANEL_NOTIFY_PROC, skiptool_netwin_win_cancel_notify_callback,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `netwin_v1'.
 */
skiptool_netwin_v1_objects *
skiptool_netwin_v1_objects_initialize(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (skiptool_netwin_v1_objects *) calloc(1, sizeof (skiptool_netwin_v1_objects))))
		return (skiptool_netwin_v1_objects *) NULL;
	if (!ip->netwin_v1)
		ip->netwin_v1 = skiptool_netwin_v1_netwin_v1_create(ip, owner);
	if (!ip->net_panel)
		ip->net_panel = skiptool_netwin_v1_net_panel_create(ip, ip->netwin_v1);
	if (!ip->net_label)
		ip->net_label = skiptool_netwin_v1_net_label_create(ip, ip->net_panel);
	if (!ip->addr)
		ip->addr = skiptool_netwin_v1_addr_create(ip, ip->net_panel);
	if (!ip->skip_icon)
		ip->skip_icon = skiptool_netwin_v1_skip_icon_create(ip, ip->net_panel);
	if (!ip->mask_label)
		ip->mask_label = skiptool_netwin_v1_mask_label_create(ip, ip->net_panel);
	if (!ip->mask)
		ip->mask = skiptool_netwin_v1_mask_create(ip, ip->net_panel);
	if (!ip->v1_remote_keyid_panel)
		ip->v1_remote_keyid_panel = skiptool_netwin_v1_v1_remote_keyid_panel_create(ip, ip->netwin_v1);
	if (!ip->keyid)
		ip->keyid = skiptool_netwin_v1_keyid_create(ip, ip->v1_remote_keyid_panel);
	if (!ip->message25)
		ip->message25 = skiptool_netwin_v1_message25_create(ip, ip->v1_remote_keyid_panel);
	if (!ip->v1_local_keyid_panel)
		ip->v1_local_keyid_panel = skiptool_netwin_v1_v1_local_keyid_panel_create(ip, ip->netwin_v1);
	if (!ip->local_keyid)
		ip->local_keyid = skiptool_netwin_v1_local_keyid_create(ip, ip->v1_local_keyid_panel);
	if (!ip->message11)
		ip->message11 = skiptool_netwin_v1_message11_create(ip, ip->v1_local_keyid_panel);
	if (!ip->tunnel_address_panel)
		ip->tunnel_address_panel = skiptool_netwin_v1_tunnel_address_panel_create(ip, ip->netwin_v1);
	if (!ip->tunnel_label)
		ip->tunnel_label = skiptool_netwin_v1_tunnel_label_create(ip, ip->tunnel_address_panel);
	if (!ip->tunnel_addr)
		ip->tunnel_addr = skiptool_netwin_v1_tunnel_addr_create(ip, ip->tunnel_address_panel);
	if (!ip->v1_algs_panel)
		ip->v1_algs_panel = skiptool_netwin_v1_v1_algs_panel_create(ip, ip->netwin_v1);
	if (!ip->kij_alg)
		ip->kij_alg = skiptool_netwin_v1_kij_alg_create(ip, ip->v1_algs_panel);
	if (!ip->kp_alg_msg)
		ip->kp_alg_msg = skiptool_netwin_v1_kp_alg_msg_create(ip, ip->v1_algs_panel);
	if (!ip->kp_alg)
		ip->kp_alg = skiptool_netwin_v1_kp_alg_create(ip, ip->v1_algs_panel);
	if (!ip->kij_alg_msg)
		ip->kij_alg_msg = skiptool_netwin_v1_kij_alg_msg_create(ip, ip->v1_algs_panel);
	if (!ip->apply_cancel_panel)
		ip->apply_cancel_panel = skiptool_netwin_v1_apply_cancel_panel_create(ip, ip->netwin_v1);
	if (!ip->win_apply)
		ip->win_apply = skiptool_netwin_v1_win_apply_create(ip, ip->apply_cancel_panel);
	if (!ip->win_cancel)
		ip->win_cancel = skiptool_netwin_v1_win_cancel_create(ip, ip->apply_cancel_panel);
	return ip;
}

/*
 * Create object `netwin_v1' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_netwin_v1_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 340,
		XV_HEIGHT, 329,
		XV_LABEL, "SKIP version 1 properties",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `net_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_net_panel_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 70,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `net_label' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_net_label_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 60,
		XV_Y, 17,
		PANEL_LABEL_STRING, "Network:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `addr' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_addr_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 17,
		PANEL_VALUE_DISPLAY_LENGTH, 23,
		PANEL_VALUE_STORED_LENGTH, 24,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `skip_icon' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_skip_icon_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	skip_icon_image;
#include "icon_v1.xbm"
	
	skip_icon_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, icon_v1_bits,
		XV_WIDTH, icon_v1_width,
		XV_HEIGHT, icon_v1_height,
		NULL);
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 20,
		PANEL_LABEL_IMAGE, skip_icon_image,
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `mask_label' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_mask_label_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 60,
		XV_Y, 39,
		PANEL_LABEL_STRING, "Netmask:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `mask' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_mask_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 39,
		PANEL_VALUE_DISPLAY_LENGTH, 23,
		PANEL_VALUE_STORED_LENGTH, 24,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE, "255.255.255.0",
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `v1_remote_keyid_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_v1_remote_keyid_panel_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 69,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 45,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `keyid' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_keyid_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 15,
		PANEL_VALUE_DISPLAY_LENGTH, 23,
		PANEL_VALUE_STORED_LENGTH, 30,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `message25' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_message25_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Node ID:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `v1_local_keyid_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_v1_local_keyid_panel_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 113,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 45,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `local_keyid' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_local_keyid_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 11,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "default local key",
		NULL);
	return obj;
}

/*
 * Create object `message11' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_message11_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Local key ID:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_address_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_tunnel_address_panel_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 157,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 45,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_label' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_tunnel_label_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Tunnel Address:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_addr' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_tunnel_addr_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 16,
		PANEL_VALUE_DISPLAY_LENGTH, 20,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `v1_algs_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_v1_algs_panel_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 201,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 90,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kij_alg' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_kij_alg_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 14,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "none",
		NULL);
	return obj;
}

/*
 * Create object `kp_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_kp_alg_msg_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 19,
		PANEL_LABEL_STRING, "Key encryption:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kp_alg' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_kp_alg_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 46,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "none",
		NULL);
	return obj;
}

/*
 * Create object `kij_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_kij_alg_msg_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 51,
		PANEL_LABEL_STRING, "Traffic encryption:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `apply_cancel_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_apply_cancel_panel_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 289,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `win_apply' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_win_apply_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_netwin_v1_win_apply_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 81,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Apply",
		PANEL_NOTIFY_PROC, skiptool_netwin_v1_win_apply_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `win_cancel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v1_win_cancel_create(skiptool_netwin_v1_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_netwin_v1_win_cancel_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 201,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Cancel",
		PANEL_NOTIFY_PROC, skiptool_netwin_v1_win_cancel_notify_callback,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `nomwin_v1'.
 */
skiptool_nomwin_v1_objects *
skiptool_nomwin_v1_objects_initialize(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (skiptool_nomwin_v1_objects *) calloc(1, sizeof (skiptool_nomwin_v1_objects))))
		return (skiptool_nomwin_v1_objects *) NULL;
	if (!ip->nomwin_v1)
		ip->nomwin_v1 = skiptool_nomwin_v1_nomwin_v1_create(ip, owner);
	if (!ip->v1_nomadic_panel)
		ip->v1_nomadic_panel = skiptool_nomwin_v1_v1_nomadic_panel_create(ip, ip->nomwin_v1);
	if (!ip->skip_icon)
		ip->skip_icon = skiptool_nomwin_v1_skip_icon_create(ip, ip->v1_nomadic_panel);
	if (!ip->keyid)
		ip->keyid = skiptool_nomwin_v1_keyid_create(ip, ip->v1_nomadic_panel);
	if (!ip->controls3)
		ip->controls3 = skiptool_nomwin_v1_controls3_create(ip, ip->nomwin_v1);
	if (!ip->tunnel_label)
		ip->tunnel_label = skiptool_nomwin_v1_tunnel_label_create(ip, ip->controls3);
	if (!ip->tunnel_addr)
		ip->tunnel_addr = skiptool_nomwin_v1_tunnel_addr_create(ip, ip->controls3);
	if (!ip->v1_local_keyid_panel)
		ip->v1_local_keyid_panel = skiptool_nomwin_v1_v1_local_keyid_panel_create(ip, ip->nomwin_v1);
	if (!ip->local_keyid)
		ip->local_keyid = skiptool_nomwin_v1_local_keyid_create(ip, ip->v1_local_keyid_panel);
	if (!ip->message17)
		ip->message17 = skiptool_nomwin_v1_message17_create(ip, ip->v1_local_keyid_panel);
	if (!ip->v1_algs_panel)
		ip->v1_algs_panel = skiptool_nomwin_v1_v1_algs_panel_create(ip, ip->nomwin_v1);
	if (!ip->kij_alg)
		ip->kij_alg = skiptool_nomwin_v1_kij_alg_create(ip, ip->v1_algs_panel);
	if (!ip->kp_alg_msg)
		ip->kp_alg_msg = skiptool_nomwin_v1_kp_alg_msg_create(ip, ip->v1_algs_panel);
	if (!ip->kp_alg)
		ip->kp_alg = skiptool_nomwin_v1_kp_alg_create(ip, ip->v1_algs_panel);
	if (!ip->kij_alg_msg)
		ip->kij_alg_msg = skiptool_nomwin_v1_kij_alg_msg_create(ip, ip->v1_algs_panel);
	if (!ip->current_addr_panel)
		ip->current_addr_panel = skiptool_nomwin_v1_current_addr_panel_create(ip, ip->nomwin_v1);
	if (!ip->current_addr)
		ip->current_addr = skiptool_nomwin_v1_current_addr_create(ip, ip->current_addr_panel);
	if (!ip->message7)
		ip->message7 = skiptool_nomwin_v1_message7_create(ip, ip->current_addr_panel);
	if (!ip->apply_cancel_panel)
		ip->apply_cancel_panel = skiptool_nomwin_v1_apply_cancel_panel_create(ip, ip->nomwin_v1);
	if (!ip->win_apply)
		ip->win_apply = skiptool_nomwin_v1_win_apply_create(ip, ip->apply_cancel_panel);
	if (!ip->win_cancel)
		ip->win_cancel = skiptool_nomwin_v1_win_cancel_create(ip, ip->apply_cancel_panel);
	return ip;
}

/*
 * Create object `nomwin_v1' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_nomwin_v1_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 340,
		XV_HEIGHT, 310,
		XV_LABEL, "SKIP version 1 (Nomadic)",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `v1_nomadic_panel' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_v1_nomadic_panel_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 55,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_icon' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_skip_icon_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	skip_icon_image;
#include "icon_v1.xbm"
	
	skip_icon_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, icon_v1_bits,
		XV_WIDTH, icon_v1_width,
		XV_HEIGHT, icon_v1_height,
		NULL);
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 20,
		PANEL_LABEL_IMAGE, skip_icon_image,
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `keyid' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_keyid_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 60,
		XV_Y, 22,
		PANEL_VALUE_DISPLAY_LENGTH, 25,
		PANEL_VALUE_STORED_LENGTH, 30,
		PANEL_LABEL_STRING, "Node ID:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `controls3' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_controls3_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 54,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 45,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_label' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_tunnel_label_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Tunnel Address:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_addr' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_tunnel_addr_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 16,
		PANEL_VALUE_DISPLAY_LENGTH, 20,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `v1_local_keyid_panel' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_v1_local_keyid_panel_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 98,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 45,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `local_keyid' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_local_keyid_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 11,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "default local key",
		NULL);
	return obj;
}

/*
 * Create object `message17' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_message17_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Local key ID:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `v1_algs_panel' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_v1_algs_panel_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 141,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 90,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kij_alg' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_kij_alg_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 14,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "none",
		NULL);
	return obj;
}

/*
 * Create object `kp_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_kp_alg_msg_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 19,
		PANEL_LABEL_STRING, "Key encryption:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kp_alg' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_kp_alg_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 46,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "none",
		NULL);
	return obj;
}

/*
 * Create object `kij_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_kij_alg_msg_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 51,
		PANEL_LABEL_STRING, "Traffic encryption:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `current_addr_panel' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_current_addr_panel_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 228,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 45,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `current_addr' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_current_addr_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 15,
		PANEL_VALUE_DISPLAY_LENGTH, 20,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_UNDERLINED, FALSE,
		PANEL_VALUE, "*",
		PANEL_READ_ONLY, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message7' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_message7_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Current Address:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `apply_cancel_panel' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_apply_cancel_panel_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 272,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `win_apply' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_win_apply_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_nomwin_v1_win_apply_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 81,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Apply",
		PANEL_NOTIFY_PROC, skiptool_nomwin_v1_win_apply_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `win_cancel' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v1_win_cancel_create(skiptool_nomwin_v1_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_nomwin_v1_win_cancel_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 201,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Cancel",
		PANEL_NOTIFY_PROC, skiptool_nomwin_v1_win_cancel_notify_callback,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `nomwin_v2'.
 */
skiptool_nomwin_v2_objects *
skiptool_nomwin_v2_objects_initialize(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (skiptool_nomwin_v2_objects *) calloc(1, sizeof (skiptool_nomwin_v2_objects))))
		return (skiptool_nomwin_v2_objects *) NULL;
	if (!ip->nomwin_v2)
		ip->nomwin_v2 = skiptool_nomwin_v2_nomwin_v2_create(ip, owner);
	if (!ip->v2_nomadic_panel)
		ip->v2_nomadic_panel = skiptool_nomwin_v2_v2_nomadic_panel_create(ip, ip->nomwin_v2);
	if (!ip->r_nsid)
		ip->r_nsid = skiptool_nomwin_v2_r_nsid_create(ip, ip->v2_nomadic_panel);
	if (!ip->skip_icon)
		ip->skip_icon = skiptool_nomwin_v2_skip_icon_create(ip, ip->v2_nomadic_panel);
	if (!ip->r_nsid_msg)
		ip->r_nsid_msg = skiptool_nomwin_v2_r_nsid_msg_create(ip, ip->v2_nomadic_panel);
	if (!ip->keyid)
		ip->keyid = skiptool_nomwin_v2_keyid_create(ip, ip->v2_nomadic_panel);
	if (!ip->tunnel_transport_panel)
		ip->tunnel_transport_panel = skiptool_nomwin_v2_tunnel_transport_panel_create(ip, ip->nomwin_v2);
	if (!ip->skip_mode)
		ip->skip_mode = skiptool_nomwin_v2_skip_mode_create(ip, ip->tunnel_transport_panel);
	if (!ip->message20)
		ip->message20 = skiptool_nomwin_v2_message20_create(ip, ip->tunnel_transport_panel);
	if (!ip->tunnel_label)
		ip->tunnel_label = skiptool_nomwin_v2_tunnel_label_create(ip, ip->tunnel_transport_panel);
	if (!ip->tunnel_addr)
		ip->tunnel_addr = skiptool_nomwin_v2_tunnel_addr_create(ip, ip->tunnel_transport_panel);
	if (!ip->v2_local_keyid_panel)
		ip->v2_local_keyid_panel = skiptool_nomwin_v2_v2_local_keyid_panel_create(ip, ip->nomwin_v2);
	if (!ip->s_nsid)
		ip->s_nsid = skiptool_nomwin_v2_s_nsid_create(ip, ip->v2_local_keyid_panel);
	if (!ip->s_nsid_msg)
		ip->s_nsid_msg = skiptool_nomwin_v2_s_nsid_msg_create(ip, ip->v2_local_keyid_panel);
	if (!ip->local_keyid)
		ip->local_keyid = skiptool_nomwin_v2_local_keyid_create(ip, ip->v2_local_keyid_panel);
	if (!ip->v2_algs_panel)
		ip->v2_algs_panel = skiptool_nomwin_v2_v2_algs_panel_create(ip, ip->nomwin_v2);
	if (!ip->kij_alg)
		ip->kij_alg = skiptool_nomwin_v2_kij_alg_create(ip, ip->v2_algs_panel);
	if (!ip->kp_alg_msg)
		ip->kp_alg_msg = skiptool_nomwin_v2_kp_alg_msg_create(ip, ip->v2_algs_panel);
	if (!ip->kp_alg)
		ip->kp_alg = skiptool_nomwin_v2_kp_alg_create(ip, ip->v2_algs_panel);
	if (!ip->kij_alg_msg)
		ip->kij_alg_msg = skiptool_nomwin_v2_kij_alg_msg_create(ip, ip->v2_algs_panel);
	if (!ip->mac_alg)
		ip->mac_alg = skiptool_nomwin_v2_mac_alg_create(ip, ip->v2_algs_panel);
	if (!ip->mac_alg_msg)
		ip->mac_alg_msg = skiptool_nomwin_v2_mac_alg_msg_create(ip, ip->v2_algs_panel);
	if (!ip->comp_alg2)
		ip->comp_alg2 = skiptool_nomwin_v2_comp_alg2_create(ip, ip->v2_algs_panel);
	if (!ip->message21)
		ip->message21 = skiptool_nomwin_v2_message21_create(ip, ip->v2_algs_panel);
	if (!ip->current_addr_panel)
		ip->current_addr_panel = skiptool_nomwin_v2_current_addr_panel_create(ip, ip->nomwin_v2);
	if (!ip->current_addr)
		ip->current_addr = skiptool_nomwin_v2_current_addr_create(ip, ip->current_addr_panel);
	if (!ip->message22)
		ip->message22 = skiptool_nomwin_v2_message22_create(ip, ip->current_addr_panel);
	if (!ip->apply_cancel_panel)
		ip->apply_cancel_panel = skiptool_nomwin_v2_apply_cancel_panel_create(ip, ip->nomwin_v2);
	if (!ip->win_apply)
		ip->win_apply = skiptool_nomwin_v2_win_apply_create(ip, ip->apply_cancel_panel);
	if (!ip->win_cancel)
		ip->win_cancel = skiptool_nomwin_v2_win_cancel_create(ip, ip->apply_cancel_panel);
	return ip;
}

/*
 * Create object `nomwin_v2' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_nomwin_v2_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 340,
		XV_HEIGHT, 440,
		XV_LABEL, "SKIP properties (Nomadic)",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `v2_nomadic_panel' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_v2_nomadic_panel_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 80,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `r_nsid' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_r_nsid_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_nomwin_v2_r_nsid_notify_callback(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 18,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_NOTIFY_PROC, skiptool_nomwin_v2_r_nsid_notify_callback,
		PANEL_CHOICE_STRING, 0, "IPv4 Address",
		NULL);
	return obj;
}

/*
 * Create object `skip_icon' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_skip_icon_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	skip_icon_image;
#include "icon_v2.xbm"
	
	skip_icon_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, icon_v2_bits,
		XV_WIDTH, icon_v2_width,
		XV_HEIGHT, icon_v2_height,
		NULL);
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 20,
		PANEL_LABEL_IMAGE, skip_icon_image,
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `r_nsid_msg' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_r_nsid_msg_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 54,
		XV_Y, 23,
		PANEL_LABEL_STRING, "Remote Key ID:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `keyid' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_keyid_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 48,
		PANEL_VALUE_DISPLAY_LENGTH, 34,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "ID:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_transport_panel' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_tunnel_transport_panel_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 78,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 70,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_mode' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_skip_mode_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 10,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_VERTICAL,
		PANEL_CHOICE_STRINGS,
			"Whole packet",
			"Data only",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `message20' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_message20_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 15,
		PANEL_LABEL_STRING, "Secure:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_label' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_tunnel_label_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 41,
		PANEL_LABEL_STRING, "Tunnel address:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_addr' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_tunnel_addr_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 41,
		PANEL_VALUE_DISPLAY_LENGTH, 19,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `v2_local_keyid_panel' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_v2_local_keyid_panel_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 147,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 70,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `s_nsid' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_s_nsid_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_nomwin_v2_s_nsid_notify_callback(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 9,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_NOTIFY_PROC, skiptool_nomwin_v2_s_nsid_notify_callback,
		PANEL_CHOICE_STRING, 0, "Not present",
		NULL);
	return obj;
}

/*
 * Create object `s_nsid_msg' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_s_nsid_msg_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 14,
		PANEL_LABEL_STRING, "Local Key ID:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `local_keyid' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_local_keyid_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 34,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_LABEL_STRING, "ID:",
		PANEL_CHOICE_STRING, 0, "default local key",
		NULL);
	return obj;
}

/*
 * Create object `v2_algs_panel' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_v2_algs_panel_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 216,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 145,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kij_alg' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_kij_alg_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 8,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "none",
		NULL);
	return obj;
}

/*
 * Create object `kp_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_kp_alg_msg_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 13,
		PANEL_LABEL_STRING, "Key encryption:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kp_alg' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_kp_alg_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 40,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "none",
		NULL);
	return obj;
}

/*
 * Create object `kij_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_kij_alg_msg_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 45,
		PANEL_LABEL_STRING, "Traffic encryption:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `mac_alg' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_mac_alg_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 72,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "Off",
		NULL);
	return obj;
}

/*
 * Create object `mac_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_mac_alg_msg_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 77,
		PANEL_LABEL_STRING, "Authentication:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `comp_alg2' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_comp_alg2_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 104,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "Off",
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message21' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_message21_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 109,
		PANEL_LABEL_STRING, "Compression:",
		PANEL_LABEL_BOLD, TRUE,
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `current_addr_panel' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_current_addr_panel_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 360,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 45,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `current_addr' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_current_addr_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 15,
		PANEL_VALUE_DISPLAY_LENGTH, 20,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_UNDERLINED, FALSE,
		PANEL_VALUE, "*",
		PANEL_READ_ONLY, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message22' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_message22_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Current Address:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `apply_cancel_panel' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_apply_cancel_panel_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 404,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `win_apply' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_win_apply_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_nomwin_v2_win_apply_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 81,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Apply",
		PANEL_NOTIFY_PROC, skiptool_nomwin_v2_win_apply_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `win_cancel' in the specified instance.
 */
Xv_opaque
skiptool_nomwin_v2_win_cancel_create(skiptool_nomwin_v2_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_nomwin_v2_win_cancel_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 201,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Cancel",
		PANEL_NOTIFY_PROC, skiptool_nomwin_v2_win_cancel_notify_callback,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `netwin_v2'.
 */
skiptool_netwin_v2_objects *
skiptool_netwin_v2_objects_initialize(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (skiptool_netwin_v2_objects *) calloc(1, sizeof (skiptool_netwin_v2_objects))))
		return (skiptool_netwin_v2_objects *) NULL;
	if (!ip->netwin_v2)
		ip->netwin_v2 = skiptool_netwin_v2_netwin_v2_create(ip, owner);
	if (!ip->net_panel)
		ip->net_panel = skiptool_netwin_v2_net_panel_create(ip, ip->netwin_v2);
	if (!ip->net_label)
		ip->net_label = skiptool_netwin_v2_net_label_create(ip, ip->net_panel);
	if (!ip->addr)
		ip->addr = skiptool_netwin_v2_addr_create(ip, ip->net_panel);
	if (!ip->skip_icon)
		ip->skip_icon = skiptool_netwin_v2_skip_icon_create(ip, ip->net_panel);
	if (!ip->mask_label)
		ip->mask_label = skiptool_netwin_v2_mask_label_create(ip, ip->net_panel);
	if (!ip->mask)
		ip->mask = skiptool_netwin_v2_mask_create(ip, ip->net_panel);
	if (!ip->tunnel_transport_panel)
		ip->tunnel_transport_panel = skiptool_netwin_v2_tunnel_transport_panel_create(ip, ip->netwin_v2);
	if (!ip->skip_mode)
		ip->skip_mode = skiptool_netwin_v2_skip_mode_create(ip, ip->tunnel_transport_panel);
	if (!ip->message18)
		ip->message18 = skiptool_netwin_v2_message18_create(ip, ip->tunnel_transport_panel);
	if (!ip->tunnel_label)
		ip->tunnel_label = skiptool_netwin_v2_tunnel_label_create(ip, ip->tunnel_transport_panel);
	if (!ip->tunnel_addr)
		ip->tunnel_addr = skiptool_netwin_v2_tunnel_addr_create(ip, ip->tunnel_transport_panel);
	if (!ip->v2_remote_keyid_panel)
		ip->v2_remote_keyid_panel = skiptool_netwin_v2_v2_remote_keyid_panel_create(ip, ip->netwin_v2);
	if (!ip->r_nsid)
		ip->r_nsid = skiptool_netwin_v2_r_nsid_create(ip, ip->v2_remote_keyid_panel);
	if (!ip->r_nsid_msg)
		ip->r_nsid_msg = skiptool_netwin_v2_r_nsid_msg_create(ip, ip->v2_remote_keyid_panel);
	if (!ip->keyid)
		ip->keyid = skiptool_netwin_v2_keyid_create(ip, ip->v2_remote_keyid_panel);
	if (!ip->v2_local_keyid_panel)
		ip->v2_local_keyid_panel = skiptool_netwin_v2_v2_local_keyid_panel_create(ip, ip->netwin_v2);
	if (!ip->s_nsid)
		ip->s_nsid = skiptool_netwin_v2_s_nsid_create(ip, ip->v2_local_keyid_panel);
	if (!ip->s_nsid_msg)
		ip->s_nsid_msg = skiptool_netwin_v2_s_nsid_msg_create(ip, ip->v2_local_keyid_panel);
	if (!ip->local_keyid)
		ip->local_keyid = skiptool_netwin_v2_local_keyid_create(ip, ip->v2_local_keyid_panel);
	if (!ip->v2_algs_panel)
		ip->v2_algs_panel = skiptool_netwin_v2_v2_algs_panel_create(ip, ip->netwin_v2);
	if (!ip->kij_alg)
		ip->kij_alg = skiptool_netwin_v2_kij_alg_create(ip, ip->v2_algs_panel);
	if (!ip->kp_alg_msg)
		ip->kp_alg_msg = skiptool_netwin_v2_kp_alg_msg_create(ip, ip->v2_algs_panel);
	if (!ip->kp_alg)
		ip->kp_alg = skiptool_netwin_v2_kp_alg_create(ip, ip->v2_algs_panel);
	if (!ip->kij_alg_msg)
		ip->kij_alg_msg = skiptool_netwin_v2_kij_alg_msg_create(ip, ip->v2_algs_panel);
	if (!ip->mac_alg)
		ip->mac_alg = skiptool_netwin_v2_mac_alg_create(ip, ip->v2_algs_panel);
	if (!ip->mac_alg_msg)
		ip->mac_alg_msg = skiptool_netwin_v2_mac_alg_msg_create(ip, ip->v2_algs_panel);
	if (!ip->comp_alg)
		ip->comp_alg = skiptool_netwin_v2_comp_alg_create(ip, ip->v2_algs_panel);
	if (!ip->message19)
		ip->message19 = skiptool_netwin_v2_message19_create(ip, ip->v2_algs_panel);
	if (!ip->apply_cancel_panel)
		ip->apply_cancel_panel = skiptool_netwin_v2_apply_cancel_panel_create(ip, ip->netwin_v2);
	if (!ip->win_apply)
		ip->win_apply = skiptool_netwin_v2_win_apply_create(ip, ip->apply_cancel_panel);
	if (!ip->win_cancel)
		ip->win_cancel = skiptool_netwin_v2_win_cancel_create(ip, ip->apply_cancel_panel);
	return ip;
}

/*
 * Create object `netwin_v2' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_netwin_v2_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 340,
		XV_HEIGHT, 457,
		XV_LABEL, "SKIP network properties",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `net_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_net_panel_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 70,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `net_label' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_net_label_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 60,
		XV_Y, 17,
		PANEL_LABEL_STRING, "Network:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `addr' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_addr_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 17,
		PANEL_VALUE_DISPLAY_LENGTH, 23,
		PANEL_VALUE_STORED_LENGTH, 24,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `skip_icon' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_skip_icon_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	skip_icon_image;
#include "icon_v2.xbm"
	
	skip_icon_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, icon_v2_bits,
		XV_WIDTH, icon_v2_width,
		XV_HEIGHT, icon_v2_height,
		NULL);
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 20,
		PANEL_LABEL_IMAGE, skip_icon_image,
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `mask_label' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_mask_label_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 60,
		XV_Y, 39,
		PANEL_LABEL_STRING, "Netmask:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `mask' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_mask_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 39,
		PANEL_VALUE_DISPLAY_LENGTH, 23,
		PANEL_VALUE_STORED_LENGTH, 24,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE, "255.255.255.0",
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_transport_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_tunnel_transport_panel_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 68,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 70,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_mode' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_skip_mode_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_netwin_v2_skip_mode_notify_callback(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 11,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_VERTICAL,
		PANEL_NOTIFY_PROC, skiptool_netwin_v2_skip_mode_notify_callback,
		PANEL_CHOICE_STRINGS,
			"Whole packet",
			"Data only",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `message18' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_message18_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 15,
		PANEL_LABEL_STRING, "Secure:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_label' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_tunnel_label_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 41,
		PANEL_LABEL_STRING, "Tunnel address:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `tunnel_addr' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_tunnel_addr_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 41,
		PANEL_VALUE_DISPLAY_LENGTH, 19,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `v2_remote_keyid_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_v2_remote_keyid_panel_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 137,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 70,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `r_nsid' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_r_nsid_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_netwin_v2_r_nsid_notify_callback(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 13,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_NOTIFY_PROC, skiptool_netwin_v2_r_nsid_notify_callback,
		PANEL_CHOICE_STRING, 0, "Not present",
		NULL);
	return obj;
}

/*
 * Create object `r_nsid_msg' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_r_nsid_msg_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 15,
		PANEL_LABEL_STRING, "Remote Key ID:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `keyid' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_keyid_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 39,
		PANEL_VALUE_DISPLAY_LENGTH, 34,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "ID:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `v2_local_keyid_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_v2_local_keyid_panel_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 206,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 70,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `s_nsid' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_s_nsid_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_netwin_v2_s_nsid_notify_callback(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 9,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_NOTIFY_PROC, skiptool_netwin_v2_s_nsid_notify_callback,
		PANEL_CHOICE_STRING, 0, "Not present",
		NULL);
	return obj;
}

/*
 * Create object `s_nsid_msg' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_s_nsid_msg_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 14,
		PANEL_LABEL_STRING, "Local Key ID:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `local_keyid' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_local_keyid_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 34,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_LABEL_STRING, "ID:",
		PANEL_CHOICE_STRING, 0, "default local key",
		NULL);
	return obj;
}

/*
 * Create object `v2_algs_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_v2_algs_panel_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 275,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 145,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kij_alg' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_kij_alg_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 8,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "none",
		NULL);
	return obj;
}

/*
 * Create object `kp_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_kp_alg_msg_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 13,
		PANEL_LABEL_STRING, "Key encryption:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kp_alg' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_kp_alg_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 40,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "none",
		NULL);
	return obj;
}

/*
 * Create object `kij_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_kij_alg_msg_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 45,
		PANEL_LABEL_STRING, "Traffic encryption:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `mac_alg' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_mac_alg_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 72,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "Off",
		NULL);
	return obj;
}

/*
 * Create object `mac_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_mac_alg_msg_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 77,
		PANEL_LABEL_STRING, "Authentication:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `comp_alg' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_comp_alg_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 104,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "Off",
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message19' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_message19_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 109,
		PANEL_LABEL_STRING, "Compression:",
		PANEL_LABEL_BOLD, TRUE,
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `apply_cancel_panel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_apply_cancel_panel_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 419,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `win_apply' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_win_apply_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_netwin_v2_win_apply_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 81,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Apply",
		PANEL_NOTIFY_PROC, skiptool_netwin_v2_win_apply_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `win_cancel' in the specified instance.
 */
Xv_opaque
skiptool_netwin_v2_win_cancel_create(skiptool_netwin_v2_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_netwin_v2_win_cancel_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 201,
		XV_Y, 10,
		PANEL_LABEL_STRING, "Cancel",
		PANEL_NOTIFY_PROC, skiptool_netwin_v2_win_cancel_notify_callback,
		NULL);
	return obj;
}

