/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)t_mem.c	1.2 95/11/23 Sun Microsystems"

#include "global.h"
#include <memory.h>
#include <malloc.h>
#include <string.h>

void T_memset(POINTER s, int c, unsigned int n )
{
	(void)memset(s, c, n);
}

void T_memcpy(POINTER s1, POINTER s2, int n)
{
	(void) memcpy(s1, s2, n);
}

void T_memmove(POINTER s1, POINTER s2, int n)
{
	(void) memcpy(s1, s2, n);
}

int T_memcmp(POINTER s1, POINTER s2, int n)
{
	return (memcmp(s1, s2, n));
}

POINTER T_malloc(unsigned int n)
{
	return ((POINTER)malloc(n));
}

POINTER T_realloc(POINTER s, unsigned int n)
{
#ifdef SOLARIS2
	return ((POINTER)realloc((void *)s, n));
#else SOLARIS2
	return ((POINTER)realloc((malloc_t)s, n));
#endif SOLARIS2
}

void T_free(POINTER s)
{
#ifdef SOLARIS2
	free((void *)s);
#else SOLARIS2
	free((malloc_t)s);
#endif SOLARIS2
}
