/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
 
#pragma ident "@(#)skip_msgs.C	1.35 96/10/09"
 
#include "Bigint.h"
#include "Bstream.h"

/*
 * System include
 */
#include <skip_os.h>

#include "Time.h"

#include "skipd.h"
#include "skip_log.h"
#include "skip_proto.h"
#include "skip_conf.h"
#include "SkipCert.h"
#include "skip_keymgr.h"
#include "skip_keymgrmsgs.h"
#include "skip_machdep.h"

extern int	errno;
int		verbose		= 0;
int		UPDATE_FREQ	= 3600;

#define DEBUG

#ifdef DEBUG
static void print_params(skip_param_t *);
static void print_message(union skip_messages *dp);
#endif

int
skip_set_cdp_port(int fd, unsigned short cdp_port)
{
        struct Set_cdp_server_port set;
 
        set.msgtype	= SKIP_SET_CDP_SERVER_PORT;
        set.port	= cdp_port;
	
 	skip_log(SKIP_NOTICE, "Setting CDP port=%d", cdp_port);
        fflush(stdout);
 
        if (put_kernel_message(fd, &set, sizeof(set)) < 0) {
                if (errno == EINTR) {
                        return(1);
                }
                if ((errno == EAGAIN) || (errno == EWOULDBLOCK)) {
                        return(1);
                }
                perror("put_kernel_message");
		return(1);
        }
	return(0);
}

void
set_kij_alg(int fd, unsigned char version, unsigned char kij_alg)
{
        struct Set_supported_kij        set;
 
        set.msgtype     = SKIP_SET_SUPPORTED_KIJ;
        set.version     = version;
        set.kij_alg     = kij_alg;
	
 	skip_log(SKIP_NOTICE, "Setting supported kij alg=%d for version %d",
                                                        kij_alg, version);
        fflush(stdout);
 
        if (put_kernel_message(fd, &set, sizeof(set)) < 0) {
                if (errno == EINTR) {
                        return;
                }
                if ((errno == EAGAIN) || (errno == EWOULDBLOCK)) {
                        return;
                }
                perror("put_kernel_message");
        }
}

int
make_boxid_msg(u_char nsid, Bstream keyid, void *buf )
{
	struct Set_local_keyid	*set;
	union skip_messages	*msg;

	msg=(union skip_messages *)buf;
	
	msg->msgtype= SKIP_SET_LOCAL_KEYID;
	set = &msg->set_keyid;
	set->nsid	= nsid;

	/*
	 * XXX - how to convert Bstreanm to keyid ???
	 */
	set->mkeyid.len = keyid.getlength();
	memcpy(set->mkeyid.buf, (char *) keyid.getdatap(), set->mkeyid.len);

	return sizeof (struct Set_local_keyid);
}
	
// Make an encrypted key request response.  

static u_long
make_enc_rsp(union skip_messages *dp, union skip_messages *response, 
		int *size, struct remote_info *host)
{
	skip_param_t   *req_params;
	u_long time_left;
	u_long return_value;

	Bstream s_keyid;		/* Local key id */
	Bstream r_keyid;		/* Remote Key id */

	return_value=KEYMGR_OK;

	req_params = &dp->enc_rsp.params;
	SkipParams params(*req_params);

	if (verbose == 1) {
		skip_log(SKIP_NOTICE,
			"Received encrypt key request for nsid=%d mkid=0x%s",
			params.r_nsid, params.r_mkeyid.get_info_str());
	}

	// Fill in the remote host structure
	host->keyid = params.r_mkeyid;
	host->nsid  = params.r_nsid;

	bcopy(&params.ip_addr, &host->ip_addr, sizeof(struct in_addr));
	bcopy(&params.tunnel_addr, &host->tunnel_addr, sizeof(struct in_addr));

	params.counter_n = CURRENT_NCOUNTER;
	time_left = UNTIL_NEXT_NCOUNTER;

	if (params.kp_alg || params.mac_alg) {
		return_value = skip_dispatch(1, &params);
		if (return_value)
			return return_value;
	}

	/* XXX Generalize this */
	response->enc_rsp.msgtype  = SKIP_ENCRYPTED_PKT_KEY_RSP;
	response->enc_rsp.params   = dp->enc_req.params;

	response->enc_rsp.params.counter_n   = htonl(params.counter_n);
	response->enc_rsp.params.ttl = time_left;

	response->enc_rsp.iv.len   = params.iv.getlength();
	memcpy(response->enc_rsp.iv.buf, params.iv.getdatap(), 
				params.iv.getlength());

	response->enc_rsp.ekp.len = params.encrypted_kp.getlength();
	memcpy(response->enc_rsp.ekp.buf,
			params.encrypted_kp.getdatap(), 
			params.encrypted_kp.getlength());

	*size=sizeof(response->enc_rsp);

	
	if (req_params->version == SKIP_V1 ) {
		/*
	  	 * Sunscreen mode only ...  
	 	 */
		response->enc_rsp.E_kp.len = params.kp.getlength();
		response->enc_rsp.A_kp.len = 0;

		memcpy(response->enc_rsp.E_kp.buf, params.kp.getdatap(), 
				params.kp.getlength());
	}

	if (req_params->version != SKIP_V1 ) {
		if (req_params->kp_alg ) {
			response->enc_rsp.E_kp.len = params.e_kp.getlength();
			memcpy( response->enc_rsp.E_kp.buf, 
				params.e_kp.getdatap(), 
				params.e_kp.getlength());
      		} else  {
	      		response->enc_rsp.E_kp.len = 0;
		}
	} 
	if (req_params->mac_alg) {
		response->enc_rsp.A_kp.len=params.a_kp.getlength();
		memcpy(response->enc_rsp.A_kp.buf,
				params.a_kp.getdatap(), 
				params.a_kp.getlength());
	} else  {
		response->enc_rsp.A_kp.len = 0;
	}
	return return_value;
}

// Make a decrypted key request response.  
static u_long
make_dec_rsp(union skip_messages *dp, union skip_messages *response, 
		int *size, struct remote_info *host)
{
	skip_param_t   *req_params;
	u_long return_value;

	return_value=KEYMGR_OK;

	req_params                          = &dp->dec_rsp.params;

	response->dec_rsp.msgtype       = SKIP_DECRYPTED_PKT_KEY_RSP;
	response->dec_rsp.params        = dp->dec_req.params;

	SkipParams params(*req_params);

	if (verbose == 1) {
		skip_log(SKIP_NOTICE,
			"Received decrypt key request for nsid=%d mkid=0x%s",
			params.r_nsid, params.r_mkeyid.get_info_str());
	}

	// Fill in the remote host structure
	host->keyid = params.r_mkeyid;
	host->nsid  = params.r_nsid;

	bcopy(&req_params->ip_addr, &host->ip_addr, sizeof(struct in_addr));
	bcopy(&req_params->tunnel_addr, &host->tunnel_addr, sizeof(struct in_addr));

	params.encrypted_kp = Bstream((int)dp->dec_req.ekp.len, 
				(u_char *)dp->dec_req.ekp.buf);

//	XXX need to do bounds checking here.

	if (params.kp_alg || params.mac_alg) {
		return_value = skip_dispatch(0, &params);
		if (return_value)
			return return_value;
	}

	// Stuff in the ekp
	response->dec_rsp.ekp.len = params.encrypted_kp.getlength();
	memcpy( response->dec_rsp.ekp.buf,
		params.encrypted_kp.getdatap(), 
		params.encrypted_kp.getlength());
	
	*size = sizeof (response->dec_rsp);
		
	response->dec_rsp.params.counter_n    = req_params->counter_n;
	response->dec_rsp.params.ttl          = UNTIL_NEXT_NCOUNTER;

	if (req_params->version == SKIP_V1 ) {
		/*
	  	 * Sunscreen mode only ...  
	 	 */
		response->dec_rsp.E_kp.len = params.kp.getlength();
		memcpy(response->dec_rsp.E_kp.buf,
				params.kp.getdatap(), params.kp.getlength());
	}
	else {
		if (req_params->kp_alg ) {
			response->dec_rsp.E_kp.len = params.e_kp.getlength(),
			memcpy( response->dec_rsp.E_kp.buf,
				params.e_kp.getdatap(), 
				params.e_kp.getlength());
		} else  {
			response->dec_rsp.E_kp.len = 0;
		}
	} 

	if (req_params->mac_alg) {
		response->dec_rsp.A_kp.len = params.a_kp.getlength();
		memcpy( response->dec_rsp.A_kp.buf,
			params.a_kp.getdatap(), 
			params.a_kp.getlength());
	} else  {
		response->dec_rsp.A_kp.len = 0;
	}
	return return_value;
}

int 
make_response(void *in_buf, void *out_buf, int *size, struct remote_info *host)
{
	union skip_messages *dp, *response;

	u_long ret;

	dp = (union skip_messages *)in_buf;
	response =(union skip_messages *)out_buf;

#ifdef DEBUG
	if (verbose > 1) {
		// printf(">> Input Kernel Message: (type=%d, size=%d)\n",
		//		dp->msgtype, *size);
		print_message (dp);
		// printf(">> End Input Kernel Message <<\n");
	}
#endif
	switch (dp->msgtype) {
 
	        case SKIP_ENCRYPTED_PKT_KEY_REQ: 
			ret = make_enc_rsp(dp, response, size, host);
			break;
		case SKIP_DECRYPTED_PKT_KEY_REQ:
			ret = make_dec_rsp(dp, response, size, host);
			break;
        	default:
			skip_log(SKIP_ERROR,
				"Unsupported message (%d) received\n",
               	                 dp->msgtype);
                	*size = 0;
			ret = 0;
	}
#ifdef DEBUG
	if (verbose > 1) {
		// printf(">> Response Message:\n");
		if (ret == KEYMGR_OK)
			print_message(response);
		else
			printf("Reponse: !KEYMGR_OK, ret=%d\n", ret);
		// printf(">> End Response Message <<\n");
	}
#endif
	return ret;
}

#ifdef DEBUG
void
print_params(skip_param_t *params)
{
	int i;

	printf("\tversion=%d ip=%08lx counter_n=%08x ttl=%d\n",
		params->version,
		ntohl(params->ip_addr.s_addr), params->counter_n, params->ttl);

	printf("\tkij_alg=%d, kp_alg=%d, mac_alg=%d, comp_alg=%d\n",
			params->kij_alg, params->kp_alg,
			params->mac_alg, params->comp_alg);

	printf("\tReceiver NSID=%d MKID=", params->r_nsid);
	for (i = 0; i < params->r_mkeyid.len; i++)
		printf("%02x", (unsigned char) params->r_mkeyid.buf[i]);
	putchar('\n');

	printf("\tSender   NSID=%d MKID=", params->s_nsid);
	for (i = 0; i < params->s_mkeyid.len; i++)
		printf("%02x", (unsigned char) params->s_mkeyid.buf[i]);
	putchar('\n');
}

static void
print_message(union skip_messages *dp)
{
	int	i;
	char *c;

	switch (dp->msgtype) {

	case SKIP_ENCRYPTED_PKT_KEY_REQ:

		printf("SKIP_ENCRYPTED_PKT_KEY_REQ:\n");
		print_params(&(dp->enc_req.params));
		break;

	case SKIP_ENCRYPTED_PKT_KEY_RSP:
		printf("SKIP_ENCRYPTED_PKT_KEY_RSP:\n");
		print_params(&dp->enc_rsp.params);
		printf("\tekp =  ");
		c = dp->enc_rsp.ekp.buf;
		for (i = 0; i < dp->enc_rsp.ekp.len; i++)
			printf("%02x", (unsigned char) *c++);
		putchar('\n');
		printf("\tE_kp = ");
		c =  dp->enc_rsp.E_kp.buf;
		for (i = 0; i < dp->enc_rsp.E_kp.len; i++)
			printf("%02x", (unsigned char) *c++);
		putchar('\n');
		printf("\tA_kp = ");
		c = dp->enc_rsp.A_kp.buf;
		for (i = 0; i < dp->enc_rsp.A_kp.len; i++)
			printf("%02x", (unsigned char) *c++);
		putchar('\n');
		break;

	case SKIP_DECRYPTED_PKT_KEY_REQ:
		printf("SKIP_DECRYPTED_PKT_KEY_REQ:\n");
		print_params(&dp->dec_req.params);
		printf("\tekp =  ");
		c = dp->dec_req.ekp.buf;
		for (i = 0; i < dp->dec_req.ekp.len; i++)
			printf("%02x", (unsigned char) *c++);
		putchar('\n');
		break;

	case SKIP_DECRYPTED_PKT_KEY_RSP:
		printf("SKIP_DECRYPTED_PKT_KEY_RSP:\n");
		print_params(&dp->dec_rsp.params);
		printf("\tekp =  ");
		c = dp->dec_rsp.ekp.buf;
		for (i = 0; i < dp->dec_rsp.ekp.len; i++)
			printf("%02x", (unsigned char) *c++);
		putchar('\n');
		printf("\tE_kp = ");
		c = dp->dec_rsp.E_kp.buf;
		for (i = 0; i < dp->dec_rsp.E_kp.len; i++)
			printf("%02x", (unsigned char) *c++);
		putchar('\n');
		printf("\tA_kp = ");
		c =  dp->dec_rsp.A_kp.buf;
		for (i = 0; i < dp->dec_rsp.A_kp.len; i++)
			printf("%02x", (unsigned char) *c++);
		putchar('\n');
		break;

	default:
		fprintf(stderr, "Unsupported message (%d) in PRINT_MESSAGE\n",
				dp->msgtype);
	}
}
#endif

