/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_init.C	1.16 96/10/08"

#include <skip_os.h>
#include <skip_proto.h>
#include "skip_keymgr.h"

#include "skip_conf.h"
#include "AuthPolicy.h"
#include "skipd.h"
#include "skip_cache.h"
#include "skip_localidlist.h"
#include "skip_log.h"
#include "skip_machdep.h"
#include "cdp.h"
#include "cdp_queue.h"
#include "SlotParse.h"

extern secret_cache kij_cache;

AuthPolicy auth;
SlotParse skip_conf;


extern void randseed_set_skip_paths(char *, char *);

void skip_set_keyid(u_char nsid, const Bstream& keyid)
{
        int size;
	char buf[MGTCSIZE];

	size = make_boxid_msg(nsid, keyid, (void *)buf);

	if (put_kernel_message(kern_fd, buf, size) < 0) {
		skip_log(SKIP_ERROR,
			"unable to set local name nsid=%d mkid=%s in kernel",
				nsid, keyid.get_info_str());
		return;
	}

        skip_log(SKIP_NOTICE, "local name nsid=%d mkid=%s",
			      nsid, keyid.get_info_str());
}


int
skip_init()
{

	skip_machdep_init();

	randseed_set_skip_paths(SKIP_BIN, SKIP_DIR);

	kern_fd = open_kernel();

	init_cryptolib();
	skip_init_internal_cryptors(kern_fd);
	skip_init_internal_macs(kern_fd);

	if (!skip_conf.load(SKIP_CONF, SLOT_SKIP_CONF))
		skip_conf.clear();


	load_raw(SKIP_RAW_FILE);

	if (skip_conf.enable_cdp && skip_conf.cdp_resolvers.length() == 0)
		add_cdp_resolver(RESOLVER_PING, NULL);
	else {
		char **s;

		for (s = skip_conf.cdp_resolvers.first(); s;
					s = skip_conf.cdp_resolvers.next()) {
			if (strcmp(*s, "@") == 0)
				add_cdp_resolver(RESOLVER_PING, NULL);
			else if (strcmp(*s, "=") == 0)
				add_cdp_resolver(RESOLVER_TUNNEL, NULL);
			else
				add_cdp_resolver(RESOLVER_HOST, *s);
		}
	}

	if (skip_conf.enable_certd) {

		if (skip_set_cdp_port(kern_fd, CDP_PORT_RESPONDER)) {
			skip_log(SKIP_ERROR,
			  "skip_set_cdp_port(%ld) failed.", CDP_PORT_RESPONDER);
		}

		certd_fd = open_socket(CDP_PORT_RESPONDER);
	}

	{
       	   // Let the random number generator kick off its entropy gathering

           skip_log(SKIP_NOTICE, "Initializing random number generator...");
           Bstream dummy = get_random_bytes(1);
	   skip_log(SKIP_NOTICE, "done");
	}

	auth.load(SKIP_DIR);

	char fnam[512];
	sprintf(fnam, "%slocalid", SKIP_DIR);
	LocalList.load(fnam);

	if (LocalList.ids.length() == 0)
		skip_log(SKIP_NOTICE,
			"warning: no local secrets loaded from %s", fnam);
	else {
		LocalId *p;

		for (p = LocalList.first(); p; p = LocalList.next())
			skip_set_keyid(p->nsid, p->mkeyid);
	}

	{
		FILE *pid_fp;

		pid_fp = fopen(SKIP_PID, "w");
		if (pid_fp == NULL)
			skip_log(SKIP_ERROR, "can't write %s", SKIP_PID);
		else {
			fprintf(pid_fp, "%d\n", getpid());
			fclose(pid_fp);
		}
	}

	return 0;
}

