/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_cache.C	1.16 96/02/22"

/*
 * Implements all of the SKIP secret caching, both in core and on disk.
 */
#include "Bigint.h"
#include "Bstream.h"
 
/*
 * System includes
 */
#include <skip_os.h>

#include "Time.h"
#include "LL.h"

#include "skip_log.h"
#include "my_types.h"
#include "skip_conf.h"
#include "skip_keymgr.h"
#include "skip_cache.h"
#include "skip_proto.h"

extern secret_cache kij_cache;
extern int verbose;


LL<local_secret> local_secrets;


//  Hash a remote MKID
//
//  We don't bother to include the nsids or the local keyid in the
//  hash, since they aren't very random, and we'll most likely only
//  be talking to a particular remote MKID with one local MKID.

unsigned int 
secret_cache::hash(const Bstream& keyid) {
	unsigned int res = 0;
	u_char *p;
	int len;

	p = keyid.getdatap();
	len = keyid.getlength();

	while (len--)
		res = ((res << 1) ^ *p++) % MAX_HASH;

	return res;
}

secret_cache::secret_cache()
{
	int i;

	for (i = 0; i < MAX_HASH; i++) 
		table[i] = NULL;
}

SkipSecret *
secret_cache::get_secret(u_char l_nsid, const Bstream& l_keyid,
			 u_char r_nsid, const Bstream &r_keyid)
{
        Bstream nullstr;
        secret_cache_elem *elem;

        elem = get_entry(l_nsid, l_keyid, r_nsid, r_keyid);
        if (elem == NULL)
                return NULL;
        return elem->secret;
}

secret_cache_elem *
secret_cache::get_entry(u_char l_nsid, const Bstream& l_keyid, 
			u_char r_nsid, const Bstream& r_keyid)
{
	u_long now;
	int index;
	LL<secret_cache_elem>* active;

	now = UNIX_TO_NTP(time(0));
	index = hash(r_keyid);
	active = table[index];

	if (active == NULL)
		return NULL;
	secret_cache_elem *p;

	for (p = active->first(); p; p = active->next())
	{
		if (p->l_nsid == l_nsid && p->l_keyid == l_keyid  &&
		    p->r_nsid == r_nsid && p->r_keyid == r_keyid) {
			return p;
		}
	}
	return NULL;
}

void
secret_cache::insert(secret_cache_elem *elem)
{
	secret_cache_elem* cached;

	cached = get_entry(elem->l_nsid, elem->l_keyid, 
			   elem->r_nsid, elem->r_keyid);

	if (cached)
		*cached = *elem;
	else {
		int index;

		index = hash(elem->r_keyid);

		if (table[index] == NULL)
			table[index] = new LL<secret_cache_elem>;
		table[index]->insert(*elem);
	}
}

// Nuke the whole cache
void secret_cache::purge()
{
	int i;

	for (i = 0; i < MAX_HASH; i++) 
		if (table[i] != NULL) {
			table[i]->clear();
			delete table[i];
			table[i] = NULL;
		}
}

