
#pragma ident "@(#)md2.h	1.2 95/11/16 Sun Microsystems"

struct xMD2Context {
        /*
         * This buffer is divided into 4 16-byte chunks:
         * - State buffer
         * - Input buffer
         * - Temporary used during transformation 
         * - Checksum computed over data.
         */
        unsigned char buf[64];
        unsigned len;           /* Input size in bytes, mod 16 */
};

#ifdef __cplusplus
extern "C" {
#endif

void xMD2Init(struct xMD2Context *);
void xMD2Update(struct xMD2Context *, unsigned char const *, unsigned );
void xMD2Final(struct xMD2Context *md2, unsigned char hash[16]);

#ifdef __cplusplus
}
#endif
