/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)X509skip.C	1.27 96/07/03 Sun Microsystems"

#include <sys/types.h>
#include "Bstream.h"
#include "Bigint.h"
#include "SkipCert.h"
#include "X509Cert.h"
#include "X509skip.h"


Bstream CA_X509_Cert;		// XXX


X509SkipCert::X509SkipCert()
{
}

X509SkipCert::X509SkipCert(const X509SkipCert& rhs)
{
	orig = rhs.orig;
	serialnum = rhs.serialnum;
	sigalg = rhs.sigalg;
	issuer = rhs.issuer;
	notbefore = rhs.notbefore;
	notafter = rhs.notafter;
	subject = rhs.subject;
	pubkey = rhs.pubkey;
	certdata = rhs.certdata;
	certsigdata = rhs.certsigdata;
	sigdata = rhs.sigdata;
}

X509SkipCert& X509SkipCert::operator =(const X509SkipCert& rhs)
{
	if (this != &rhs) {
		orig = rhs.orig;
		serialnum = rhs.serialnum;
		sigalg = rhs.sigalg;
		issuer = rhs.issuer;
		notbefore = rhs.notbefore;
		notafter = rhs.notafter;
		subject = rhs.subject;
		pubkey = rhs.pubkey;
		certdata = rhs.certdata;
		certsigdata = rhs.certsigdata;
		sigdata = rhs.sigdata;
	}
	return *this;
}

X509SkipCert::~X509SkipCert()
{
}

int X509SkipCert::CertType()
{
	return SKIP_CERT_X509;
}

Bstream
X509SkipCert::get_issuer()
{
	return getissuer().encode();
}

int
X509SkipCert::skip_params(Bigint &g, Bigint &p)
{
	int retval;
	Bigint exp_len;

	PubKey dh_pub_value=getpubkey();
        retval = asn1_der_decode_dh_params(dh_pub_value.keytype.params,
			p, g, exp_len);
	return retval;
}

Bigint X509SkipCert::skip_pubkey()
{
	int retval;
	PubKey dh_pub_value=getpubkey();
        Bigint dh_pub_int;

        retval = asn1_der_decode_integer(dh_pub_value.key, dh_pub_int);
	if (retval != 0)
		return 1;
	return dh_pub_int;
}

u_long X509SkipCert::skip_notvalidafter()
{
	return getnotafter().ntptime();
}

u_long X509SkipCert::skip_notvalidbefore()
{
	return getnotbefore().ntptime();
}


int
X509SkipCert::decode(Bstream Cert)
{
	int retval;

	orig=Cert;
        retval = asn1_der_decode_cert(Cert, *this);
        if (retval != SUCCESS)
                return 1;
	return 0;
}

char *
X509SkipCert::isValid(AuthPolicy& auth)
{
	int found = 0;
	char *err = "X509 verification failed";

	X509_CA* p;

	for (p = auth.X509_CAs.first(); p; p = auth.X509_CAs.next())
		if (issuer == p->ca_cert.getsubject()) {
			found = 1;

			if (p->revoked.ispresent(serialnum)) {
				err = "certificate manually revoked";
				continue;
			}

			if (verify(p->ca_cert.getpubkey()) == VALID)
				return NULL;

			// else keep looking
		}

	if (found)
		return "X509 verification failed";

	return "verification failed: no X509 CA found";
}

Bstream X509SkipCert::skip_name()
{
	String ip;
	Bstream nullstr;

	ip = getsubject().getip();
	if (ip.length() == 0)		// If not encoded as ip, try cn
		ip = getsubject().getcn();

        // We assume that the boxid is the IP Address
 
        // The IPA is a printable hex string OR a dot
	// notation IP address. We convert the string
	// into its binary representation as a Bstream.

	return  Bigint_to_Bstr(Bigint((const char *)ip));
}

Bstream X509SkipCert::encode()
{
	return orig;
}

void X509SkipCert::print()
{
	printf("Format: X509 Certificate\n");
	X509Cert::print();
}

void X509SkipCert::machprint()
{
	printf("Format: X509 Certificate\n");
	X509Cert::machprint();
}

SkipCert*
X509SkipCert::dup()
{
	X509SkipCert* t;

	t = new X509SkipCert;
	*t = *this;

        return t;
}
 
