/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
 
#pragma ident "@(#)skip_keymgr.h	1.16 96/01/16"
 
#ifndef SKIP_KEYMGR_H
#define SKIP_KEYMGR_H

#define COUNTERSTART  2997907200              // 1-1-95 0h in NTP time

#define MIN_KIJ_SIZE	(256/8)		     // 256 bits

#define CURRENT_NCOUNTER      (((time(0)+UNIXSTART)-COUNTERSTART)/UPDATE_FREQ)
#define UNTIL_NEXT_NCOUNTER	(time(0)-(time(0)/UPDATE_FREQ))

#define KEY_NONE		0	// No key
#define KEY_MANUAL		1	// Manual Key
#define	KEY_DH			2	// Diffie-Hellman Key
#define KEY_EC			3	// Elliptic Curve Key

#define KIJALG			0
#define KPALG			1

// Key manager error values -- used internally
#define KEYMGR_OK		0
#define KEYMGR_NOCERT		1
#define KEYMGR_BADALG		2
#define KEYMGR_SHORTKEY		3
#define KEYMGR_BAD_N_OFFSET	4
#define KEYMGR_NO_MANUAL_KEY	5
#define KEYMGR_LOCAL_EXPIRED	6

#define MGTCSIZE        2048
#define MGTDSIZE        2048

extern int UPDATE_FREQ;

typedef unsigned char ENC_ALG_TYPE;

int cryptor_get_Ekeylen(int, int, ENC_ALG_TYPE );
int cryptor_get_keylen(int, int, ENC_ALG_TYPE );
int cryptor_get_ivlen(int, int, ENC_ALG_TYPE );
int cryptor_get_flags(int, int, ENC_ALG_TYPE );
Bstream skip_encrypt(int, int, ENC_ALG_TYPE , const Bstream&, const Bstream&);
Bstream skip_decrypt(int, int, ENC_ALG_TYPE , const Bstream& , const Bstream& );
void init_cryptolib();

int skip_keymgr_init(int=0);
int skip_generate_kp_iv(const int, const Bstream, u_char,  ENC_ALG_TYPE , 
		    ENC_ALG_TYPE , ENC_ALG_TYPE, Bstream& , Bstream& , 
		    Bstream&, Bstream&, Bstream &, u_long );

int skip_get_pair_key(int, const Bstream, u_char, ENC_ALG_TYPE, 
			  u_long, int, Bstream & );
Bstream skip_dh_key_agree(const Bstream , u_char, u_long &);

Bstream skip_get_cached_secret(u_char, const Bstream);
void skip_cache_secret(const Bstream& , u_char, const Bstream , u_long , int=0);

Bstream get_local_keyid(Bstream);

Bstream skip_get_dh_public_value(const Bstream, u_char, u_long & );
int get_cert(unsigned long inaddr,unsigned char *ubuf,int *max,int ping=0);
int skip_add_cert(Bstream, u_char, u_char);
void flush_resolvers();

void find_cert(Bstream&);
int open_device(char *);
void skip_setup_fetch(int);
int get_skip_msg(int,void *, int );
int put_skip_msg(int, void *, int );
unsigned long  make_response(void *, void *, int *, struct remote_info *);
int skip_set_keyid(u_char, Bstream);
int make_boxid_msg(u_char, Bstream, void *);
int get_skip_request(int, void *, int );
int skip_alloc_size(void *);
void * localize_dhparams( const Bigint, const Bigint);
Bstream compute_dh_secret(void *, Bstream, Bstream );
Bstream skip_random_encrypt(Bstream, Bstream);
Bstream get_timestr(int=0);
Bstream exponentiate(Bstream,Bstream,Bstream,Bstream);
void lock_certbase(char *);
void unlock_certbase();

void skip_init_internal_cryptors(int);
int skip_open_device();
void skip_fetch_rsp( int, Bstream&);
void skip_send_cert_reply(Bstream &);
void keymgrd_read_rc();
void skip_flush_cache();
int FileTimeDiff(char *, char *);

int skip_decrypt_kp(const int, const Bstream, u_char, const ENC_ALG_TYPE, 
		    const ENC_ALG_TYPE, 
		    const ENC_ALG_TYPE, const Bstream&, Bstream&, 
		    Bstream &, Bstream&, u_long );

void set_kij_alg(int , unsigned char , unsigned char );

#ifdef SYSV
/*
#define bcopy(s,d,n)	memcpy(d,s,n)
*/
#endif

#endif SKIP_KEYMGR_H
