/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
 
#pragma ident "@(#)skip_certd.C	1.6 95/11/23"
 

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/fcntl.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <skip_log.h>

#include "Bigint.h"
#include "Bstream.h"
#include "certx.h" 
 
#include "my_types.h"
#include <ndbm.h>
#include "SkipCert.h"
#include "skip_certbase.h"
#include "skip_conf.h"
#include "skip_keymgr.h"	//XXX

// certificate daemon.  Receives certificate discovery requests and answers
// them.

char *requests[]={"NULL","REQUEST","RESPONSE"};

// Insert all certificates contained in the certx into the local database
int
insert_incoming(certx &request) 
{
	int i=0;
	int counter=0;
	certentry c;
	do {
		c=request.getcert(i);
		i++;
		if (c.certtype == 0)
			break;
		if (!skip_add_cert(c.cert, c.nsid, c.certtype))
			counter++;
	} while (1);
	return counter;
}

main(int argc, char *argv[]) 
{
	int sock;
	struct sockaddr_in name,from;
	int n;
	char certbuf[MAXCERTBUF];
	char msgbuf[MAXCERTBUF];
	char buf[MAXCERTBUF];
	int fromlen;
	certx request, reply;
	int certfd,certsz;
	int rbufsize=65535;	// Big UDP packet
	FILE *fp;
	fp=stdout;

// Socket stuff.  Set up receiving socket.
	fromlen=sizeof(from);
	sock=socket(AF_INET,SOCK_DGRAM,0);
	if (sock < 0 ) {
		skip_log(SKIP_ERROR,"Cannot open socket");
		exit(1);
	}
	(void)setsockopt(sock,SOL_SOCKET, SO_RCVBUF, 
			 (char *)&rbufsize, sizeof(rbufsize));
	name.sin_family=AF_INET;
	name.sin_addr.s_addr=INADDR_ANY;
	name.sin_port=htons(CDP_PORT);
	if (bind(sock, (struct sockaddr *)&name, sizeof (name)))  {
		skip_log(SKIP_ERROR,"Unable to bind socket");
		exit(1);
	}
	skip_log(SKIP_ERROR,"Certificate Daemon Starting");

// Loop forever receiving requests
	while (1){
		n=recvfrom(sock, buf, sizeof(buf), 0, (struct sockaddr *)&from, 
			 &fromlen);
		Bstream bufstr=Bstream(n, (u_char *)buf);
		
// Decode the certificate discovery packet
		if (request.decode(bufstr)) {
			skip_log(SKIP_ERROR,"mangled request");
			continue;
		}
		String temp;	
		temp=request.mkid.gethexstr();
		sprintf(msgbuf,"%s ip: %s port 0x%02x about: %s(%02x)", 
				requests[request.action],
				inet_ntoa(from.sin_addr),
				ntohs(from.sin_port),
				(const char *)temp, request.nsidmkid);

// Add any certificates contained in the request into the local database
		(void)insert_incoming(request);

// Answer the various requests
// XXX note: skip_get_dh_cert only returns one certificate at the moment.
// Therefore one key encoded into multiple certificates will only return
// the first one.
		if (request.action == CDP_REQUEST) {
			Bstream cert;
			int ncerts;
                        int ret=skip_get_dh_cert(  request.mkid,
						   request.nsidmkid,
						   SKIP_CERT_X509, //XXX
                                                   cert);

			if (ret)  {		// Couldn't get the certificate
				ret=1;
				strcat(msgbuf, " failed");
				reply=certx((u_char)CDP_RESPONSE, 
					    (u_char) CDP_STATUS_NOTFOUND,
				    	    request.nsidmkid, request.mkid);
			}
			else {			// Got it.  Send it back
				ncerts=1;
				strcat(msgbuf, " succeeded");
				reply=certx((u_char)CDP_RESPONSE, (u_char) 0,
				    request.nsidmkid, request.mkid);
				certentry t((u_char)SKIP_CERT_X509, 
				    (u_char)request.nsidmkid,
			            cert);	
				reply.addcert(t);
			}
			
			skip_log(SKIP_ERROR,msgbuf);
			Bstream replystr;
			replystr=reply.encode();
			sendto(sock, (const char *)replystr.getdatap(), 
				 replystr.getlength(), 0, 
				(struct sockaddr *)&from, sizeof(from));
		}
		else {
		   skip_log(SKIP_ERROR,"Illegal Request %d\n",request.action);
		}
	}
}
