/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
;
#pragma ident "@(#)skip_certbase.C	1.11 95/11/28"
 

// skip_certbase:  Various routines to handle the local database of certificates
#include <sys/types.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include "malloc.h"

#include "my_types.h"
#include "Time.h"
#include "Bigint.h"
#include  "Bstream.h"
#include "ObjId.h"
#include "Name.h"
#include "SkipCert.h"
#include "X509Cert.h"
#include "X509skip.h"
#include "HashCert.h"
#include "userfuncs.h"

#include "Sig.h"
#include "encrypt.h"

#include <sys/types.h>
#include <netinet/in.h>
#include <unistd.h>
#include <ndbm.h>

#include "skip_certbase.h"
#include "skip_conf.h"

char *certs_base=SKIP_CERTSBASE;

char *lockfile=SKIP_CERTSBASE".lock";

// This doesn't belong here but is included because this file gets linked in
// everywhere.

int nsid_sizes[] = {4,4,4,16,16,16,16,6,16,16,16,16}; 

// Given a boxid, nsid and certificate type, get the certificate from the
// database.  This routine is limited to one certificate.  It will have
// to be extended to allow a list of certificates to be returned. certtype
// is ignored since we store all certificates in the same database.
int
skip_get_dh_cert(const Bstream boxid, u_char nsid, u_char certtype,
		 Bstream &outcert)
{
	Bstream null;
	Bstream key;
	DBM *db;
	int lf;

	key=Bstream(1,&nsid)+boxid;
	datum	boxid_datum, cert;
	boxid_datum.dptr = (char *)key.getdatap();
	boxid_datum.dsize = key.getlength();

	if (skip_db_lock())  {
		return 3 ;
	}
	db = dbm_open((char *)certs_base,O_RDWR | O_CREAT, 0644);
	if (db == NULL)  {
		skip_db_unlock();
		return 1;
	}
	cert = dbm_fetch(db, boxid_datum);
	if (cert.dsize == 0) {
		skip_db_unlock();
		return 2;
	}
	Bstream certstr(cert.dsize, (byte *)cert.dptr);
	outcert=certstr;
	dbm_close(db);
	if (skip_db_unlock()) 
		return 3;
	return (0);
}

// Add a certificate to the database.   
int
skip_set_dh_cert(const Bstream boxid, u_char nsid, u_char certtype,
		const Bstream& certstr)
{
	DBM	*db;
	datum	boxid_datum, cert;

	Bstream tmpcertstr = certstr;
	Bstream key;

	key=Bstream(1,&nsid)+boxid;

	boxid_datum.dptr = (char *)key.getdatap();
	boxid_datum.dsize = key.getlength();
	cert.dptr = (char *)tmpcertstr.getdatap();
	cert.dsize = tmpcertstr.getlength();
	if (skip_db_lock() )
		return -2;  		// Should be a define
	
	db = dbm_open((char *)((const char *)certs_base),
		O_RDWR + O_CREAT, 0644);
	if (db == NULL)  {
		skip_db_unlock();
		return (-1);
	}
	int ret = dbm_store(db, boxid_datum, cert, DBM_REPLACE);
	dbm_close(db);
	if (skip_db_unlock())
		return -2;		// should be a define

	return (ret);
}

// delete a certificate from the database.
int
skip_del_dh_cert(const Bstream boxid, u_char nsid, u_char certtype)
{
	DBM	*db;
	datum	boxid_datum;
	Bstream key;

	key=Bstream(1,&nsid)+boxid;
	boxid_datum.dptr = (char *)key.getdatap();
	boxid_datum.dsize = key.getlength();
	if (skip_db_lock())
		return -2;
	db = dbm_open((char *)((const char *)certs_base),
		O_RDWR + O_CREAT, 0644);
	if (db == NULL) {
		skip_db_unlock();
		return (-1);
	}
	int ret = dbm_delete(db, boxid_datum);
	dbm_close(db);
	if (skip_db_unlock() ) {
		skip_db_unlock();
		return -2;
	}
	return (ret);
}

char *cert_error(enum VerifyResult result);
extern Bstream CA_cert;


// higher level routine to add a certificate to the database.  The certificate
// is verified first and then inserted.

skip_add_cert(Bstream cert, u_char nsid, u_char certtype)
{
	Bstream cacertstr;
	Bstream name;
	int retval;
	int error = 0;
	Bstream nullstr;

	switch (certtype) {
		case SKIP_DH_PUBLIC: {
			HashCert dh_cert;
			if (dh_cert.decode(cert))
				return 1;
			name = dh_cert.skip_name();
			break;
		}
		case SKIP_CERT_X509: {
			X509SkipCert dh_cert, certifier;

			/* Load the CA public certficate */
			cacertstr = File_to_Bstr(CA_SELFCERT_FILE);  // XXX
			if (certifier.decode(cacertstr)) 
				return(1);
			if (!certifier.isValid(cacertstr)) 
				return 1;
			if (dh_cert.decode(cert)) 
				return 1;
			if (!dh_cert.isValid(cacertstr))
				return 1;
			name = dh_cert.skip_name();
			break;
		}
		case SKIP_CERT_PGP:
			return 1;
		default:
			return 1;
	}
	retval = skip_set_dh_cert( name, nsid, certtype, cert);
	return retval;
}

// file descriptor used by the locking routines.

static int lf;

// locking routines for the datbase.

int skip_db_lock()
{
	char *lockfile=SKIP_CERTSBASE".lock";
        lf=open(lockfile, O_RDWR|O_CREAT,0644);
        return lockf(lf,F_LOCK, 0);
}
 
int skip_db_unlock()
{
	lockf(lf,F_ULOCK,0);
	close(lf);
        return 0;
}
