/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_cdp.C	1.4 95/11/18"

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <sys/time.h>
#include <sys/times.h>
#include <sys/socket.h>
#include <sys/signal.h>
#include <netinet/in.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <Bstream.h>
#include <Bigint.h>
#include "my_types.h"
#include "certx.h"
#include "SkipCert.h"
#include "skip_conf.h"
#include "skip_fetchcert.h"

#define MAXTRIES	5

int get_local_boxid();

#ifdef SOLARIS2
extern "C" open(char *,int,...);
#endif
extern int errno;
/* cdp_get_cert
**	Implement the certificate discovery protocol
**   	Input: 
**		IP Address of the server you wish to query.
**		NSID of keyid you are looking up.
**		Keyid you are lookup up.
** 		Pointer to pointer to SkipCert where certificate will be 
**		placed.
**
**	Limitation: Only 1 certificate will be returned.  The Certificate
**		    discovery protocol can return a number of certificates
**		    so this really needs to be fixed.
*
**	Returns: Status (0=OK, -1=Error, 1=No response
*/
int
cdp_get_cert(struct in_addr *ip_addr, u_char nsid, Bstream keyid, 
	      SkipCert **cert)
{
	int sock;
	int bufsize;
	struct sockaddr_in name,recv_addr,from;
	struct timeval tv;
	int rbufsize;
	u_char buf[65535];
	char *mycert;
	fd_set f;
	int n,i;
	int fd;

	*cert = NULL;
	sock=socket(AF_INET,SOCK_DGRAM,0);
	rbufsize=65535;
	(void)setsockopt(sock,SOL_SOCKET, SO_RCVBUF, 
                       (char *)&rbufsize, sizeof(rbufsize));

	if (sock < 0 ) 
		return CDP_STATUS_LOCALERR;

	name.sin_addr.s_addr=ip_addr->s_addr;
	name.sin_family=AF_INET;
	name.sin_port=htons(CDP_PORT);

	recv_addr.sin_addr.s_addr=INADDR_ANY;
	recv_addr.sin_family=AF_INET;
	recv_addr.sin_port=htons(CDP_CLIENT_PORT);

	certx request;
	Bstream reqstr;

	request=certx((u_char)CDP_REQUEST, 0, nsid, keyid);
	reqstr=request.encode();

	bind(sock, (struct sockaddr *)&recv_addr, sizeof(recv_addr));
	for (i=0; i<=MAXTRIES; i++ ) {
		if (sendto(sock, (const char *)reqstr.getdatap(), 
			   reqstr.getlength(), 0, (struct sockaddr *)&name, 
			   sizeof(name))<0)  {
			close(sock);
			return CDP_STATUS_ERROR;
		}
		tv.tv_sec=5;
		tv.tv_usec=0;
		FD_ZERO(&f);
		FD_SET(sock,&f);
		n=select(sock+1,&f,NULL,NULL,&tv);
		if (n > 0)  {
			int fromlen;
			fromlen=sizeof(from);
			n=recvfrom(sock, (char *)buf,sizeof(buf),0,
				(sockaddr *)&from,&fromlen);
			break;
		}
	}
	if (i > 5) {
		close(sock);
		return CDP_STATUS_LOCALERR;
	}
	close(sock);
	
	Bstream replystr=Bstream(n, buf);
	certx response;
	response.decode(replystr);
	if (response.status)
		return response.status;
	certentry x=response.getcert(0);
	*cert = decode_SkipCert(x.certtype, x.cert);
	return CDP_STATUS_OK;
}

