/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)test_passwd.C	1.5 95/12/04 Sun Microsystems"

#include <stdio.h>
#include <stdlib.h>
#include "Bstream.h"
#include "Bigint.h"
#include "ObjId.h"
#include "Passwd.h"

main(int argc, char **argv)
{
	String errormsg;
	Bstream input, passwd, encrypted, decrypted, nullbstr;
	int	c, x;
	char	*inputFile = NULL, *pass = NULL;
	ObjId	md_oid = md5;
	extern char *optarg;
	extern int optind, opterr;

	while ((c = getopt(argc, argv, "f:m:")) != EOF) {
		switch (c) {
		case 'f':
			inputFile = optarg;
			break;
		case 'm':
			x = atoi(optarg);
			if (x == 5)
				md_oid = md5;
			else if (x == 2)
				md_oid = md5;
			else {
				fprintf(stderr,
					"Unsupported message disgest.\n");
				exit(1);
			}
			break;
		case '?':
		default:
			fprintf(stderr,
			"Usage: %s [-f input filename] [-m md#]\n",
				argv[0]);
			exit(1);
		}
	}

	if (inputFile == NULL)
		input = Bstream("this text will get encrypted ...\n");
	else {
		input = File_to_Bstr(inputFile);
		if (input == nullbstr) {
			fprintf(stderr,
				"couldn't read input from %s\n", inputFile);
			exit(1);
		}
	}
	pass = passwd_confident("Enter password: ");
	if (pass == NULL) {
		passwd = Bstream("this is the test passwd !");
		fprintf(stderr, "Using default passwd ");
		passwd.prints();
		fprintf(stderr, "\n");
	} else
		passwd = Bstream(strlen(pass), (unsigned char *)pass);

	encrypted = passwd_encrypt((const Bstream&)passwd,
			(const Bstream&)input, md_oid, errormsg);
	if (encrypted == nullbstr) {
		printf("test_passwd: error encrypting\n");
		exit(1);
	}

	decrypted = passwd_decrypt((const Bstream&)passwd,
			(const Bstream&)encrypted, md_oid, errormsg);
	if (decrypted == nullbstr) {
		printf("test_passwd: error decrypting\n");
		exit(1);
	}
#ifdef DEBUG
	printf("input: "); input.print(); printf("\n");
	printf("encrypted: "); encrypted.print(); printf("\n");
	printf("decrypted: "); decrypted.print(); printf("\n");
#endif
	if (input == decrypted) {
		printf("test successful\n");
		exit(0);
	}
	printf("test failed\n");
	exit(1);
}
