/*
 *  $Id: fist.h,v 1.1 1998/12/02 23:37:19 ezk Exp $
 */

#ifndef __FIST_H_
#define __FIST_H_

/*
 * KERNEL ONLY CODE:
 */
#ifdef __KERNEL__
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/string.h>
#include <linux/stat.h>
#include <linux/errno.h>
#include <linux/locks.h>
#include <linux/smp.h>
#include <linux/smp_lock.h>
#include <linux/file.h>
#include <linux/malloc.h>
#include <linux/vmalloc.h>
#include <linux/poll.h>

#include <linux/dcache_func.h>
#include <linux/swap.h>

#include <asm/system.h>
#include <asm/segment.h>
#include <asm/mman.h>


/*
 * MACROS:
 */

/* those mapped to ATTR_* were copied from linux/fs.h */
#define FA_MODE		ATTR_MODE
#define FA_UID		ATTR_UID
#define FA_GID		ATTR_GID
#define FA_SIZE		ATTR_SIZE
#define FA_ATIME	ATTR_ATIME
#define FA_MTIME	ATTR_MTIME
#define FA_CTIME	ATTR_CTIME
#define FA_ATIME_SET	ATTR_ATIME_SET
#define FA_MTIME_SET	ATTR_MTIME_SET
#define FA_FORCE	ATTR_FORCE
#define FA_ATTR_FLAGS	ATTR_ATTR_FLAG

/* must be greater than all other ATTR_* flags! */
#define FA_NLINK	2048
#define FA_BLKSIZE	4096
#define FA_BLOCKS	8192
#define FA_TIMES	(FA_ATIME|FA_MTIME|FA_CTIME)
#define FA_ALL		0


/*
 * TYPEDEFS:
 */
typedef struct dentry dentry_t;
typedef struct file file_t;
typedef struct inode inode_t;
typedef struct page page_t;
typedef struct qstr qstr_t;
typedef struct super_block super_block_t;
typedef struct vm_area_struct vm_area_t;


/*
 * EXTERNALS:
 */
extern void fist_mod_dec_use_count(void);


#ifdef FIST_DEBUG

extern int fist_get_debug_value(void);
extern int fist_set_debug_value(int val);
extern void fist_dprint_internal(int level, char *str,...);
extern void fist_print_dentry(char *str, const dentry_t *dentry);
extern void fist_print_inode(char *str, const inode_t *inode);
extern void fist_print_file(char *str, const file_t *file);
extern void fist_print_buffer_flags(char *str, struct buffer_head *buffer);
extern void fist_print_page_flags(char *str, page_t *page);
extern void fist_print_page_bytes(char *str, page_t *page);
extern void fist_print_pte_flags(char *str, const page_t *page);
extern void fist_checkinode(inode_t *inode, char *msg);

#define STATIC
#define ASSERT(EX)	\
do {	\
    if (!(EX)) {	\
	printk(KERN_CRIT "ASSERTION FAILED: %s at %s:%d (%s)\n", #EX,	\
	       __FILE__, __LINE__, __FUNCTION__);	\
	(*((char *)0))=0;	\
    }	\
} while (0)

#define dprintk(format, args...) printk(KERN_DEBUG format, ##args)
#define fist_dprint(level, str, args...) fist_dprint_internal(level, KERN_DEBUG str, ## args)
#define print_entry_location() fist_dprint(4, "IN:  %s %s:%d\n", __FUNCTION__, __FILE__, __LINE__)
#define print_exit_location() fist_dprint(4, "OUT: %s %s:%d\n", __FUNCTION__, __FILE__, __LINE__)
#define print_exit_status(status) fist_dprint(4, "OUT: %s %s:%d, STATUS: %d\n", __FUNCTION__, __FILE__, __LINE__, status)

#else /* not FIST_DEBUG */

#define fist_get_debug_value()	-1
#define fist_set_debug_value(a)	-1
#define fist_dprint_internal(level, str, args...)
#define fist_print_dentry(a, b)
#define fist_print_inode(a, b)
#define fist_print_buffer_flags(a, b)
#define fist_print_page_flags(a, b)
#define fist_print_page_bytes(a, b)
#define fist_print_pte_flags(a, b)
#define fist_checkinode(a, b)

#define STATIC	static
#define ASSERT(EX)
#define dprintk(format, args...)
#define fist_dprint(level, format, args...)
#define print_entry_location()
#define print_exit_location()
#define print_exit_status(status)

#endif /* not FIST_DEBUG */



#if 0
//////////////////////////////////////////////////////////////////////////////
/// CODE FROM fs/namei.c
//////////////////////////////////////////////////////////////////////////////
/*
 * Whee.. Deadlock country. Happily there is only one VFS
 * operation that does this..
 */
static inline void double_lock(struct dentry *d1, struct dentry *d2)
{
    struct semaphore *s1 = &d1->d_inode->i_sem;
    struct semaphore *s2 = &d2->d_inode->i_sem;

    if (s1 != s2) {
	if ((unsigned long) s1 < (unsigned long) s2) {
	    struct semaphore *tmp = s2;
	    s2 = s1; s1 = tmp;
	}
	down(s1);
    }
    down(s2);
}

static inline void double_unlock(struct dentry *d1, struct dentry *d2)
{
    struct semaphore *s1 = &d1->d_inode->i_sem;
    struct semaphore *s2 = &d2->d_inode->i_sem;

    up(s1);
    if (s1 != s2)
	up(s2);
    dput(d1);
    dput(d2);
}

static inline struct dentry *get_parent(struct dentry *dentry)
{
    return dget(dentry->d_parent);
}

static inline void unlock_dir(struct dentry *dir)
{
    up(&dir->d_inode->i_sem);
    dput(dir);
}

/*
 * Locking the parent is needed to:
 *  - serialize directory operations
 *  - make sure the parent doesn't change from
 *    under us in the middle of an operation.
 *
 * NOTE! Right now we'd rather use a "struct inode"
 * for this, but as I expect things to move toward
 * using dentries instead for most things it is
 * probably better to start with the conceptually
 * better interface of relying on a path of dentries.
 */
static inline struct dentry *lock_parent(struct dentry *dentry)
{
    struct dentry *dir = dget(dentry->d_parent);

    down(&dir->d_inode->i_sem);

    /* Un-hashed or moved?  Punt if so.. */
    if (dir != dentry->d_parent || list_empty(&dentry->d_hash)) {
	if (dir != dentry) {
	    unlock_dir(dir);
	    dir = ERR_PTR(-ENOENT);
	}
    }
    return dir;
}

#define LOOKUP_FOLLOW		(1)
#endif
//////////////////////////////////////////////////////////////////////////////
/// end of stuff copied from kernel sources (2.1.126)
//////////////////////////////////////////////////////////////////////////////

static inline void
fist_copy_attr_atime(inode_t *dest, const inode_t *src)
{
    ASSERT(dest != NULL);
    ASSERT(src != NULL);
    dest->i_atime = src->i_atime;
}
static inline void
fist_copy_attr_times(inode_t *dest, const inode_t *src)
{
    ASSERT(dest != NULL);
    ASSERT(src != NULL);
    dest->i_atime = src->i_atime;
    dest->i_mtime = src->i_mtime;
    dest->i_ctime = src->i_ctime;
}
static inline void
fist_copy_attr_timesizes(inode_t *dest, const inode_t *src)
{
    ASSERT(dest != NULL);
    ASSERT(src != NULL);
    dest->i_atime = src->i_atime;
    dest->i_mtime = src->i_mtime;
    dest->i_ctime = src->i_ctime;
    dest->i_size = src->i_size;
    dest->i_blocks = src->i_blocks;
}
static inline void
fist_copy_attr_all(inode_t *dest, const inode_t *src)
{
    print_entry_location();
    ASSERT(dest != NULL);
    ASSERT(src != NULL);
    dest->i_mode = src->i_mode;
    dest->i_nlink = src->i_nlink;
    dest->i_uid = src->i_uid;
    dest->i_gid = src->i_gid;
    //    dest->i_rdev = src->i_rdev;
    dest->i_size = src->i_size;
    dest->i_atime = src->i_atime;
    dest->i_mtime = src->i_mtime;
    dest->i_ctime = src->i_ctime;
    dest->i_blksize = src->i_blksize;
    dest->i_blocks = src->i_blocks;

    dest->i_attr_flags = src->i_attr_flags;
    print_exit_location();
}

#endif /* __KERNEL__ */


/*
 * DEFINITIONS FOR USER AND KERNEL CODE:
 */
#define FIST_IOCTL_GET_DEBUG_VALUE      _IOR(0x15, 1, int)
#define FIST_IOCTL_SET_DEBUG_VALUE      _IOW(0x15, 2, int)

#endif /* not __FIST_H_ */

/*
 * Local variables:
 * c-basic-offset: 4
 * End:
 */
