/* Print debugging functions */

#include <stdarg.h>
#include <linux/kernel.h>
#include FIST_HEADER

#ifdef FIST_DEBUG

static int fist_debug_var = 18;

/* get value of debugging variable */
int
fist_get_debug_value(void)
{
  return fist_debug_var;
}

/* set debug level variable and return the previous value */
int
fist_set_debug_value(int val)
{
  int prev = fist_debug_var;

  fist_debug_var = val;
  return prev;
}

/*
 * Utilities used by both client and server
 * Standard levels:
 * 0) no debugging
 * 1) hard failures
 * 2) soft failures
 * 3) current test software
 * 4) main procedure entry points
 * 5) main procedure exit points
 * 6) utility procedure entry points
 * 7) utility procedure exit points
 * 8) obscure procedure entry points
 * 9) obscure procedure exit points
 * 10) random stuff
 * 11) all <= 1
 * 12) all <= 2
 * 13) all <= 3
 * ...
 */

static char buf[256];
void
fist_dprint_internal(int level, char *str,...)
{
  va_list ap;
  int var = fist_get_debug_value();

  if (var == level || (var > 10 && (var - 10) >= level)) {
    va_start(ap, str);
    vsprintf(buf, str, ap);
    printk("%s", buf);
    va_end(ap);
  }
  return;
}

#if 0
void
fist_print_page(char *str, struct page *page)
{
  printk("        %s: %s=%x\n", str, "next", (int) page->next);
  printk("        %s: %s=%x\n", str, "prev", (int) page->prev);
  printk("        %s: %s=%x\n", str, "inode", (int) page->inode);
  printk("        %s: %s=%x\n", str, "offset", (int) page->offset);
  printk("        %s: %s=%x\n", str, "next_hash", (int) page->next_hash);
  printk("        %s: %s=%x\n", str, "count", (int) page->count);
  printk("        %s: %s=%x\n", str, "flags", (int) page->flags);
  printk("        %s: %s=%x\n", str, "dirty", (int) page->dirty);
  printk("        %s: %s=%x\n", str, "age", (int) page->age);
  printk("        %s: %s=%x\n", str, "wait", (int) page->wait);
  printk("        %s: %s=%x\n", str, "prev_hash", (int) page->prev_hash);
  printk("        %s: %s=%x\n", str, "buffers", (int) page->buffers);
  printk("        %s: %s=%x\n", str, "swap_unlock_entry", (int) page->swap_unlock_entry);
  printk("        %s: %s=%x\n", str, "map_nr", (int) page->map_nr);
}

#endif

#endif /* FIST_DEBUG */

/*
 * Local variables:
 * c-basic-offset: 4
 * End:
 */
