
// SD.C -- Disk scrambler VSD VxD device driver for w5/8
// Copyright (C) 1998 by Aman. All rights reserved....
// Cipher copyright by their respective owners, where that has been retained.
// Used in all cases with implied permission
// Many thanks to Walter Oney for providing the information how to do this
// In his excellent book "Systems programming for Windows 95
// All code here, is executed at ring 0
// Some at Appy time, some at Event time, and some at interrupt time.
// The Win95 DDK is needed to compile this driver, along with the ML asm/linker
// Place in Windowsdirectory\system\iosubsys


#define NUMSLOTS 8		// ready for when we upgrade to 8


#include "scrypt.h"     // DeviceIOCtl definitions for this device...
#define MYDEVICE 0	// we are a fixed disk (even files on removables)

// Cipher constants:

#define SUMMEROLD 0
#define BLOWFISH  1
#define TEA16     2
#define TEA32     3
#define IDEA      4
#define DES56     5
#define SQUARE    6
#define MISTY1    7
#define THREEDES  8
#define MAXCIPHER 9




#define R0FILES 1				// We are using the ring0 filing system...
#include "iosdcls.h"			// VMM and IOS headers
#include <vwin32.h>
#include <winerror.h>
#undef WANTVDXWRAPS
#include <shell.h>
#pragma hdrstop
#include <malloc.h>
#include "sd.h"
#include <vmm.h>
#include "ifsmgr.h"
#include "dosedit.c"

#define MBYTE16 3967
#define UWORD unsigned short
#define UBYTE unsigned char

#pragma pack (push)
#pragma pack(1)
typedef struct bpb
{
UWORD  bytespersector;
UBYTE  sectorspercluster;
UWORD  sectorsreserved;
UBYTE  numfats;
UWORD  numdirentries;
UWORD  smalldisksectors;
UBYTE  mediadescripter;
UWORD  sectorsperfat;
UWORD  sectorspertrack;
UWORD  numheads;
ULONG  hiddensectorcount;
ULONG  bigdisksectors;
UBYTE  drivenum;
UBYTE  bytereserved;
UBYTE  extendbootsig;
ULONG  serialnumber;
char   volname[11];
char   voltype [8];
}bpb;
#pragma pack (pop)




typedef struct timeout
{
char *name;				// name of this app, to be restarted in event of timeout..
int hwnd;				// handle for _ShellPostmessage
int time;               // time to reset.........
int flag;				// set for reset of time
int driverstarted;		// set true by driver if app restarted by device driver....
int execflag;
int dobrutal;           //brutalmode.......
char *driverfname;
char *driverfdir;

}timeout;



typedef struct executestruct

{
int shex_dwTotalSize;
int shex_dwSize;
int shex_ibOp;
int shex_ibFile;
int shex_ibParams;
int shex_ibDir;
int shex_ibEnv;
int shex_nCmdShow;
char fname[128];
char wdir [128];
}executestruct;

typedef struct changepwdata
{

	int slot;
	int opcode;
	char digest[20];
	char password[160];
	int result;

}changepwdata;


typedef struct partitionrec
{
unsigned char boot;  //0
unsigned char sh;    //1
unsigned char ss;    //2
unsigned char sc;    //3
unsigned char system; //4
unsigned char eh;     //5
unsigned char es;     //6
unsigned char ec;     //7
unsigned int  StartSector;//8,9,10,11
unsigned int  NumSectors; //12,13,14,15
}partitionrec;



int  driverversionint=0x202;
char driverversion[]="V2.02";
char spxxx[]=" ";

#define PW_CHANGETEST 0
#define PW_CHANGE 1

typedef struct mountfilestruct
{
	PDCB dcb;
	int sectorstart;  //inclusive
	int sectorend;    //inclusive
    int wavoffset;	  // set to an offset of wav data if wav, else 0
	char * fname;
	int mountdrive;
	int mountslot;
	int mountresult;
	char *critical;   // can mount with critical data if known....

}mountfilestruct;







/* 
"cryptvol", one of the most important structures 
holds all information about the mounted scrambled disk, 
including whitening table (or summer table for summer)
flags, cipher number,container filenames physical device DCB etc etc
They get passed around the code as a pointer named "cv"
It should be noted that there is a similar structure in
the Win32 app, with slightly different field names (DDK issue)
Do not modify this one, without also changing that one as well.
Strange things will be seen if you don't follow this advice.
*/


typedef struct cryptvol
{
int  cipher;
int  index;
int  wavoffset;
PDCB ldcb;
PDCB filehostdcb;  // file host device, or main dcb if partition
int booted;
int driveinuse;
int  drive;
ULONG cryptsectorfirst;
ULONG cryptsectorlast;
PDCB physdevDCB;
char  mainkeys[2048];
int   mountfilehandle;
int   devicetype;			//1=hdd 2=hddrem 256=file
//char  mountfilename[16];  

int  SKFCreateTime;
int  spare1; //digestindex;
int spare2;
int spare3;

char  volname[16];			//name of currently mounted scrambled volume.
//DCB_cd_entry filecds[8]; 
char digest [20];
char spare[20*7];


DDB addb;
DCB  logicaldcb;
char mounted_file_name[512];
} cryptvol;
typedef struct rawdata
{
int slot;
char * buffer;
int len;
int startsec;
int mode;
int result;
}rawdata;

 
typedef struct file_r0   //ring 0 file IO
{
int 	mode;
int     handle;
int     bytes;
int     status;
unsigned int     filepos;
unsigned int     size;
char *fname;
char *buffer;
int     drivenum;
}file_r0;


typedef struct r0callback
{
 void (* calladdress) (struct r0callback * r0);
}r0callback;


typedef struct diskio 
{
  unsigned int devicenum;
  unsigned int sectorstart;
  unsigned int sectorlen;
  char * bufferad;
  int mode;
  int ioresult;
} diskio;

typedef struct DrvSYSTEMTIME {  // st  
    WORD wYear; 
    WORD wMonth; 
    WORD wDayOfWeek; 
    WORD wDay; 
    WORD wHour; 
    WORD wMinute; 
    WORD wSecond; 
    WORD wMilliseconds; 
} DrvSYSTEMTIME; 


void installhook(void);
void PostToAppRelay(unsigned short q);
VOID cryptprocqueue(int readq);
PMONINFO GetBlock();
VOID cryptprocL(PIOP iop, cryptvol* cv);
VOID OnRequest(PIOP iop);
void DoCallDown(PIOP iop);
void DoCallBack(PIOP iop);
void InsertCallBack(PIOP iop, VOID (*callback)(PIOP), ULONG refdata);
void Dismount_Drive(char drive);
void appaccessrzero(file_r0 *f);
int doR0fileio(int sector,int numsectors, char *buffer,cryptvol * cv,int iorop);
USHORT OnInitialize(PAEP_bi_init aep);
USHORT OnUninitialize(PAEP_bi_uninit aep);
USHORT OnBootComplete(PAEP_boot_done aep);
USHORT OnConfigDcb(PAEP_dcb_config aep);
USHORT OnUnconfigDcb(PAEP_dcb_unconfig aep);
USHORT OnTimeout(PAEP_iop_timeout_occurred aep);
USHORT OnQuit(void);
void waitframe(void);
void borderflash(void);
void readlogical(PIOP iop,int sectorstart,int sectorcount,char *buffer, cryptvol * cv);
void writelogical(PIOP iop,int sectorstart,int sectorcount,char *buffer, cryptvol * cv);
int readblock3(int slot, char *buffer,int mode);
void outblock (PIOP iop,char *outbuffer,int sectorstart,int sectorcount,cryptvol* cv,char *workbuff);
void getfalsedir(PIOP iop,unsigned int sectorstart,unsigned int sectorcount,cryptvol * cv, char *outbuffer);
int decodeintialkeys(PIOP iop,cryptvol *cv, char* passwordptr,char *digestptr,char *extcritical);
void readallpartitions(char * extcritical);
int AppAccessBlockDevice(unsigned int devicenum,unsigned int sectorstart, unsigned int sectorlen,char *buffer, int mode);
void sectorcopy(char* dest,char *source, int num);
void	mountdiskfile(mountfilestruct *mf);
void	mountdiskfileR0(mountfilestruct *mf);
int lockdrive(PDCB mydcb,PIOP myiop,int lockmode);
int unlockdrive(cryptvol* cv);
void copyvolname(bpb* b,cryptvol * cv);
void exec (char * fname,char *wname);
int ApplicationNameSet(char * aname,char * adir,char * name);
void posttoapptimeoutmsg(void);	
void posttoappquitmsg(void);
void SDDelete(char *name);
void cryptproc(PIOP iop,cryptvol * cv);
void PostClickedName(void);
void AppPostRefreshCommand(void);
void AppPostQuitCommand(void);
void SpinTasks(void);
void AccessRawData(rawdata *d);
int dophysblock(PIOP iop,int sector,int numsectors,char *buffr,cryptvol *cv,USHORT iorop);
int checkdigest(char *d);

int revokeSKFblock(int slot,char *rand);
void ChangeThePasswords(changepwdata * cd);
void InitializeCipher(char *blin,short keylen,cryptvol *cv); 

///////////////////////////////////////////////////////////////////////////////
// more Static data
////////////////////////////////// 

//#pragma VxD_LOCKED_DATA_SEG
//char lockedpwbuffer[160];
#pragma VxD_LOCKED_DATA_SEG

ppIFSFileHookFunc prevhook=NULL;   // address of previous IFS handler
								   // after we've added ours....

char extcritdata[2048];	           // contains ext data posted in from
								   // SKF access file.
								   // It has to be copied here, as a pointer
								   // to application space, may point to void
								   // if that app gets paged out during DISK IO
								   // also used in password changes.....
									

#pragma VxD_LOCKED_DATA_SEG
//PIOP myioplist[1];
char SKFsector[256];
int execflag=0;
shellrestartitplease=0;            // set when vxd restarts application....
globaltimeoutval=0;				   // timeout 
globaltimeoutnow=0;
brutaltimeout=0;
int CreateSKFTime=0;
int prefdrive=0;
int halfseccount=0xc9;
int initialiseWPerror=0;		 // Gets set, if file access to write protected disk.
IOP initiop;
int appwindowhandle=0;
PDCB dcblist[128];
int dcbcount=0;
int readparts=0;
int DeviceNoCheckRM=0;          // don't test RM when reading sector 0, if set
								// used when application reads disk drive....
#pragma VxD_LOCKED_DATA_SEG

DrvSYSTEMTIME DiskTime;
char *wavbufferptr=0;
char applicationname[512]="this is the application name";
char applicationdir[512]= "this is the application directory";
char vxdname[512]="";
char myclickedname[512]="";
int uninstall=0;
int newpartitionmounted=0;
int ApplicationRunning=0;
int newvolume=0;
int physflag=0;
int iopaddr=0;
char * transferbuffer;
int iopno=0;
int border;
int recursed=0;
int blockwriteflag=0;
int donecounter=0;        //changes when a write is completed.....
static qnum=0;
static qflag=0;

#pragma VxD_LOCKED_DATA_SEG

typedef struct qcv      // QUEUE CRYPT VOL structure Get it ? 
{
PIOP qiop;
ULONG cvaddr;
}qcv;

#define QDATASIZE 512
qcv qdata[QDATASIZE];   // This queuse pending IO to scrambled disks
						// Otherwise we'd have to allocate a lot more ram..
 
 


#pragma VxD_LOCKED_DATA_SEG
int numcrypted=0;
int bufferstack=0;
int keysposted=0;

cryptvol  cv1={0,0,0,0,0,0,0,0};
#pragma VxD_LOCKED_DATA_SEG

cryptvol  cv2={0,0,0,0,0,0,0,0};
#pragma VxD_LOCKED_DATA_SEG

cryptvol  cv3={0,0,0,0,0,0,0,0};
#pragma VxD_LOCKED_DATA_SEG

cryptvol  cv4={0,0,0,0,0,0,0,0};
#pragma VxD_LOCKED_DATA_SEG

cryptvol  cv5={0,0,0,0,0,0,0,0};
#pragma VxD_LOCKED_DATA_SEG

cryptvol  cv6={0,0,0,0,0,0,0,0};
#pragma VxD_LOCKED_DATA_SEG


cryptvol  cv7={0,0,0,0,0,0,0,0};
#pragma VxD_LOCKED_DATA_SEG


cryptvol  cv8={0,0,0,0,0,0,0,0};
#pragma VxD_LOCKED_DATA_SEG

cryptvol* cryptvols[]=
{
&cv1,
&cv2,
&cv3,
&cv4,
&cv5,
&cv6,
&cv7,
&cv8
};

#pragma VxD_LOCKED_DATA_SEG

executestruct exstruct; // structure to allow app to be restarted

  
#pragma VxD_LOCKED_DATA_SEG

unsigned char infoc2[2048];


#pragma VxD_LOCKED_DATA_SEG

char apassword[160]; // password and digest storage...
char bpassword[160];
char cpassword[160];
char dpassword[160];
char epassword[160];
char fpassword[160];
char gpassword[160];
char hpassword[160];

int pwnum=0;


char *passes[]=
{
(char*) &apassword,
(char*) &bpassword,
(char*) &cpassword,
(char*) &dpassword,
(char*) &epassword,
(char*) &fpassword,
(char*) &gpassword,
(char*) &hpassword
};

char keypassword[160];			// storage of keydisk password.....

char digesta[20];
char digestb[20];
char digestc[20];
char digestd[20];
char digeste[20];
char digestf[20];
char digestg[20];
char digesth[20];

char *digests[]=
{
(char*) &digesta,
(char*) &digestb,
(char*) &digestc,
(char*) &digestd,
(char*) &digeste,
(char*) &digestf,
(char*) &digestg,
(char*) &digesth

};


unsigned int shift_constants[]=
{
		0x43293943,	//1
		0x94392931,	//2
		0x44212132, //3
		0x432F3421,	//4
		0x64323234,	//5
		0x86421234, //6
		0x29483821,	//7
		0x17543723,	//8
		0x43212345,	//9
		0x56372834,	//10
		0x43727384,	//11
		0x17327382,	//12
		0x0A8384832,//13
		0x78473827,	//14
		0x3276E1D4,	//15
		0x53328348,	//16
		0x32984304,	//17
		0x32673823,	//18
		0x65372347,	//19
		0x73827342,	//20
		0x0A3847387,//21
		0x94D93927,	//22
		0x65748392,	//23
		0x65748382,	//24
		0x23485847,	//25
		0x82374653,	//26
		0x23837B93,	//27
		0x23498483,	//28
		0x54378271,	//29
		0x32717475,	//30
		0x57892367, //31
		0x86543783,	//32
		0x67389212,	//32
		0x32582324,	//33
		0x3812D372,	//34
		0x75734834,	//35
		0x63825431,	//36
		0x68574731,	//37
		0x47639293,	//38
		0x37283941,	//39
		0x65732123	//40
};

#pragma VxD_LOCKED_DATA_SEG

unsigned char firstfat[]=
{
0xf8,0xff,0xff,0xff
};


char ptbuffer[40*4];   //test buffer for passwords....
int wastedxx;
char * sectorbuffer; //=(char *) &asectorbuffer;
char * tempkeybuffer;
char * partitiontestbuffer;
char *	appaccessbuffer;

#pragma VxD_LOCKED_DATA_SEG
#pragma VxD_LOCKED_CODE_SEG


int closeCrDevice(cryptvol* cv,int mode);
void finddevice(cryptvol* cv,char * f);
 
///////////////////////////////////////////////////////////////////////////////
// Initialization code and data


#pragma VxD_INIT_CODE_SEG

extern DRP theDRP;				// device registration packet

BOOL OnSysDynamicDeviceInit()
{							// OnSysDynamicDeviceInit

	cv1.cryptsectorfirst=0x7fffffff;
	cv1.cryptsectorlast=0;
	cv1.index=0;
	cv2.cryptsectorfirst=0x7fffffff;
	cv2.cryptsectorlast=0;
	cv2.index=1;
	cv3.cryptsectorfirst=0x7fffffff;
	cv3.cryptsectorlast=0;
	cv3.index=2;
	
	cv4.cryptsectorfirst=0x7fffffff;
	cv4.cryptsectorlast=0;
	cv4.index=3;

	cv5.cryptsectorfirst=0x7fffffff;
	cv5.cryptsectorlast=0;
	cv5.index=4;

	cv6.cryptsectorfirst=0x7fffffff;
	cv6.cryptsectorlast=0;
	cv6.index=5;
	
	cv7.cryptsectorfirst=0x7fffffff;
	cv7.cryptsectorlast=0;
	cv7.index=6;
	
	cv8.cryptsectorfirst=0x7fffffff;
	cv8.cryptsectorlast=0;
	cv8.index=7;


	IOS_Register(&theDRP);
	return TRUE;				// stay resident no matter what IOS says
	}							// OnSysDynamicDeviceInit

///////////////////////////////////////////////////////////////////////////////


#pragma VxD_LOCKED_CODE_SEG
BOOL OnSysDynamicDeviceExit()
	{							// OnSysDynamicDeviceExit

	return TRUE;
	}							// OnSysDynamicDeviceExit

///////////////////////////////////////////////////////////////////////////////



#pragma VxD_LOCKED_CODE_SEG
void OnTerminateThread(PTCB ht)
	{							// OnTerminateThread
    //	if (ht == thread)
	//	thread = NULL, userproc = NULL;
	}							// OnTerminateThread


void apprestart(void)
{
_asm pushad ;// start up app.
exec ((char *)  &applicationname,(char *) &applicationdir);
_asm popad
}



///////////////////////////////////////////////////////////////////////////////


#pragma VxD_LOCKED_CODE_SEG
//deviceio calls from application 'scramdisk.exe'

DWORD OnDeviceIoControl(PDIOCPARAMETERS p)
	{							// OnDeviceIoControl
	switch (p->dwIoControlCode)
		{						// select on IOCTL code

	case 0:						// VWIN32 pinging us during CreateFile
	case -1:					// CloseHandle
		break;
	
	case REQMON_SETMONITORADDRESS:
		{						// Mr Oney's IOSMONITOR interface code. Was very useful
	
		break;
		}						
	
	case REQMON_RETURNBLOCK:
		{						// RETURNBLOCK  used in walter oney's monitor

		break;
		}						// RETURNBLOCK

	case REQMON_GETIVTADDR:
		{						// GETIVTADDR

		break;
		}						// GETIVTADDR


         case REQMON_INQUIRE_DEVICES:

			{
			deviceinfo *z = (deviceinfo *) p->lpvOutBuffer;
			if ( (z==NULL)  || (p->cbOutBuffer<sizeof(deviceinfo))  )
				return ERROR_INVALID_PARAMETER;
			//MOREDISKS
			finddevice((cryptvol*)&cv1,(char *)&z->dr_lett1);		
			finddevice((cryptvol*)&cv2,(char *)&z->dr_lett2);		
            finddevice((cryptvol*)&cv3,(char *)&z->dr_lett3);		
			finddevice((cryptvol*)&cv4,(char *)&z->dr_lett4);		
			finddevice((cryptvol*)&cv5,(char *)&z->dr_lett5);	
			finddevice((cryptvol*)&cv6,(char *)&z->dr_lett6);	
			finddevice((cryptvol*)&cv7,(char *)&z->dr_lett7);		
			finddevice((cryptvol*)&cv8,(char *)&z->dr_lett8);	
			
			break;
			}


		 case	SUPPLY_PASSWORD:  //get password from scramdisk
			{
			char *pw= (char *) p->lpvInBuffer;        
			char *adigest=(char *) p->lpvOutBuffer; // 5 byte key from SHA hash
			char *pd;
			char * pdigest;
			newpartitionmounted=0;
			if ( (pw==NULL)  || (p->cbInBuffer!=160)  )
				return ERROR_INVALID_PARAMETER;		
			pwnum++;
			pwnum&=7;
			pd=passes[pwnum];
			memcpy(pd,pw,160);
			pdigest=digests[pwnum];
			memcpy (pdigest,adigest,20); //fetch in any password digest from
										 //SHA1 (done by the Win32 app caller)
			keysposted=1;	
		//	readallpartitions(NULL);
		//	if (newpartitionmounted)
		//		  memset(pw,0,160);  //clear out typed in passwords....
			break;
		 }
	

		 case CLOSE_CRYPTED_DEVICE1:   //close slot #1
			{
			int *mode = (int *) p->lpvInBuffer;
			int m=*mode;
			m=closeCrDevice(&cv1,m);
			*mode=m;
			break;
			}        

		 case CLOSE_CRYPTED_DEVICE2:
			{
			int *mode = (int *) p->lpvInBuffer;
			int m=*mode;
			m=closeCrDevice(&cv2,m);
			*mode=m;
			break;
			}        
        
		 case CLOSE_CRYPTED_DEVICE3:
			{
			int *mode = (int *) p->lpvInBuffer;
			int m=*mode;
			m=closeCrDevice(&cv3,m);
			*mode=m;
			break;
			}        
        
		 case CLOSE_CRYPTED_DEVICE4:
			{
			int *mode = (int *) p->lpvInBuffer;
			int m=*mode;
			m=closeCrDevice(&cv4,m);
			*mode=m;
			break;
            }        


		 case CLOSE_CRYPTED_DEVICE_N:
		 {
			cryptvol *cv;
			int *mode=(int *) p->lpvInBuffer;
			int m=*mode;
			int *cn=(int *) p->lpvOutBuffer;
			int c=*cn;
			cv=cryptvols[c];
			m=closeCrDevice(cv,m);
			*mode=m;
			break;
		 }


    case PUTCVS:  // get (modified)  contents of crypt structures to win32 app
        {
		unsigned char v;		 
		cryptvol* pw= (cryptvol*) p->lpvOutBuffer;        
         cryptvol* pd;
		 char *pm;
         int c,y;
		  if  (pw==NULL)
		     return ERROR_INVALID_PARAMETER;

		    for (c=0;c<NUMSLOTS;c++)
			{
              pd=cryptvols[c];
              memcpy(pw,pd,sizeof(cryptvol));
			  	
			  pm=(char *)&pw->mainkeys;

			  for (y=0;y<256;y++)
				{
			
				pm[y+1024]^=pm[1792+y];
				pm[y]^=pm[2047-y];
				memset(pm+1792,0x55,256);
				}

			  v=0x55;
			  if (!pd->booted) v=0;


			  if (!pd->SKFCreateTime) memset(&pw->mainkeys,v,2048);

			  memset ((char*) &pw->digest[0],0,20);
              pw++;
            }
	     break;

		}




	case DISKIO:  // call to read and write sectors from application

		{
          diskio *dio;
		  int s=0;	
		  dio=(diskio*) p->lpvInBuffer; 
		   if (dio)
		   {
		    s=AppAccessBlockDevice(dio->devicenum,dio->sectorstart,dio->sectorlen,dio->bufferad,dio->mode);
		    dio->ioresult=s;
		   }
		  break;
		}



	case GETDCBINFO: //application gets addresses of known physical dcbs
	 {
	 typedef struct dcbinfo
	   {
	    void *dcbarray;
	    int  dbcn;
	   }dcbinfo;
		 		 
		dcbinfo* dbi=(dcbinfo *) p->lpvInBuffer;
		dbi->dcbarray=&dcblist;
		dbi->dbcn=dcbcount;
		break;

	 }



	case FINDDRIVELETTER:  // find drive letters associated with physical dcbs
	{
		
		typedef struct fdrivestruct
		{
         PDCB dcb;   //physical dcb of drive searched for
		 unsigned int partitionsector;  //partition offset of drive start
		 int drivelett;        // letter to return
		}fdrivestruct;
  	    
		int c;
		PDCB ldcb;
		PDCB pdcb;
		fdrivestruct* fd=(fdrivestruct *) p->lpvInBuffer; 
		fd->drivelett=-1;
		for (c=0;c<26;c++)

		{
			ldcb=IspGetDcb((char)c);
			if (ldcb)   // got a logical dcb ?
			{	
				if (ldcb->DCB_cmn.DCB_Partition_Start==fd->partitionsector)

				{
					pdcb=(PDCB) ldcb->DCB_cmn.DCB_physical_dcb;
					  if (  (pdcb==fd->dcb) && (ldcb->DCB_cmn.DCB_drive_lttr_equiv==c) )
					  {
                       fd->drivelett=c;
					   break;
					  }

			     }


			}

		}

	break;
	}//FINDDRIVELETTER


	
	case DISMOUNTDRIVE: //dismounts a drive when it is being formatted for encryption

		{
		 char drive;
	     char * dr = (char *) p->lpvInBuffer;
		 drive=dr[0];
		 Dismount_Drive(drive);
		break;
		}



case MOUNTFILE: // call to mount a file/wav, as a scrambled volume.
	{
	mountfilestruct* mf=(mountfilestruct *) p->lpvInBuffer; 
#if R0FILES
	mountdiskfileR0(mf);
#else
	mountdiskfile(mf);
#endif
	break;
	}

case GETSHIFTCONST:  //return address of scramble shift constants....
	{
        int * sh = (int *) p->lpvInBuffer;
		*sh=(int) &shift_constants;
		break;
	}

case CLEARPASSWORDS:
	{
	
	char *pw;
	int c;
	int x;
	cryptvol *cv;

	for (c=0;c<8;c++)
	  {
		cv=cryptvols[c];
		cv->SKFCreateTime=0; //  SKF time dissalows SKF creation on clear passwords too.
	  }



	for (c=0;c<8;c++)
	  {
	   pw=passes[c];   //clear ALL prestored passwords out.
	   for (x=0;x<160;x++) *(pw+x)=0; // delete all cached passwords...
	   pw=digests[c];
	   for (x=0;x<20;x++) *(pw+x)=0;  // delete all cached digest values
	  }
	
	for (x=0;x<160;x++) keypassword[x]=0;
	break;
	}
	

case MOUNTNEWDISK:
	{
	 char * bc=(char *)p->lpvInBuffer;	 
	 readallpartitions(bc);  // Hard disk partition refresh call

			if (newpartitionmounted)
				  memset(lockedpwbuffer,0,160);  //clear out typed in passwords....
	 
	 break;	   
	}



case BORDER:  // debugging border flasher (256 colour modes)
	{
     int * bc = (int *) p->lpvInBuffer;
	 border=*bc;
	 borderflash();
	 break;
	}

 case VALIDATEPASSWORDS:
	 {
		// validate a password digest, against  a digest  stored in the disk structure.....
	
	int * slotp = (int *) p->lpvOutBuffer;    
	int slot=*slotp;
    char * digest=(char *) p->lpvInBuffer;   
	cryptvol *cv=cryptvols[slot];
	char *c=(char *) &cv->digest;
	int z;
	int pwok=-1;

	//20 chars MUST match
	for (z=0;z<20;z++)
		if (c[z]!=digest[z]) pwok=0;

	*slotp=pwok;

		break;
	 }

 case APPQUERY:  // used to allow only one instance of win32 app
	 {
		int * q= (int *) p->lpvInBuffer;
		*q = (int) &ApplicationRunning;  //Set and Return state to Win32 app
		break;
	 }

 case VOLQUERY:
	 {
		int * q= (int *) p->lpvInBuffer;
		*q = (int) &newvolume;
		break;
	 }


 case DRIVERVERSION:
	 {
		char ** q= (char **) p->lpvInBuffer;
		int ** i= (int **) p->lpvOutBuffer;
		*q = (char *) &driverversion;
		*i = (int *) &driverversionint;
		break;
	 }



case SETTIMEOUT:
  {
	 
		timeout * t= (timeout *) p->lpvInBuffer;	
		t->driverfname= (char *) &applicationname;
		t->driverfdir=  (char *) &applicationdir;
		t->execflag=execflag;

		if (t->flag)
					{
					globaltimeoutval=t->time;
					globaltimeoutnow=globaltimeoutval;
					brutaltimeout=t->dobrutal;
					}

		else
		{
	
			    appwindowhandle=t->hwnd;

				if (shellrestartitplease)          // app will call, on startup........
				{
					shellrestartitplease=0;
					t->driverstarted=1;
					posttoapptimeoutmsg();
				}
				else
					{
					ApplicationNameSet((char *) &applicationname,(char *) &applicationdir,(char *)t->name);
					}
		}
		
		break;
  }

case RELEASETIMESLICE:  // used so application can yeild, and wait for IO

  {
	ReleaseTimeSlice();
    break;
  }


case READINFOBLOCK:  // first 4 bytes are the slot number to read (ugh lazy)
  {
    int slot;
	char * ib = (char *) p->lpvInBuffer;
    cryptvol*cv;
    PDCB dcb;
	char *wp=(char*) p->lpvOutBuffer;	//write protect status here......
	slot=(int) *ib;
	cv=cryptvols[slot];
	dcb=cv->physdevDCB;
	*wp=0;	//no write protect
    if (!(dcb->DCB_cmn.DCB_device_flags&DCB_DEV_WRITEABLE))
	*wp=1;
	ib+=4;
	readblock3(slot,ib,0);
	break;
  }


case WRITEINFOBLOCK:  // first 4 bytes are the slot number to read (ugh lazy)
  {
    int slot;
	char * ib = (char *) p->lpvInBuffer;
    slot=(int) *ib;	
	ib+=4;
	readblock3(slot,ib,1);
	break;
  }

case R0FILEIO:
   {  

   file_r0* f=(file_r0 *) p->lpvInBuffer;
   appaccessrzero(f);
   break;
   }
  

case RING0CALLBACK:  // call back app, in ring0
   {  
   r0callback* f=(r0callback *) p->lpvInBuffer; 
   f->calladdress(f);
   break;
   }

case UNINSTALLSCRAMDISK:
	{
	 char** files=(char **) p->lpvInBuffer; 	
	 char *app=files[0];
	 //char *ini=files[1];
	 //char *vxd=files[2];
	 strcpy (applicationname,app);
	// strcpy (applicationdir,ini);
	// strcpy (vxdname,vxd);
	 uninstall=10;  //Driver will uninstall itself on  a timer....
	 break;
	
	}


case SETKEYFILEPASSWORD:
                
	{
    char *pw= (char *) p->lpvInBuffer;        
    memcpy (keypassword,pw,160);
	break;	 
	}

case GETKEYFILEPASSWORD:
	 {
	 char *pw= (char *) p->lpvInBuffer;    
	 memcpy (pw,keypassword,160);	
	 keysposted=1;
	 break;
	 }

case GETPASSWORDBUFFER:
	  {
	  char **pb= (char **) p->lpvInBuffer;    
	  *pb=(char *) &lockedpwbuffer;
	 // memset (lockedpwbuffer,0,160);	 can't clear passwords if multiple instances....
	  break;
	  }
	  
case GETINKEY:
	  {
	  
	  int  *accept= (int*) p->lpvOutBuffer; 
	  char *caption= (char *) p->lpvInBuffer;    
	  *accept=GetPasswordsDosStyle(caption); 

	  break;
	  }

case SUPPLYDATEANDTIME:
	
	{
	DrvSYSTEMTIME *sti;
	
	sti= (DrvSYSTEMTIME *) p->lpvOutBuffer; 
	memcpy((char *)&DiskTime,(char *) sti,sizeof (DrvSYSTEMTIME));
	break;
	}

case SUPPLYCLICKEDFILENAME:
    {
	char * f=(char *)p->lpvInBuffer;
	strcpy (myclickedname,f);
	PostClickedName();  // post to the running win32app...
	break;
	}

case SENDFORCEQUIT:
	{
	// sent by win32 app, (2nd instance) force closing disks if sd already running..
	if (ApplicationRunning&1)
			AppPostQuitCommand();
	break;
	}

case REVOKESKFDATA:
	{
	
	int * slotp = (int *) p->lpvOutBuffer;    
	int slot=*slotp;


    char * rand=(char *) p->lpvInBuffer;   

	*slotp=revokeSKFblock(slot,rand);


	break;
	}

case RAWDEVICEDATA:
	{

	rawdata *d=(rawdata *) p->lpvInBuffer;
	AccessRawData(d);
	break;
	}


case CHANGEPASSWORDS:
	{
	changepwdata * cd=(changepwdata *)p->lpvInBuffer;
	ChangeThePasswords(cd);
	break;
	}

case APP_REQUEST_REFRESH:
	{
	// sent by win32 app, (2nd instance) force closing disks if sd already running..
	if (ApplicationRunning&1)
			AppPostRefreshCommand();
	break;
	}

case INQUIRE_SLOT:
	{
	char  * slot=(char *)p->lpvInBuffer;
	cryptvol *cv=cryptvols[slot[0]];
	slot[1]=0;
	slot[2]=0;
	if (!cv->booted) break;
	slot[1]++; // 1
	if (cv->mountfilehandle==0) break;
	slot[2]=cv->mounted_file_name[0]; //drive letter...
	slot[1]++;// 2
	if (cv->wavoffset==0) break;
	slot[1]++;// 3
	break;
	}



  default:
  return ERROR_INVALID_FUNCTION;

  }
    return 0;
}							// OnDeviceIoControl




///////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// Asynchronous event processing:
/////////////////////////////////////////////////////////
#pragma VxD_LOCKED_CODE_SEG
#pragma VxD_LOCKED_DATA_SEG
#undef CURSEG
#define CURSEG() LCODE

int cvtestdev(void)

{
	// is there a drive open ?
	if (cv1.physdevDCB) return 1;
    if (cv2.physdevDCB) return 1;
    if (cv3.physdevDCB) return 1;
    if (cv4.physdevDCB) return 1;

	if (cv5.physdevDCB) return 1;
	if (cv6.physdevDCB) return 1;
	if (cv7.physdevDCB) return 1;
	if (cv8.physdevDCB) return 1;



	globaltimeoutval=0;
	return 0;

}



// The code below gets called by the IOS *every* 0.5 seconds...
USHORT OnHalfSec(PAEP_boot_done aep)  //dummy param
   {
    cryptvol *cv;
	int c;
	halfseccount++;

	// MORE DISKS
	if (cv1.SKFCreateTime) cv1.SKFCreateTime--;
	if (cv2.SKFCreateTime) cv2.SKFCreateTime--;
	if (cv3.SKFCreateTime) cv3.SKFCreateTime--;
	if (cv4.SKFCreateTime) cv4.SKFCreateTime--;
	if (cv5.SKFCreateTime) cv4.SKFCreateTime--;
	if (cv6.SKFCreateTime) cv4.SKFCreateTime--;
	if (cv7.SKFCreateTime) cv4.SKFCreateTime--;
	if (cv8.SKFCreateTime) cv4.SKFCreateTime--;



	if (uninstall)  // Are we being asked to uninstall ourselves ?
	{
		uninstall--;
		if (!uninstall)
		{
			
		SDDelete(applicationname);  //disccom.c
	//	SDDelete(applicationdir);
	//	SDDelete(vxdname);

		return AEP_SUCCESS;
		}
	}



	if (globaltimeoutnow&0x7fffffff)
	
		{
	
		globaltimeoutnow--;
		if ( ((globaltimeoutnow&0x7ffffff)==0)  &&  (cvtestdev()  ))

		    {
			if (brutaltimeout==2)
				{
					brutaltimeout=0;

					for (c=0;c<NUMSLOTS;c++)
						{
						cv=cryptvols[c];
						closeCrDevice(cv,0);
						closeCrDevice(cv,1);
						}

					if (ApplicationRunning&1) posttoappquitmsg();
					return AEP_SUCCESS;
				}


			
			if (ApplicationRunning&1) posttoapptimeoutmsg();

	     	else  //relaunch application
			{
			shellrestartitplease=1;
			SHELL_CallAtAppyTime((APPY_CALLBACK)&apprestart,0,0);

			}
		 }
	 }
  
  return AEP_SUCCESS;
}




VOID OnAsyncRequest(PAEP aep)
	{							// OnAsyncEvent
	typedef USHORT (*PEF)(PAEP);

	static PEF evproc[AEP_MAX_FUNC+1] =
		{(PEF) OnInitialize		//  0 AEP_INITIALIZE
		,NULL					//  1 AEP_SYSTEM_CRIT_SHUTDOWN
		,(PEF) OnBootComplete	//  2 AEP_BOOT_COMPLETE
		,(PEF) OnConfigDcb		//  3 AEP_CONFIG_DCB
		,(PEF) OnUnconfigDcb	//  4 AEP_UNCONFIG_DCB
		,NULL					//  5 AEP_IOP_TIMEOUT
		,NULL 					//  6 AEP_DEVICE_INQUIRY
		,(PEF) OnHalfSec		//  7 AEP_HALF_SEC
		,NULL					//  8 AEP_1_SEC
		,NULL				    //  9 AEP_2_SECS
		,NULL					// 10 AEP_4_SECS
		,NULL					// 11 AEP_DBG_DOT_CMD
		,NULL					// 12 AEP_ASSOCIATE_DCB
		,NULL					// 13 AEP_REAL_MODE_HANDOFF
		,NULL					// 14 AEP_SYSTEM_SHUTDOWN
		,(PEF) OnUninitialize	// 15 AEP_UNINITIALIZE
		,NULL					// 16 AEP_DCB_LOCK
		,NULL					// 17 AEP_MOUNT_VERIFY
		,NULL					// 18 AEP_CREATE_VRP
		,NULL					// 19 AEP_DESTROY_VRP
		,NULL					// 20 AEP_REFRESH_DRIVE
		,NULL					// 21 AEP_PEND_UNCONFIG_DCB
		,NULL					// 22 AEP_1E_VEC_UPDATE
		,NULL					// 23 AEP_CHANGE_RPM
		};
	PEF proc;

	if (aep->AEP_func < arraysize(evproc) && (proc = evproc[aep->AEP_func]))
		aep->AEP_result = proc(aep);
	else
		aep->AEP_result = (USHORT) AEP_FAILURE;
	}							// OnAsyncEvent

///////////////////////////////////////////////////////////////////////////////
// VSDs needn't do anything during AEP_INITIALIZE and should always
// return success



#pragma VxD_LOCKED_CODE_SEG

USHORT OnInitialize(PAEP_bi_init aep)
	{	
	// allocate our (smaller) memory buffer.....

		
	//iopsdat=(char *) _PageAllocate(2,PG_SYS,NULL,0,0,MBYTE16,NULL,PAGEZEROINIT|PAGEFIXED|PAGECONTIG|PAGEUSEALIGN);



	transferbuffer=(char *) _PageAllocate(50,PG_SYS,NULL,0,0,MBYTE16,NULL,PAGEZEROINIT|PAGEFIXED|PAGECONTIG|PAGEUSEALIGN);
	sectorbuffer=(char *) transferbuffer+(256*512);
	tempkeybuffer=(char *)transferbuffer+(257*512);
	partitiontestbuffer=(char *) transferbuffer+(265*512);
 	appaccessbuffer=transferbuffer+(265*512);  // should be exclusive....
	if (transferbuffer) return AEP_SUCCESS;
	return (USHORT) AEP_FAILURE;

	// buffer allocation:
	// disk xfer = 0..255
	// sectorbuffer in mount (asmprocs.c) is 256
	// tempkeybuffer as above = 257 (4 sectors)
	// partition test, (16 nested partitions is 

	}							// OnInitialize

///////////////////////////////////////////////////////////////////////////////


#pragma VxD_LOCKED_CODE_SEG
USHORT OnUninitialize(PAEP_bi_uninit aep)
	{							// OnUninitialize
	return AEP_SUCCESS;
	}							// OnUninitialize

///////////////////////////////////////////////////////////////////////////////
// AEP_BOOT_COMPLETE asks us if we want to stay loaded or not.




#pragma VxD_LOCKED_CODE_SEG
USHORT OnBootComplete(PAEP_boot_done aep)
	{							// OnBootComplete
	return AEP_SUCCESS;
	}							// OnBootComplete

///////////////////////////////////////////////////////////////////////////////
// AEP_CONFIG_DCB gives us the chance to hook into the calldown stack for
// every DCB in the system



#pragma VxD_LOCKED_CODE_SEG
int cmpvend(char *a, char *b, int len)
{

	int n;
	for (n=0;n<len;n++) if (a[n]!=b[n]) return 1;
	return 0;
}


USHORT OnConfigDcb(PAEP_dcb_config aep)
	{							// OnConfigDcb
	PDCB dcb = (PDCB) aep->AEP_d_c_dcb;
	if (!(dcb->DCB_cmn.DCB_device_flags & DCB_DEV_PHYSICAL))
	{
		 //dcb->DCB_cmn.DCB_dmd_flags|=DCB_dmd_serialize;
		return AEP_SUCCESS;
	}

	if (dcbcount<100)
	{
      if (  (dcb->DCB_cmn.DCB_device_type==0)||(dcb->DCB_cmn.DCB_device_type==DCB_type_cdrom) 	) //&&(dcb->DCB_cmn.DCB_unit_number>=0x80))
	  {
		  {
			  if ( cmpvend ((char*) &dcb->DCB_vendor_id,"JETICO",6) !=0)
			  {
			   dcblist[dcbcount]=dcb;
			   dcblist[dcbcount+1]=NULL;
			   dcbcount++;
			   }
			 }
		}
	}
	

//if
	((IspInsertCalldown(dcb, OnRequest, (PDDB) aep->AEP_d_c_hdr.AEP_ddb, 0,
		dcb->DCB_cmn.DCB_dmd_flags, aep->AEP_d_c_hdr.AEP_lgn))) ;
	
		return AEP_SUCCESS;
	}							
///////////////////////////////////////////////////////////////////////////////
// AEP_UNCONFIG_DCB informs us that the physical device represented by a DCB
// is going away



#pragma VxD_LOCKED_CODE_SEG

USHORT OnUnconfigDcb(PAEP_dcb_unconfig aep)
	{							
	return AEP_SUCCESS;
	}							


#pragma VxD_LOCKED_CODE_SEG
#define ior iop->IOP_ior

#pragma VxD_LOCKED_CODE_SEG
void invpart(cryptvol* cv)
 {
  cv->physdevDCB=0;
  cv->cryptsectorfirst=0xffffffff;
  cv->cryptsectorlast=0xffffffff;

}


#pragma VxD_LOCKED_CODE_SEG
int tryaddpart(cryptvol* cv,unsigned int secstart,unsigned int seclast,PDCB device)

{


 if ((cv->physdevDCB==device)&&(cv->cryptsectorfirst==secstart)) 
	  return (2);	
	
 if (cv->physdevDCB==0)
  {
   cv->physdevDCB=device;
   cv->cryptsectorfirst=secstart;
   cv->cryptsectorlast=seclast;
   if (device->DCB_max_xfer_len>256*512) 
	          device->DCB_max_xfer_len=256*512;
   return (1);
  }

 return (0);
}



int cmppart (PDCB dcb, unsigned int secstart,cryptvol *cv)
{
   if (cv->physdevDCB!=dcb) 
	   return 0; 
   if (cv->cryptsectorfirst!=secstart) 
	   return 0;
   return 1;	
}


#pragma VxD_LOCKED_CODE_SEG
struct cryptvol * addcryptedpartition(PIOP iop, char *peek)
{

 unsigned int secstart;
 unsigned int seclast;
 PDCB device;
 int d;
 peek-=4;
 peek+=8;  // point at starting sector...
 secstart= *(unsigned long *)peek;
 peek+=4;
 
 seclast=(secstart+*(unsigned long*)peek);
 device=(PDCB)iop->IOP_physical_dcb;

 // have we got it already ?
 if (cmppart(device,secstart,(cryptvol *) &cv1)) return NULL;
 if (cmppart(device,secstart,(cryptvol *) &cv2)) return NULL;
 if (cmppart(device,secstart,(cryptvol *) &cv3)) return NULL;
 if (cmppart(device,secstart,(cryptvol *) &cv4)) return NULL;
 if (cmppart(device,secstart,(cryptvol *) &cv5)) return NULL;
 if (cmppart(device,secstart,(cryptvol *) &cv6)) return NULL;
 if (cmppart(device,secstart,(cryptvol *) &cv7)) return NULL;
 if (cmppart(device,secstart,(cryptvol *) &cv8)) return NULL;

 d= tryaddpart( (cryptvol *) &cv1,secstart,seclast,device);
	 if (d==1) return &cv1;
     if (d==2) return 0;

 d= tryaddpart( (cryptvol *) &cv2,secstart,seclast,device);

	
	if (d==1) return &cv2;
    if (d==2) return 0;

 d=tryaddpart( (cryptvol *) &cv3,secstart,seclast,device);

	if (d==1) return &cv3;
    if (d==2) return 0;

 d=tryaddpart( (cryptvol *) &cv4,secstart,seclast,device);
	 
	if (d==1) return &cv4;
    if (d==2) return 0;

  d=tryaddpart( (cryptvol *) &cv5,secstart,seclast,device);
	 
	if (d==1) return &cv5;
    if (d==2) return 0;
 d=tryaddpart( (cryptvol *) &cv6,secstart,seclast,device);
	 
	if (d==1) return &cv6;
    if (d==2) return 0;

 d=tryaddpart( (cryptvol *) &cv7,secstart,seclast,device);
	 
	if (d==1) return &cv7;
    if (d==2) return 0;
d=tryaddpart( (cryptvol *) &cv8,secstart,seclast,device);
	 
	if (d==1) return &cv8;
    if (d==2) return 0;
 
	
	
	
	
return NULL;
}

#pragma VxD_LOCKED_CODE_SEG


BOOL Kill_Drive(cryptvol* cv)

{

PDCB dcb;
unsigned char tkey[36]="39dkifJl439./;Jdc98JH7&&sT$Bmdse";	
BOOL result=FALSE;




 
	if ((!cv->driveinuse)&&(cv->physdevDCB))
	 {	 
		if ((cv->drive>=0) && (cv->drive<26))  //hard drives only as yet....
		 {
			
		 result=IspDisassociateDcb(cv->drive);
		  if (cv->mountfilehandle)
			   R0_CloseFile(cv->mountfilehandle);

	      if (result==TRUE)

	       {
	       if (!cv->mountfilehandle) unlockdrive(cv);  // files to be handled by win32 app.
		
		   // use the junk key above to clear all
		   // previous key data etc in the cipher code,when dismouting a disk
		 
		   if (cv->cipher) InitializeCipher( (char *) &tkey,20,cv);
		   
		   dcb=cv->ldcb;
	       dcb->DCB_Port_Specific=0;
	       memset(cv,0,sizeof(cryptvol));
           cv->cryptsectorfirst=0x7fffffff;
	       }
        }
  }
 return result;
}


BOOL OnKernel32_Shutdown(void)
{
/////////////////////////////////////////////////
// Called when kernel 32 is about to die.
// We must close down the files, 
// for any files mounted as encrypted disks.
// this call seems to be the only chance we get.
// the system pukes amd hangsif we don't. Corrupt screen etc.
// and refuses to shut down.....
////////////////////////////////////////////////
	cryptvol *cv;
	int c;

	for (c=0;c<NUMSLOTS;c++)
	 {
	   cv=cryptvols[c];
	   unlockdrive(cv);
	   if (cv->mountfilehandle)
		    R0_CloseFile(cv->mountfilehandle);
	 }

return TRUE;
}

void zapcv(cryptvol *cv, char drive)

{
if ((cv->drive==drive)&&(cv1.booted))
   {
   memset (cv,0,sizeof(cryptvol));
   cv->cryptsectorfirst=0x7fffffff;
   }

}

void Dismount_Drive(char drive)   //Dismount a disk to be re- formatted......
{
    
	drive=drive-'A';
	IspDisassociateDcb(drive);
	zapcv((cryptvol*) &cv1,drive);  //clear out if was an encrypted drive....
	zapcv((cryptvol*) &cv2,drive);  // Only zaps one of these, if any....
	zapcv((cryptvol*) &cv3,drive);
	zapcv((cryptvol*) &cv4,drive);

	zapcv((cryptvol*) &cv5,drive);
	zapcv((cryptvol*) &cv6,drive);
	zapcv((cryptvol*) &cv7,drive);
	zapcv((cryptvol*) &cv8,drive);




}




int temptest=0;

VOID partfilerequest(PIOP iop)

{

	PDCB dcb;
	cryptvol * cv;

	dcb= (PDCB) iop->IOP_physical_dcb;
	cv=(cryptvol *) dcb->DCB_Port_Specific;
	

	//OPTIMISE PLEASE (CHECK IF NEEDED NOW ANYWAY)

	if ( (cv!=&cv1) && (cv!=&cv2) && (cv!=&cv3) && (cv!=&cv4)  && (cv!=&cv5) && (cv!=&cv6) && (cv!=&cv7) && (cv!=&cv8))

	{		
		DoCallDown(iop);
		return;

	}



	if (cv->booted>2)

	{
		ior.IOR_status=IORS_NOT_READY; //HW_FAILURE;
		DoCallBack(iop);
		return;
	}



	 if (ior.IOR_func==IOR_COMPUTE_GEOM)

		{ 
		dcb->DCB_actual_sector_cnt[0]=cv->cryptsectorlast-cv->cryptsectorfirst; 
		dcb->DCB_actual_sector_cnt[0]++;
		dcb->DCB_actual_sector_cnt[1]=0;
		dcb->DCB_actual_blk_size=512; 
        dcb->DCB_actual_head_cnt=1;       // number of heads
        dcb->DCB_actual_cyl_cnt=1;        // number of cylinders
		dcb->DCB_cmn.DCB_apparent_blk_shift=9; 	  
		dcb->DCB_cmn.DCB_TSD_Flags|=DCB_TSD_ACTUAL_PRE_SET;
		ior.IOR_status=IORS_SUCCESS;
		DoCallBack(iop);
		return;
		}

	if (ior.IOR_func==IOR_GEN_IOCTL)
		{
		if (iop->IOP_ior.IOR_ioctl_function==0x440d)
		{
			if (iop->IOP_ior.IOR_ioctl_control_param==0x872)
			{
					ior.IOR_status=IORS_INVALID_PARM; 

			}

		}


		ior.IOR_status=IORS_INVALID_PARM; // All the time now.... 
		DoCallBack(iop);
		return;

		}


	if ((ior.IOR_func==IOR_READ)||(ior.IOR_func==IOR_WRITE))

	    {
		dcb= (PDCB) iop->IOP_physical_dcb;
		ior.IOR_status=0;  // IORS_CMD_IN_PROGRESS; 	
		cryptprocL(iop,cv);  // win95 queue.....
		return;
	    }

		if ((ior.IOR_func==IOR_MEDIA_CHECK)||(ior.IOR_func==IOR_MEDIA_CHECK_RESET))
		{
		
		dcb= (PDCB) iop->IOP_original_dcb;

		    ior.IOR_status=IORS_UNCERTAIN_MEDIA; //IORS_SUCCESS;
			temptest=0;
			DoCallBack(iop);
			return;
		}

		ior.IOR_status=IORS_INVALID_COMMAND;
		DoCallBack(iop);
		
	return;
}




#pragma VxD_LOCKED_CODE_SEG
void Add_Drive(PDCB dcb,cryptvol* cv,char *extcritical)

{
	
	int md=0;
    PDCB ldcb;
    unsigned int flags;
	unsigned int dmdbits;
	ldcb=&cv->logicaldcb;
	cv->ldcb=ldcb;

#if R0FILES
		 if (1) //!cv->mountfilehandle) WAS only partitions. Now ALL
		{
	
#endif
	
		ldcb=&cv->logicaldcb;	
		flags=ldcb->DCB_cmn.DCB_device_flags;

		if (dcb)
			memcpy ((char *) ldcb,(char *) dcb,sizeof(DCB));

		ldcb->DCB_cmn.DCB_device_flags=flags;
		flags=dcb->DCB_cmn.DCB_device_flags;
		dmdbits=dcb->DCB_cmn.DCB_dmd_flags;
		dmdbits&=~DCB_dmd_phys_sgd;
		cv->ldcb=ldcb;
	     	if (!cv->mountfilehandle)  
	           	IspInsertCalldown(ldcb, partfilerequest, (PDDB) &cv->addb, 
				(USHORT) dcb->DCB_cmn.DCB_expansion_length,
		        dmdbits,(UCHAR) DRP_VSD_3);

		 else
		 
		    IspInsertCalldown(ldcb, partfilerequest, (PDDB) &cv->addb, 0,
		     0,(UCHAR) DRP_VSD_3);

		 cv->devicetype=1;
		 if (dcb)
		 {
		   if (dcb->DCB_cmn.DCB_device_flags&DCB_DEV_REMOVABLE)
		          cv->devicetype=2;
		 }
		 ldcb->DCB_Port_Specific=(ULONG) cv;
		 ldcb->DCB_cmn.DCB_physical_dcb=(ULONG)ldcb;
		 ldcb->DCB_max_xfer_len=256*512;

		if ( (dcb->DCB_max_xfer_len<256*512) && (cv->mountfilehandle==0) )
			 ldcb->DCB_max_xfer_len=dcb->DCB_max_xfer_len;

		 if (!cv->mountfilehandle)
		 {
		    ldcb->DCB_max_sg_elements=dcb->DCB_max_sg_elements; //1;
			ldcb->DCB_cmn.DCB_expansion_length=dcb->DCB_cmn.DCB_expansion_length;
		    ldcb->DCB_cmn.DCB_dmd_flags=dmdbits;
		 }
			
		else
		    ldcb->DCB_max_sg_elements=17;
		
		 ldcb->DCB_cmn.DCB_device_flags|=DCB_DEV_PHYSICAL;	 
		 ldcb->DCB_cmn.DCB_device_flags2=0;  
		 ldcb->DCB_cmn.DCB_device_flags&=~DCB_DEV_REMOVABLE;  //support removable as fixed...
		// ldcb->DCB_cmn.DCB_Partition_Start=cv->cryptsectorfirst;
		 ldcb->DCB_cmn.DCB_device_type=MYDEVICE;
		 ldcb->DCB_cmn.DCB_user_drvlet=(USHORT)md;
         ldcb->DCB_cmn.DCB_partition_type=0;
		 ldcb->DCB_cmn.DCB_Sstor_Host=0;    
		 ldcb->DCB_actual_sector_cnt[0]=0;  
		 ldcb->DCB_actual_sector_cnt[0]++;
		 ldcb->DCB_actual_sector_cnt[1]=0;
		 ldcb->DCB_actual_blk_size=512; 
         ldcb->DCB_actual_head_cnt=1;       // number of heads
         ldcb->DCB_actual_cyl_cnt=1;        // number of cylinders
		 ldcb->DCB_cmn.DCB_apparent_blk_shift=9; 
		 ldcb->DCB_actual_spt=ldcb->DCB_actual_sector_cnt[0];	
		 ldcb->DCB_bdd.DCB_apparent_sector_cnt[0]=ldcb->DCB_actual_sector_cnt[0];
		 ldcb->DCB_bdd.DCB_apparent_sector_cnt[1]=0;
		 ldcb->DCB_bdd.DCB_apparent_head_cnt=1;
		 ldcb->DCB_bdd.DCB_apparent_blk_size=512;
		 ldcb->DCB_bdd.DCB_apparent_cyl_cnt=1;
		 ldcb->DCB_bdd.DCB_apparent_spt=ldcb->DCB_actual_sector_cnt[0];


	 #if R0FILES
		 }
      #endif
		 ldcb->DCB_cmn.DCB_drive_lttr_equiv=0;
		 ldcb->DCB_cmn.DCB_user_drvlet=0;
		 ldcb->DCB_cmn.DCB_device_type=MYDEVICE;
  	 
		 if (prefdrive!=-1)
		     md=IspDriveLetterPickPref(ldcb,(UCHAR) ISP_PDL_FL_USE_RANGE,(UCHAR) prefdrive);
	         else md=(unsigned char)255;


			if (md==255)
				 md=IspDriveLetterPick(ldcb, 0);
			ldcb->DCB_cmn.DCB_unit_number=(USHORT)md;
			ldcb->DCB_cmn.DCB_vrp_ptr=0;   //   clear the copied VRP pointer......
			ldcb->DCB_cmn.DCB_device_flags|=DCB_DEV_WRITEABLE;


	                if (!(flags&DCB_DEV_WRITEABLE))
					   ldcb->DCB_cmn.DCB_device_flags&=~DCB_DEV_WRITEABLE;

					if (initialiseWPerror)
						{
						 initialiseWPerror=0;
						 ldcb->DCB_cmn.DCB_device_flags&=~DCB_DEV_WRITEABLE;
						}

		    ldcb->DCB_cmn.DCB_drive_lttr_equiv=md;
			ldcb->DCB_cmn.DCB_user_drvlet=(USHORT)md;
			ldcb->DCB_cmn.DCB_unit_number=0; 

			cv->drive=(ULONG)md;
			ldcb->DCB_cmn.DCB_TSD_Flags=DCB_TSD_APPARENT_PRE_SET|DCB_TSD_MBPB_PBR 	;
			ldcb->DCB_cmn.DCB_partition_type=0; 
			ldcb->DCB_cmn.DCB_device_flags&=~DCB_DEV_TSD_PROCESSED;
			ldcb->DCB_cmn.DCB_Partition_Start=0;
			ldcb->DCB_cmn.DCB_device_flags|=DCB_DEV_LOGICAL|DCB_DEV_MEDIA_CHANGED|DCB_DEV_UNCERTAIN_MEDIA;	 
		 	IspAssociateDcb(ldcb, md,0); //ISP_D_A_FL_NOSHELLMSG );
			//NotifyVolumeArrival(md);

			if (!extcritical) cv->SKFCreateTime=5*120;	// five minutes
				
			

}// Mount a drive end.....


 
 /*
typedef struct executestruct

{
int shex_dwTotalSize;
int shex_dwSize;
int shex_ibOp;
int shex_ibFile;
int shex_ibParams;
int shex_ibDir;
int shex_ibEnv;
int shex_nCmdShow;
}executestruct;

*/

void exec (char * fname,char *wdir)
{
 executestruct * exs=(executestruct *) &exstruct;
 exs->shex_dwSize=32;
 exs->shex_dwTotalSize=32+256; //1+strlen(fname);
 exs->shex_ibFile=32; //offset 
 exs->shex_ibDir=32+128;
 exs->shex_nCmdShow=1; //==SW_SHOW; 
 exs->shex_ibEnv=0; 
 exs->shex_ibParams=0;
 exs->shex_ibOp=0;
 strcpy((char *)&exs->fname,fname);
 strcpy((char *)&exs->wdir,wdir);
 execflag=SHELLexec((int) &exstruct);
}


#pragma VxD_LOCKED_CODE_SEG



#define IOR_event _ureq._IOR_requestor_usage[0]
#define IOR_id _ureq._IOR_requestor_usage[1]
#pragma VxD_LOCKED_CODE_SEG

#define MAXBLOCK 128 //64k  was 256....



#include "diskcom.c"

#pragma VxD_LOCKED_DATA_SEG
char fileerrorstr[]=
{
"Scramdisk has encountered an error reading a host file which\n"
"it is using for a currently open scrambled disk volume.\n\n"
"You should immediately dismount the file using the Scramdisk\n"
"application, correct the error, and re mount the disk image file.\n\n\n"
"The related disk will be unavailable, until you do, and you should\n"
"save your work elsewhere."
};

#pragma VxD_LOCKED_CODE_SEG
int dophysblock(PIOP iop,int sector,int numsectors,char *buffr,cryptvol *cv,USHORT iorop)

{

int rstatus=0;  //status return value.... 
PIOP myiop;
PIOR myior; 

_BlockDev_Scatter_Gather* sgd;

PDCB mydcb= cv->physdevDCB; //(PDCB) iop->IOP_physical_dcb;
USHORT offset;
USHORT size; 

//IOP i;


 #if R0FILES
 if (cv->mountfilehandle)
   {
  
	 if (cv->booted<=2)
	 rstatus= doR0fileio(sector,numsectors,buffr,cv,iorop); 
	
	 else rstatus=23;

	if ((rstatus)&&(rstatus!=0x13) ) 
		{	 
		 iop->IOP_timer=iop->IOP_timer_orig=32000; 
		 rstatus=MapDosError(rstatus);
		 
		 if (cv->booted<=2 && (cv->booted))
			{
			 ShellMessageNCB(0,fileerrorstr,"Scramdisk: Mounted file error");
			 cv->booted=256;
			}
		}
	 iop->IOP_ior.IOR_status=rstatus;
	 return rstatus;
   }//mountfilehandle

   #endif  
 // End up here, if we are handling a disk partition rather than container file
   offset = (USHORT) (mydcb->DCB_cmn.DCB_expansion_length+FIELDOFFSET(IOP,IOP_ior));
   size= offset+sizeof(IOR)+(8*sizeof(SGD)); 
   iop->IOP_timer=iop->IOP_timer_orig=160;
   
   myiop=IspCreateIop(size,offset,ISP_M_FL_MUST_SUCCEED|ISP_M_FL_SMART_ALLOC|ISP_M_FL_INTERRUPT_TIME|ISP_M_FL_PERSISTENT_IOP ); 

   if (myiop==NULL)
   {
 
	   iop->IOP_ior.IOR_status=IORS_MEMORY_ERROR;	
       return IORS_MEMORY_ERROR;
   }

   myior=&myiop->IOP_ior;
   
   //  Be aware that Criteria routine reads it's dmd bits from THIS dcb!

   myiop->IOP_original_dcb=(ULONG) mydcb; //iop->IOP_original_dcb; //(ULONG) mydcb;	
   myiop->IOP_physical_dcb= (ULONG) mydcb->DCB_cmn.DCB_physical_dcb;
   if (cv->booted==1) cv->booted=2;  //Irrelevant here.....   
   myior->IOR_next=0;
   myior->IOR_start_addr[1]=0;
   myior->IOR_flags=IORF_VERSION_002;
   myior->IOR_private_client=offset;
   myior->IOR_req_vol_handle=mydcb->DCB_cmn.DCB_vrp_ptr;
   myior->IOR_sgd_lin_phys=(ULONG) (myior+1);
   myior->IOR_num_sgds=0;
   myior->IOR_vol_designtr=mydcb->DCB_cmn.DCB_unit_number;
   myior->IOR_func=iorop;
   myior->IOR_flags|=IORF_BYPASS_VOLTRK|IORF_HIGH_PRIORITY|IORF_SCATTER_GATHER|IORF_SYNC_COMMAND|IORF_DONT_CACHE;
   if (iorop==IOR_READ) myior->IOR_flags|=IORF_DATA_IN;
   if (iorop==IOR_WRITE) myior->IOR_flags|=IORF_DATA_OUT;
   myior->IOR_start_addr[0]=sector;
   myior->IOR_xfer_count=numsectors;
   sgd=(_BlockDev_Scatter_Gather *) myior->IOR_sgd_lin_phys; //scatter gather array...
   sgd->BD_SG_Buffer_Ptr=(ULONG) buffr;  //Buffer in LOCKED ram, below 16mbyte, 4K boundary..
   sgd->BD_SG_Count=numsectors;
   myior->IOR_buffer_ptr=(ULONG) sgd;  //Implement as Scatter gather, with One block
   sgd++;
   sgd->BD_SG_Buffer_Ptr=NULL;
   sgd->BD_SG_Count=0;
   sgd++;
   myior->IOR_sgd_lin_phys=(ULONG) sgd;
   rstatus=myior->IOR_status;
   sgd->BD_SG_Buffer_Ptr=NULL;
   sgd->BD_SG_Count=0;
   sgd++;
   sgd->BD_SG_Buffer_Ptr=NULL;
   sgd->BD_SG_Count=0;
   sgd++;
   sgd->BD_SG_Buffer_Ptr=NULL;
   sgd->BD_SG_Count=0;
   myiop->IOP_timer=40;
   myiop->IOP_timer_orig=40;
   //Call criteria, to set phys SGDs physical addresses if needed.....
   if (IlbIntIoCriteria(myiop) ) 
	       myior->IOR_flags|=IORF_DOUBLE_BUFFER; //Double buffer, will also make no difference
   IlbInternalRequest(myiop,mydcb,OnRequest);
   rstatus=myior->IOR_status;
   iop->IOP_ior.IOR_status=rstatus;  //myior->IOR_status;
   IspDeallocMem((PVOID) ((DWORD) myior-myior->IOR_private_client));
   physflag=0;  //Recursion/re-entrancy flag testing only....
   return rstatus;
  }


#pragma VxD_LOCKED_CODE_SEG


void inblock (PIOP iop,char *outbuffer,int sectorstart,int sectorcount,cryptvol* cv,unsigned int buffernum)
{   
int logsec=(sectorstart+4) ;//-cv->cryptsectorfirst)+4;	//get logical volume sector.
 
	do
	{
	ior.IOR_status=0;
	if (sectorcount<MAXBLOCK)
	  {
	  readlogical(iop,logsec,sectorcount,(char *) transferbuffer,cv);
	  memcpy (outbuffer,transferbuffer,sectorcount*512); 
	  sectorcount=0;
	  return;     //break.....
	  }
	
	  else
	  
	  {
	   readlogical(iop,logsec,MAXBLOCK,(char*) transferbuffer,cv);
	   memcpy(outbuffer,transferbuffer,MAXBLOCK*512);
	   logsec+=MAXBLOCK;	
	   sectorcount-=MAXBLOCK;
	   outbuffer+=(MAXBLOCK*512);
	  }
	}	
   while ((sectorcount>0)&&(ior.IOR_status<16));
}




#pragma VxD_LOCKED_CODE_SEG

//*******
void cryptproc(PIOP iop,cryptvol * cv)
//***********

{
PDCB dcbx;
unsigned int buffernum,totalsectors;
unsigned int sectorstart,sectorcount;
char * outbuffer,*bufadr,*buffercopy; 
_BlockDev_Scatter_Gather* sgd;
  
  dcbx	= (PDCB) iop->IOP_physical_dcb;
  ior.IOR_status=0;
  if (ior.IOR_func==IOR_WRITEV)
  {
	ior.IOR_status=IORS_INVALID_COMMAND;
	return;

  }

  sectorcount=ior.IOR_xfer_count;

  if (!sectorcount)

  {
    ior.IOR_status=0;
	return;
  }



 if ((ior.IOR_func==IOR_READ)||(ior.IOR_func==IOR_WRITE))
    
	{	 
 
 
	   if (iop->IOP_ior.IOR_flags&IORF_CHAR_COMMAND)
          {
			ior.IOR_status=IORS_INVALID_COMMAND;
			return;  //Char command NOT supported or needed....
          }

	} //dummy


   else
      {
	  ior.IOR_status=0;
	#if R0FILES
	  if (!cv->mountfilehandle)
	#endif

	  DoCallDown(iop);
	  return;
      }


  if (ior.IOR_func==IOR_READ)
    {

   	sectorstart=ior.IOR_start_addr[0];  
	sectorcount=ior.IOR_xfer_count;
	outbuffer= (char *) ior.IOR_buffer_ptr;		//may be scatter gather pointer...;
    if (ior.IOR_flags&IORF_SCATTER_GATHER)
	  {
      sgd=(_BlockDev_Scatter_Gather*) outbuffer;
	   while ((sectorcount=sgd->BD_SG_Count))
		 {
		 outbuffer=(char *) sgd->BD_SG_Buffer_Ptr;
		 inblock(iop,outbuffer,sectorstart,sectorcount,cv,buffernum);

		 	if (sectorstart==0)

			  {
			     (unsigned char) outbuffer[0]=0xeb;
			     outbuffer[1]=0x3e;
			    (unsigned char)outbuffer[2]=0x90;
			 
				outbuffer[510]=0x55;   // boot sector bodge......
				(unsigned char)	outbuffer[511]=0xAA;
			  }
					
					
		 sectorstart+=sectorcount;
		 ++sgd;
		 }
      }

	else  //linear buffer
    
	   {
	    inblock(iop,outbuffer,sectorstart,sectorcount,cv,buffernum);
    
		  // The following code LIES to win98, who won't otherwise
		  // mount disks created by earlier versions, because the boot
		  // sector had stuff missing.  (fixed now...)
	     if (sectorstart==0) //&& (sectorcount==1) )
	        {
	       	 
			 (unsigned char) outbuffer[0]=0xeb;
			  outbuffer[1]=0x3e;
			 (unsigned char)	outbuffer[2]=0x90;			 
			 outbuffer[510]=0x55;
	         (unsigned char)	outbuffer[511]=0xAA;
	       }

	   }
   
  }  // read op


  else
  if (ior.IOR_func==IOR_WRITE)
 
	{

	   if (cv->booted==0)
        {
	     ior.IOR_status=0;
		return;
	    } 
          
	
	buffernum=bufferstack&15; 
    bufadr=transferbuffer; 
    bufadr+=(buffernum*(MAXBLOCK*512));
	sectorstart=ior.IOR_start_addr[0];
	sectorcount=ior.IOR_xfer_count;
	outbuffer= (char *) ior.IOR_buffer_ptr;		//may be scatter gather pointer...;
	totalsectors=0;
    buffercopy=bufadr;

    
	if (ior.IOR_flags&IORF_SCATTER_GATHER)
	  {     
	  sgd=(_BlockDev_Scatter_Gather*) outbuffer;
	  while ((sectorcount=sgd->BD_SG_Count))
	   {		
	   outbuffer=(char *) sgd->BD_SG_Buffer_Ptr;
	   if ((totalsectors+sectorcount)<=MAXBLOCK)
		   {  
		   sectorcopy(buffercopy,outbuffer,sectorcount);
		   totalsectors+=sectorcount;
		   buffercopy+=sectorcount*512;
		   }
        else  //write any previous buffer.....
		   {
		   if (totalsectors)	//was it too big to start with ?
			   { 
			   outblock(iop,bufadr,sectorstart,totalsectors,cv,NULL);
			   buffernum=bufferstack&7; 
               bufadr=transferbuffer; 
               bufadr+=(buffernum*(MAXBLOCK*512));
			   sectorstart+=totalsectors;
			   totalsectors=0;
			   buffercopy=bufadr;
			   --sgd;           // back to previous for next pass.....
		       }
		   else
			   {   //initial buffer was too big, to start with!
			   outblock(iop,outbuffer,sectorstart,sectorcount,cv,bufadr);
               buffernum=bufferstack&7; //  two buffers of 1 meg switched on write physical call...
               bufadr=transferbuffer; 
               bufadr+=(buffernum*(MAXBLOCK*512));
			   sectorstart+=sectorcount;
			   buffercopy=bufadr;
		       }
           
           }
	    ++sgd;  	
	   }   //end while 

	 
	  if (totalsectors) outblock(iop,bufadr,sectorstart,totalsectors,cv,NULL); //last one ?
      
    }     //end if scatter gather

	else  // not scatter gather but is linear buffer
    {
	if (sectorstart==cv->cryptsectorfirst)
			{
   			 bpb * b;
			 char * z=outbuffer+11;
			 b=(bpb *) z;
			 copyvolname(b,cv);
			 newvolume=TRUE;
			}

		outblock(iop,outbuffer,sectorstart,sectorcount,cv,bufadr); //get it to copy and do large bit...
	}


 }  // end write op



}


#pragma VxD_LOCKED_CODE_SEG

VOID cryptprocqueue(int readq) //OP iop, cryptvol* cv)
{	
 PIOP iop;
 cryptvol* cv;	
 unsigned int sector;
 //VOID (*mrd) (PIOP iop)=&MyReqDone;
		  do
		  {
		  iop=qdata[readq].qiop;
		  qdata[readq].qiop=NULL;
          (ULONG) cv=qdata[readq].cvaddr;
          iop->IOP_ior.IOR_next=0;
		  sector=iop->IOP_ior.IOR_start_addr[0];	
          cv->driveinuse=1;

		
     	  if ( (ior.IOR_func==IOR_READ)||(ior.IOR_func==IOR_WRITE) ||(ior.IOR_func==IOR_WRITEV)  && (sector!=0))
  
		      { 
				cryptproc(iop,cv);      	
				DoCallBack(iop);
		      }

		      else 
		   
		      {
		        DoCallDown(iop);
			  }

		 readq++;
		 readq&=511;
		 _asm cli
		 cv->driveinuse=0;
		 }
		 
		 while (qdata[readq].qiop!=NULL);
		 globaltimeoutnow=globaltimeoutval;  //reset global timeout, as drive has been used.
	
		 if (globaltimeoutval<0x8000000)
				 if (brutaltimeout==2) brutaltimeout--;
		 
		 qflag=0;       
		 

}



void __declspec(naked) callqueueproc(void)
{
_asm pushfd
_asm pushad

//;;gf_asm cli      ;Should leave IRQs on...

_asm push ebp
_asm mov ebp,esp
_asm push edx
_asm call cryptprocqueue
_asm add esp,4
_asm pop ebp
_asm popad
_asm popfd
_asm cld
_asm sti
_asm ret

}

#pragma VxD_LOCKED_CODE_SEG
VOID cryptprocL(PIOP iop, cryptvol* cv)

{

 void (*me)(void)=&callqueueproc;
 unsigned int q;
 PDCB ldcb=(PDCB)iop->IOP_physical_dcb;

		ior.IOR_status=IORS_CMD_IN_PROGRESS; 
		qdata[qnum].qiop=iop;
		qdata[qnum].cvaddr=(ULONG)cv;
        q=qnum;
		qnum++;
		qnum&=511;

		if (qflag==0) 
		  {
			qflag=1;
			Schedule_Global_Event(me,(ULONG) q);
		  }

}




#pragma VxD_LOCKED_CODE_SEG

VOID OnRequest(PIOP iop)
	{							// OnRequest
	DoCallDown(iop);   // do normal unencryped disk stuff...
	}



void finddevice(cryptvol *cv, char * f)

{
if (cv->cryptsectorlast) 
{
	f[0]=(char)cv->drive+'A';
	if (cv->booted)
    f[1]='O';
	else
	f[1]='C';

}

 else
	 {
	 f[0]='?';
	 f[1]='?';
	 }
}





#pragma VxD_LOCKED_CODE_SEG



// DoCallDown passes a request to the next lower layer. Note that the
// documentation about how to do this is totally wrong: you don't just
// add sizeof(DCB_cd_entry) to the calldown pointer, you follow a
// linked list from one calldown entry to the next.
#pragma VxD_LOCKED_CODE_SEG
void  DoCallDown(PIOP iop)
	{							// DoCallDown
	_asm
		{						// call down to next layer
        pushfd
		pushad
		mov	ecx, [iop]
		mov	eax, [ecx]IOP.IOP_calldown_ptr
		mov eax, [eax]DCB_cd_entry.DCB_cd_next
		mov [ecx]IOP.IOP_calldown_ptr, eax
        push ecx
		call [eax]DCB_cd_entry.DCB_cd_io_address
		add esp,4
		popad
		popfd
	    }						// call down to next layer
	}							// DoCallDown

// DoCallBack handles completion of an I/O request by calling the
// previous level's callback routine.
#pragma VxD_LOCKED_CODE_SEG
void  DoCallBack(PIOP iop)
	{							// DoCallBack
	_asm
		{						// call back to previous layer
		pushfd
		pushad
		mov ecx, [iop]
		sub [ecx]IOP.IOP_callback_ptr, size IOP_callback_entry
		mov eax, [ecx]IOP.IOP_callback_ptr
		push ecx
		call [eax]IOP_callback_entry.IOP_CB_address
		add esp,4
		popad
		popfd

		}						// call back to previous layer
	}							// DoCallBack

// InsertCallBack adds an entry to the callback list
#pragma VxD_LOCKED_CODE_SEG
void InsertCallBack(PIOP iop, VOID (*callback)(PIOP), ULONG refdata)
	{							// InsertCallBack
	IOP_callback_entry* cbp = (IOP_callback_entry*) iop->IOP_callback_ptr;
	cbp->IOP_CB_address = (ULONG) callback;
	cbp->IOP_CB_ref_data = refdata;
	iop->IOP_callback_ptr += sizeof(IOP_callback_entry);
	}							// InsertCallBack


#pragma VxD_LOCKED_CODE_SEG
int closeCrDevice(cryptvol *cv,int mode)

{	int c;	

	if (mode==0) // pre flush volume call.....
	{
	if (cv->drive)
	
	     {
		    if (cv->booted<=2)
		    {
		     _VolFlush(cv->drive,0);  //flush stuff out before the dismount...
		  
		     NotifyVolumeRemoval(cv->drive); //?? ??
		    }
		 return 0;
	     }

	     else return 1;

	}

	else
	{
	  for (c=0;c<QDATASIZE;c++)
	    {
		if (qdata[c].qiop!=NULL)
		      if ( (cryptvol *) qdata[c].cvaddr==cv) 
			       return 0x42424242;
	    }

	if (Kill_Drive(cv)==TRUE)	return 0;

	else return 0x42424242;

	}
}


#define WM_DESTROY 2
#define WM_USER 1024

void posttimeout(void) //appy time routine
{
	SEASHELL_PostMessage((HANDLE) appwindowhandle, WM_USER, 24321, (DWORD) brutaltimeout, NULL, 0);
}



void posttoapptimeoutmsg(void)
{
	SHELL_CallAtAppyTime((APPY_CALLBACK)&posttimeout,0,0);
}



// called when brutal closure 
void postquit(void) //appy time routine
{
	SEASHELL_PostMessage((HANDLE) appwindowhandle, WM_DESTROY, 0, 0, NULL, 0);
}


void posttoappquitmsg(void)
{
	SHELL_CallAtAppyTime((APPY_CALLBACK)&postquit,0,0);
}

void postclicked(void) //appy time routine
{
	SEASHELL_PostMessage((HANDLE) appwindowhandle, WM_USER, 8080, (DWORD) &myclickedname, NULL, 0);
}

void PostClickedName(void)
{
SHELL_CallAtAppyTime((APPY_CALLBACK)&postclicked,0,0);
}


void AppPostQuit(void) //appy time routine
{
	SEASHELL_PostMessage((HANDLE) appwindowhandle, WM_USER, 8086, (DWORD) &myclickedname, NULL, 0);
}

void AppPostQuitCommand(void) // An application has requested scramdisk Quits.
{
SHELL_CallAtAppyTime((APPY_CALLBACK)&AppPostQuit,0,0);
}



void AppPostRefresh(void) //appy time routine
{
	SEASHELL_PostMessage((HANDLE) appwindowhandle, WM_USER, 8087, (DWORD) &myclickedname, NULL, 0);
}

void AppPostRefreshCommand(void) // An application has requested scramdisk refreshes.
{
SHELL_CallAtAppyTime((APPY_CALLBACK)&AppPostRefresh,0,0);
}

#include "ifshook.c" // Win98 kludge
#include "ToCiphers.c" // has change password (driver end) code in......
#include "outblock.c"
