(define (handle-list:results)
  (let* ((handle (ui:form-datum "handle"))
	 (cs (ui:form-datum "cs"))
	 (results (identity:reverse-lookup 
		   handle
		   (not cs))))
    (list
     (cond ((null? results)
	    (list
	     "No results were found. I may have never met the Yenta you asked
about, or you may have the handle wrong. You should either try contacting
the host this Yenta runs on (if you know it) or try a different handle."))
	   ((null? (cdr results))
	    (list
	     "A "
	     (identity:href (car results))
	     "single Yenta</a> was found."))
	   (else
	    (list
	     "Multiple Yentas were found:"
	     (ui:pretty-html-list
	      (map identity:description-link
		   results)))))
     "<form method = \"get\" action = \"handle-list.html\">
<input type = \"text\" name = \"handle\" value = \""
     handle
     "\"><input type = \"checkbox\" name = \"cs\" "
     (ui:on-off cs)
     "> Case Sensitive <input type = \"submit\" value = \"Retry\">")))