(yreq "Utilities/yenta-utils")

(def-yenta-var *yenta-accept* '())
(def-yenta-var *yenta-block* '())
(def-yenta-var *yenta-reject* '())

(define (message message)
  (cons (list-ref message 5)
	(list-ref message 6)))

(define (id message)
  (list-ref message 3))

;;; Checks to see if the regexp has been specified.
(define (af:regexp! regexp)
  (cond ((string=? regexp "")
	 "")
	((not (member regexp *yenta-accept*))
	 (let ((result (set! *yenta-accept* (cons regexp *yenta-accept*))))
	   (if (eq? result (if #f 'foo)) ; %%% What the hell?  This just returns the same thing all the time...  Was this debuggery?
	       ""
	       "")))			; %%% This one should probably be "result".
	(else "<h1>This regular expression already exists.</h1>")))

;;; Checks to see if the user has ever been blocked.
(define (af:block! y-id)
  (if (member y-id *yenta-block*)
      (let ((result (set! *yenta-block* (cons y-id *yenta-block*))))
	(if (eq? result (if #f 'foo))	; %%% ditto here!
	    ""
	    ""))				; %%% This one should probably be "result".
      "<h1>This Yenta is already blocked.</h1>"))

;;; add and block lists
;;;  if local id is on block list, ignore messages...
;;;  accept all messages from id's on add list,

;;; Block List Filter
(define (af:block-filter attestation)
  (letrec 
      ((block? (lambda (blck-lst)
		 (cond ((null? blck-lst)
			#f)
		       ((assoc (car blck-lst) (id attestation))
			#t)
		       (else (block? (cdr blck-lst)))))))
    (block? *yenta-block*)))

;;; End of file.
