;; -*- Scheme -*-
;;
;; $Id: stringt11.scm,v 1.1 1998/03/16 08:00:07 foner Exp $

(require 'string:test:equal)
(require 'string:split-by-string-ignoring-ends)
(require 'string:find-by-substring)
(require 'string:find-by-knuth-morris-pratt)

;;------------

(define string:test:split-by-string-ignoring-ends
  (lambda args

    (if (not (null? args))
	(display "Testing string:split-by-string-ignoring-ends ... "))

    (string:test:equal
     'string:test:split-by-string-ignoring-ends-knp-a
     ((string:split-by-string-ignoring-ends
       substring:find-by-knuth-morris-pratt
       "foo")
      "abcfoodeffooghi")
     '("abc" "def" "ghi"))

    (string:test:equal
     'string:test:split-by-string-ignoring-ends-kmp-b
     ((string:split-by-string-ignoring-ends
       substring:find-by-knuth-morris-pratt
       "foo")
      "foodeffooghi")
     '("def" "ghi"))

    (string:test:equal
     'string:test:split-by-string-ignoring-ends-kmp-c
     ((string:split-by-string-ignoring-ends
       substring:find-by-knuth-morris-pratt
      "ff")
      "abcfffdefffghi")
     '("abc" "fde" "fghi"))

    (string:test:equal
     'string:test:split-by-string-ignoring-ends-kmp-d
     ((string:split-by-string-ignoring-ends
       substring:find-by-knuth-morris-pratt
       "ff")
      "abcfffdeffffghi")
     '("abc" "fde" "" "ghi"))

    (string:test:equal
     'string:test:split-by-string-ignoring-ends-kmp-d
     ((string:split-by-string-ignoring-ends
       substring:find-by-knuth-morris-pratt
       "ff")
      "")
     '())

    (string:test:equal
     'string:test:split-by-string-ignoring-ends-kmp-e
     ((string:split-by-string-ignoring-ends
       substring:find-by-knuth-morris-pratt
       "")
      "abcfffdeffffghi")
     '("a" "b" "c" "f" "f" "f" "d" "e" "f" "f" "f" "f" "g" "h" "i"))


;    (string:test:equal
;     'string:test:split-by-string-ignoring-ends-s-a
;     ((string:split-by-string-ignoring-ends
;       string:find-by-sunday
;       "foo")
;      "abcfoodeffooghi")
;     '("abc" "def" "ghi"))
;
;    (string:test:equal
;     'string:test:split-by-string-ignoring-ends-s-b
;     ((string:split-by-string-ignoring-ends
;       string:find-by-sunday
;       "foo")
;      "foodeffooghi")
;     '("def" "ghi"))
;
;    (string:test:equal
;     'string:test:split-by-string-ignoring-ends-s-c
;     ((string:split-by-string-ignoring-ends
;       string:find-by-sunday
;      "ff")
;      "abcfffdefffghi")
;     '("abc" "fde" "fghi"))
;
;    (string:test:equal
;     'string:test:split-by-string-ignoring-ends-s-d
;     ((string:split-by-string-ignoring-ends
;       string:find-by-sunday
;       "ff")
;      "abcfffdeffffghi")
;     '("abc" "fde" "" "ghi"))
;
;    (string:test:equal
;     'string:test:split-by-string-ignoring-ends-s-d
;     ((string:split-by-string-ignoring-ends
;       string:find-by-sunday
;       "ff")
;      "")
;     '())
;
;    (string:test:equal
;     'string:test:split-by-string-ignoring-ends-s-e
;     ((string:split-by-string-ignoring-ends
;       string:find-by-sunday
;       "")
;      "abcfffdeffffghi")
;     '("a" "b" "c" "f" "f" "f" "d" "e" "f" "f" "f" "f" "g" "h" "i"))

    (string:test:equal
     'string:test:split-by-string-ignoring-ends-ss-a
     ((string:split-by-string-ignoring-ends
       substring:find-by-substring
       "foo")
      "abcfoodeffooghi")
     '("abc" "def" "ghi"))

    (string:test:equal
     'string:test:split-by-string-ignoring-ends-ss-b
     ((string:split-by-string-ignoring-ends
       substring:find-by-substring
       "foo")
      "foodeffooghi")
     '("def" "ghi"))

    (string:test:equal
     'string:test:split-by-string-ignoring-ends-ss-c
     ((string:split-by-string-ignoring-ends
       substring:find-by-substring
      "ff")
      "abcfffdefffghi")
     '("abc" "fde" "fghi"))

    (string:test:equal
     'string:test:split-by-string-ignoring-ends-ss-d
     ((string:split-by-string-ignoring-ends
       substring:find-by-substring
       "ff")
      "abcfffdeffffghi")
     '("abc" "fde" "" "ghi"))

    (string:test:equal
     'string:test:split-by-string-ignoring-ends-ss-d
     ((string:split-by-string-ignoring-ends
       substring:find-by-substring
       "ff")
      "")
     '())

    (string:test:equal
     'string:test:split-by-string-ignoring-ends-ss-e
     ((string:split-by-string-ignoring-ends
       substring:find-by-substring
       "")
      "abcfffdeffffghi")
     '("a" "b" "c" "f" "f" "f" "d" "e" "f" "f" "f" "f" "g" "h" "i"))

    (if (not (null? args)) (begin (display "done") (newline)))
  ))

;; eof
