; -*- Scheme -*-
;
; $Id: string44.scm,v 1.1 1998/03/16 07:59:55 foner Exp $

; procedure: substring::unsafe-copy-right!
; arguments: from-string from-start from-end to-string to-start
; signature: string x integer x integer x string x integer -> unspecified
; pre:       (and (<= 0 from-start from-end (string-length from-string))
;                 (<= 0 to-start (- (string-length to-string)
;                                   (- from-end from-start))))
;
; Copies (- FROM-END FROM-START) characters from FROM-STRING to
; TO-STRING placing them in TO-STRING starting at position TO-START.
; The copying is done in order from FROM-START to FROM-END.

(define substring::unsafe-copy-right!
  (lambda (f fs fe t ts)
    (let loop ((i fs) (j ts))
      (if (= i fe)
	  #t				; arbitrary value
	  (begin
	    (string-set! t j (string-ref f i))
	    (loop (+ i 1) (+ j 1)))))))

;------------

; procedure: substring::safe-copy-right!
; arguments: from-string from-start from-end to-string to-start
; signature: string x integer x integer x string x integer -> unspecified
;
; Copies (- FROM-END FROM-START) characters from FROM-STRING to
; TO-STRING placing them in TO-STRING starting at position TO-START.
; The copying is done in order from FROM-START to FROM-END.

(define substring::safe-copy-right!
  (lambda (f fs fe t ts)
    (if (<= 0 fs fe (string-length f))
	(if (<= 0 ts (+ ts (- fe fs)) (string-length t))
	    (substring::unsafe-copy-right! f fs fe t ts)
	    (substring:error:bounds t ts (+ ts (- fe fs))))
	(substring:error:bounds f fs fe))))

;------------

;+doc
; procedure: substring:copy-right!
; arguments: from-string from-start from-end to-string to-start
; signature: string x integer x integer x string x integer -> unspecified
;
; Copies (- FROM-END FROM-START) characters from FROM-STRING to
; TO-STRING placing them in TO-STRING starting at position TO-START.
; The copying is done in order from FROM-START to FROM-END.
;
; This is possibly equivalent to the R2RS procedure SUBSTRING-MOVE-RIGHT!
; The reason for the name difference is that the SUBSTRING:COPY-RIGHT!
; _copies_ characters i.e. it guarantees that the characters will
; still be in FROM-STRING.  If SUBSTRING-MOVE-RIGHT! also has this
; guarantee, then having MOVE in the name was misleading.
;-doc

(define substring:copy-right! substring::safe-copy-right!)

; eof
