; -*- Scheme -*-
;
; $Id: string25.scm,v 1.1 1998/03/16 07:59:45 foner Exp $

(require 'substring:replicate!)

;+doc
; procedure: substring:replicate:n
; arguments: string start end n
; signature: string x int x int x int -> string
; pre: (and (<= 0 start end (string-length string)) (<= 0 n))
;
; Returns a new string which contains N copies of the characters in
; STRING between START (inclusive) and END (exclusive)
;
; > (substring:replicate:n "abc" 0 2 2)
; "abab"
;
; > (substring:replicate:n "abc" 0 0 0)
; ""
;
; > (substring:replicate:n "" 0 0 2)
; ""
;-doc

(define substring:replicate:n
  (lambda (string start end n)
    (let* ((ns (* (- end start) n))
	   (rs (make-string ns)))
      (substring:replicate! rs 0 ns string start end)
      rs)))

;------------

;+doc
; procedure: string:replicate:n
; arguments: string n
; signature: string x int -> string
; pre: (<= 0 n)
;
; Returns a new string which contains N copies of the characters in
; STRING.
;
; > (string:replicate:n "abc" 2)
; "abcabc"
;
; > (string:replicate:n "abc" 0)
; ""
;
; > (string:replicate:n "" 2)
; ""
;-doc

(define string:replicate:n
  (lambda (string n)
    (substring:replicate:n string 0 (string-length string) n)))

; eof
