; -*- Scheme -*-
;
; $Id: char-set-19.scm,v 1.1 1998/03/16 07:57:54 foner Exp $

;+doc
; procedure: char-set:difference!
; arguments: a b
; signature: char-set x char-set -> unspecified
;
; Modifies A such that it contains the difference between A and B.
;
; > (let ((a (string->char-set "abcd"))
; >       (b (string->char-set "bc")))
; >   (char-set:difference! a b)
; >   (list (char-set->to-string a) (char-set->to-string b)))
; ("ad" "bc")
;-doc

(define char-set:difference!
  (lambda (a b)
    (let loop ((i (- char-set::vector-size 1)))
      (if (not (zero? i))
	  (begin
	    (if (and (char-set::at b i) (char-set::at a i))
		(begin (vector-set! a i #f) (char-set::1-size! a)))
	    (loop (- i 1)))))))

; eof
