/*
Copyright (c) 1990, 1991, 1992, 1993, 1994, 1995, 1996 by the
Massachusetts Institute of Technology.

"Export of software employing encryption from the United States of
America may require a specific license from the United States
Government.  It is the responsibility of any person or organization
contemplating export to obtain such a license before exporting."

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and distribute
this software and its documentation for any purpose and without fee is
hereby granted, provided that the above copyright notice appear in all
copies and that both that copyright notice and this permission notice
appear in supporting documentation, and that the name of M.I.T. not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  M.I.T. makes no
representations about the suitability of this software for any purpose.
It is provided ``as is'' without express or implied warranty.
*/

#ifndef _SHS_DEFINED
#define _SHS_DEFINED

#include "krypto_locl.h"

/* Some useful types */

typedef unsigned char BYTE;
typedef uint32 LONG;

/* Exit status of functions. */

#define OK      0
#define ERROR   -1

/* Define the following to use the updated SHS implementation */

#define NEW_SHS         /**/

/* The SHS block size and message digest sizes, in bytes */

#define SHS_DATASIZE    64
#define SHS_DIGESTSIZE  20

/* The structure for storing SHS info */

typedef struct {
               LONG digest[ 5 ];            /* Message digest */
               LONG countLo, countHi;       /* 64-bit bit count */
               LONG data[ 16 ];             /* SHS data buffer */
               } SHS_INFO;

/* Message digest functions (shs.c) */
/*
void shsInit ();
void shsUpdate ();
void shsFinal ();
*/


#define NIST_SHA_CKSUM_LENGTH		SHS_DIGESTSIZE


#endif /* _SHS_DEFINED */
