# SKIP Source Code License Statement:
# ------------------------------------------------------------------
#   Copyright
#   Sun Microsystems, Inc.
# 
# 
#   Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
#   Reserved.
# 
#   Permission is hereby granted, free of charge, to any person
#   obtaining a copy of this software and associated documentation
#   files (the "Software"), to deal in the Software without
#   restriction, including without limitation the rights to use,
#   copy, modify, merge, publish, distribute, sublicense, and/or sell
#   copies of the Software or derivatives of the Software, and to 
#   permit persons to whom the Software or its derivatives is furnished 
#   to do so, subject to the following conditions:
# 
#   The above copyright notice and this permission notice shall be
#   included in all copies or substantial portions of the Software.
# 
#   The Software must not be transferred to persons who are not US
#   citizens or permanent residents of the US or exported outside
#   the US (except Canada) in any form (including by electronic
#   transmission) without prior written approval from the US
#   Government. Non-compliance with these restrictions constitutes
#   a violation of the U.S. Export Control Laws.
# 
#   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
#   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
#   OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
#   NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
#   FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
#   OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
#   CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
#   THE USE OR OTHER DEALINGS IN THE SOFTWARE.
# 
#   Except as contained in this notice, the name of Sun Microsystems, Inc.
#   shall not be used in advertising or otherwise to promote
#   the sale, use or other dealings in this Software or its derivatives 
#   without prior written authorization from Sun Microsystems, Inc.
;GIL-3
(
(
	:type                   :menu
	:name                   stats_menu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "SKIP Statistics"
	:menu-item-labels       ("Interface Stats" "Header Stats" "Algorithm Stats" "Key Stats" )
	:menu-item-label-types  (:string :string :string :string )
	:menu-item-states       (:active :active :active :active )
	:menu-item-defaults     (nil nil nil nil )
	:initial-selections     (nil nil nil nil )
	:menu-item-handlers     (nil nil nil nil )
	:menu-item-menus        (nil nil nil nil )
	:menu-item-colors       ("" "" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (stats_menu "Interface Stats")
		:when                   (Notify )
		:to                     (stats_menu "Interface Stats")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("stats(0);")
		)
		(
		:from                   (stats_menu "Header Stats")
		:when                   (Notify )
		:to                     (stats_menu "Interface Stats")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("stats(1);")
		)
		(
		:from                   (stats_menu "Algorithm Stats")
		:when                   (Notify )
		:to                     (stats_menu "Interface Stats")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("stats(2);")
		)
		(
		:from                   (stats_menu "Key Stats")
		:when                   (Notify )
		:to                     (stats_menu "Interface Stats")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("stats(3);")
		)
	)
)
(
	:type                   :menu
	:name                   menu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "File"
	:menu-item-labels       ("Key Management..." "SKIP Statistics" "Save" )
	:menu-item-label-types  (:string :string :string )
	:menu-item-states       (:active :active :inactive )
	:menu-item-defaults     (nil nil nil )
	:initial-selections     (nil nil nil )
	:menu-item-handlers     (nil nil nil )
	:menu-item-menus        (nil stats_menu nil )
	:menu-item-colors       ("" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (menu "Key Management...")
		:when                   (Notify )
		:to                     (key_params_win)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (menu "Key Management...")
		:when                   (Notify )
		:to                     (key_params_win)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("get_key_params();
")
		)
	)
)
(
	:type                   :menu
	:name                   help_menu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Help"
	:menu-item-labels       ("Help items" "About..." )
	:menu-item-label-types  (:string :string )
	:menu-item-states       (:inactive :active )
	:menu-item-defaults     (nil t )
	:initial-selections     (nil nil )
	:menu-item-handlers     (nil nil )
	:menu-item-menus        (nil nil )
	:menu-item-colors       ("" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (help_menu "About...")
		:when                   (Notify )
		:to                     (about_win)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
	)
)
(
	:type                   :base-window
	:name                   base_window
	:owner                  nil
	:width                  362
	:height                 454
	:background-color       ""
	:foreground-color       ""
	:label                  "SKIP for Solaris ()"
	:label-type             :string
	:initial-state          :open
	:show-footer            t
	:resizable              nil
	:icon-file              "skiptool_small.xbm"
	:icon-label             "skip"
	:icon-mask-file         ""
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls6
	:owner                  base_window
	:help                   ""
	:x                      0
	:y                      0
	:width                  362
	:height                 33
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   settings_button
	:owner                  controls6
	:help                   ""
	:x                      20
	:y                      8
	:width                  54
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "File"
	:label-type             :string
	:initial-state          :active
	:menu                   menu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   help_button
	:owner                  controls6
	:help                   ""
	:x                      282
	:y                      8
	:width                  60
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Help"
	:label-type             :string
	:initial-state          :active
	:menu                   help_menu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls1
	:owner                  base_window
	:help                   ""
	:x                      0
	:y                      33
	:width                  362
	:height                 145
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   skip_icon
	:owner                  controls1
	:help                   ""
	:x                      22
	:y                      12
	:width                  64
	:height                 42
	:foreground-color       ""
	:label                  "skiptool_small.xbm"
	:label-type             :glyph
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   system_status
	:owner                  controls1
	:help                   ""
	:x                      104
	:y                      36
	:width                  221
	:height                 13
	:foreground-color       ""
	:label                  "0 systems authorized to connect"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   access_ctrl
	:owner                  controls1
	:help                   ""
	:x                      186
	:y                      72
	:width                  88
	:height                 23
	:value-x                186
	:value-y                72
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("disabled" "enabled" )
	:choice-label-types     (:string :string )
	:choice-colors          ("" "" )
	:choice-defaults        (nil nil )
	:initial-selections     (nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (base_window access_ctrl "disabled")
		:when                   (Notify )
		:to                     (base_window access_ctrl "disabled")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("access_update();")
		)
		(
		:from                   (base_window access_ctrl "enabled")
		:when                   (Notify )
		:to                     (base_window access_ctrl "disabled")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("access_update();")
		)
	)
)
(
	:type                   :message
	:name                   message6
	:owner                  controls1
	:help                   ""
	:x                      20
	:y                      77
	:width                  119
	:height                 13
	:foreground-color       ""
	:label                  "Access control is:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   access_mode
	:owner                  controls1
	:help                   ""
	:x                      186
	:y                      104
	:width                  160
	:height                 23
	:value-x                186
	:value-y                104
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("No access" "Ask for confirmation" "Add automatically" )
	:choice-label-types     (:string :string :string )
	:choice-colors          ("" "" "" )
	:choice-defaults        (nil nil nil )
	:initial-selections     (nil nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (base_window access_mode "No access")
		:when                   (Notify )
		:to                     (base_window access_mode "No access")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("access_update();")
		)
		(
		:from                   (base_window access_mode "Ask for confirmation")
		:when                   (Notify )
		:to                     (base_window access_mode "Ask for confirmation")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("access_update();")
		)
		(
		:from                   (base_window access_mode "Add automatically")
		:when                   (Notify )
		:to                     (base_window access_mode "Add automatically")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("access_update();")
		)
	)
)
(
	:type                   :message
	:name                   message12
	:owner                  controls1
	:help                   ""
	:x                      20
	:y                      108
	:width                  157
	:height                 13
	:foreground-color       ""
	:label                  "Unauthorized systems:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   remote_panel
	:owner                  base_window
	:help                   ""
	:x                      0
	:y                      175
	:width                  362
	:height                 236
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :scrolling-list
	:name                   hostlist
	:owner                  remote_panel
	:help                   ""
	:x                      22
	:y                      18
	:width                  300
	:height                 198
	:value-x                22
	:value-y                35
	:rows                   7
	:foreground-color       ""
	:label                  "Authorized Systems List:"
	:title                  ""
	:label-type             :string
	:layout-type            :vertical
	:read-only              t
	:multiple-selections    nil
	:selection-required     t
	:initial-state          :active
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:notify-handler         systems_list_notify
	:event-handler          nil
	:initial-list-values    ("" )
	:initial-list-glyphs    ("none.xbm" )
	:initial-selections     (nil )
	:user-data              ()
	:actions                (
		(
		:from                   (base_window hostlist)
		:when                   (Notify )
		:to                     (base_window hostlist)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (systems_list_notify)
		)
	)
)
(
	:type                   :control-area
	:name                   controls8
	:owner                  base_window
	:help                   ""
	:x                      0
	:y                      408
	:width                  362
	:height                 46
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   add_host_button1
	:owner                  controls8
	:help                   ""
	:x                      46
	:y                      16
	:width                  51
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Add..."
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (base_window add_host_button1)
		:when                   (Notify )
		:to                     (hostwin)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
	)
)
(
	:type                   :button
	:name                   delete_button
	:owner                  controls8
	:help                   ""
	:x                      132
	:y                      16
	:width                  57
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Delete"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (base_window delete_button)
		:when                   (Notify )
		:to                     (base_window delete_button)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("host_delete();")
		)
	)
)
(
	:type                   :button
	:name                   key_status
	:owner                  controls8
	:help                   ""
	:x                      226
	:y                      16
	:width                  90
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Key status..."
	:label-type             :string
	:initial-state          :inactive
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (base_window key_status)
		:when                   (Notify )
		:to                     (base_window key_status)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("key_status();")
		)
	)
)
(
	:type                   :popup-window
	:name                   hostwin
	:owner                  base_window
	:width                  327
	:height                 438
	:background-color       ""
	:foreground-color       ""
	:label                  "Add system..."
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls3
	:owner                  hostwin
	:help                   ""
	:x                      0
	:y                      0
	:width                  327
	:height                 438
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   skip_icon
	:owner                  controls3
	:help                   ""
	:x                      20
	:y                      12
	:width                  64
	:height                 42
	:foreground-color       ""
	:label                  "skiptool_small.xbm"
	:label-type             :glyph
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   hostaddr
	:owner                  controls3
	:help                   ""
	:x                      94
	:y                      36
	:width                  224
	:height                 15
	:value-x                174
	:value-y                36
	:value-length           18
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Hostname:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   secure
	:owner                  controls3
	:help                   ""
	:x                      94
	:y                      75
	:width                  214
	:height                 23
	:value-x                94
	:value-y                75
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Off" "On" "On (SunScreen compatibility)" )
	:choice-label-types     (:string :string :string )
	:choice-colors          ("" "" "" )
	:choice-defaults        (nil nil nil )
	:initial-selections     (nil nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (hostwin secure)
		:when                   (Notify )
		:to                     (hostwin secure)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("build_alg_menus(ip);
selectors_available(ip);")
		)
	)
)
(
	:type                   :message
	:name                   message1
	:owner                  controls3
	:help                   ""
	:x                      20
	:y                      80
	:width                  59
	:height                 13
	:foreground-color       ""
	:label                  "Security:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   skip_mode
	:owner                  controls3
	:help                   ""
	:x                      94
	:y                      100
	:width                  117
	:height                 23
	:value-x                94
	:value-y                100
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Whole packet" "Data only" )
	:choice-label-types     (:string :string )
	:choice-colors          ("" "" )
	:choice-defaults        (nil nil )
	:initial-selections     (nil nil )
	:initial-state          :inactive
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message7
	:owner                  controls3
	:help                   ""
	:x                      20
	:y                      105
	:width                  49
	:height                 13
	:foreground-color       ""
	:label                  "Secure:"
	:label-type             :string
	:label-bold             t
	:initial-state          :inactive
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   r_nsid
	:owner                  controls3
	:help                   ""
	:x                      94
	:y                      125
	:width                  107
	:height                 23
	:value-x                94
	:value-y                125
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Not present" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :inactive
	:user-data              ()
	:actions                (
		(
		:from                   (hostwin r_nsid)
		:when                   (Notify )
		:to                     (hostwin r_nsid)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("selectors_available(ip);")
		)
	)
)
(
	:type                   :message
	:name                   r_nsid_msg
	:owner                  controls3
	:help                   ""
	:x                      20
	:y                      130
	:width                  47
	:height                 13
	:foreground-color       ""
	:label                  "Key ID:"
	:label-type             :string
	:label-bold             t
	:initial-state          :inactive
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   key_id
	:owner                  controls3
	:help                   ""
	:x                      20
	:y                      155
	:width                  298
	:height                 15
	:value-x                46
	:value-y                155
	:value-length           34
	:stored-length          80
	:rows                   2
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "ID:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :inactive
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls9
	:owner                  hostwin
	:help                   ""
	:x                      0
	:y                      184
	:width                  327
	:height                 100
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   s_nsid
	:owner                  controls9
	:help                   ""
	:x                      164
	:y                      12
	:width                  107
	:height                 23
	:value-x                164
	:value-y                12
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Not present" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :inactive
	:user-data              ()
	:actions                (
		(
		:from                   (hostwin s_nsid)
		:when                   (Notify )
		:to                     (hostwin s_nsid)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("selectors_available(ip);")
		)
	)
)
(
	:type                   :message
	:name                   s_nsid_msg
	:owner                  controls9
	:help                   ""
	:x                      20
	:y                      18
	:width                  87
	:height                 13
	:foreground-color       ""
	:label                  "Local Key ID:"
	:label-type             :string
	:label-bold             t
	:initial-state          :inactive
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls10
	:owner                  hostwin
	:help                   ""
	:x                      0
	:y                      229
	:width                  327
	:height                 158
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   kij_alg
	:owner                  controls10
	:help                   ""
	:x                      164
	:y                      16
	:width                  66
	:height                 23
	:value-x                164
	:value-y                16
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("none" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :inactive
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   kp_alg_msg
	:owner                  controls10
	:help                   ""
	:x                      20
	:y                      21
	:width                  106
	:height                 13
	:foreground-color       ""
	:label                  "Key encryption:"
	:label-type             :string
	:label-bold             t
	:initial-state          :inactive
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   kp_alg
	:owner                  controls10
	:help                   ""
	:x                      164
	:y                      48
	:width                  66
	:height                 23
	:value-x                164
	:value-y                48
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("none" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :inactive
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   kij_alg_msg
	:owner                  controls10
	:help                   ""
	:x                      20
	:y                      53
	:width                  128
	:height                 13
	:foreground-color       ""
	:label                  "Traffic encryption:"
	:label-type             :string
	:label-bold             t
	:initial-state          :inactive
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   mac_alg
	:owner                  controls10
	:help                   ""
	:x                      164
	:y                      80
	:width                  56
	:height                 23
	:value-x                164
	:value-y                80
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Off" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :inactive
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message10
	:owner                  controls10
	:help                   ""
	:x                      20
	:y                      85
	:width                  104
	:height                 13
	:foreground-color       ""
	:label                  "Authentication:"
	:label-type             :string
	:label-bold             t
	:initial-state          :inactive
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   comp_alg
	:owner                  controls10
	:help                   ""
	:x                      164
	:y                      112
	:width                  56
	:height                 23
	:value-x                164
	:value-y                112
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Off" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :inactive
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message11
	:owner                  controls10
	:help                   ""
	:x                      20
	:y                      117
	:width                  94
	:height                 13
	:foreground-color       ""
	:label                  "Compression:"
	:label-type             :string
	:label-bold             t
	:initial-state          :inactive
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls7
	:owner                  hostwin
	:help                   ""
	:x                      0
	:y                      383
	:width                  327
	:height                 55
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   hostwin_apply
	:owner                  controls7
	:help                   ""
	:x                      88
	:y                      18
	:width                  53
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Apply"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (hostwin hostwin_apply)
		:when                   (Notify )
		:to                     (hostwin hostwin_apply)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("hostwin_apply(ip);")
		)
	)
)
(
	:type                   :button
	:name                   hostwin_cancel
	:owner                  controls7
	:help                   ""
	:x                      188
	:y                      18
	:width                  59
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Cancel"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (hostwin hostwin_cancel)
		:when                   (Notify )
		:to                     (hostwin hostwin_cancel)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("save_or_discard(ip);")
		)
	)
)
(
	:type                   :popup-window
	:name                   key_params_win
	:owner                  base_window
	:width                  414
	:height                 149
	:background-color       ""
	:foreground-color       ""
	:label                  "Key Management Parameters"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls4
	:owner                  key_params_win
	:help                   ""
	:x                      0
	:y                      0
	:width                  414
	:height                 149
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   skip_key_max_use
	:owner                  controls4
	:help                   ""
	:x                      220
	:y                      16
	:width                  75
	:height                 15
	:value-x                220
	:value-y                16
	:value-length           5
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              100
	:min-value              0
	:initial-value          30
	:initial-state          :inactive
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message3
	:owner                  controls4
	:help                   ""
	:x                      15
	:y                      17
	:width                  195
	:height                 13
	:foreground-color       ""
	:label                  "Change transmit keys every:"
	:label-type             :string
	:label-bold             t
	:initial-state          :inactive
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message12
	:owner                  controls4
	:help                   ""
	:x                      304
	:y                      18
	:width                  56
	:height                 13
	:foreground-color       ""
	:label                  "seconds"
	:label-type             :string
	:label-bold             t
	:initial-state          :inactive
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   skip_key_max_idle
	:owner                  controls4
	:help                   ""
	:x                      220
	:y                      40
	:width                  75
	:height                 15
	:value-x                220
	:value-y                40
	:value-length           5
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              10000
	:min-value              5
	:initial-value          30
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message14
	:owner                  controls4
	:help                   ""
	:x                      35
	:y                      42
	:width                  175
	:height                 13
	:foreground-color       ""
	:label                  "Delete unused keys after:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message4
	:owner                  controls4
	:help                   ""
	:x                      304
	:y                      42
	:width                  56
	:height                 13
	:foreground-color       ""
	:label                  "seconds"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   skip_key_max_bytes
	:owner                  controls4
	:help                   ""
	:x                      220
	:y                      66
	:width                  75
	:height                 15
	:value-x                220
	:value-y                66
	:value-length           5
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              10000
	:min-value              1
	:initial-value          512
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message15
	:owner                  controls4
	:help                   ""
	:x                      89
	:y                      67
	:width                  121
	:height                 13
	:foreground-color       ""
	:label                  "Transmit at most:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message2
	:owner                  controls4
	:help                   ""
	:x                      304
	:y                      67
	:width                  101
	:height                 13
	:foreground-color       ""
	:label                  "kbytes per key"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   key_apply
	:owner                  controls4
	:help                   ""
	:x                      85
	:y                      104
	:width                  53
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Apply"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (key_params_win key_apply)
		:when                   (Notify )
		:to                     (key_params_win)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (key_params_win key_apply)
		:when                   (Notify )
		:to                     (key_params_win)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("set_key_params();
")
		)
	)
)
(
	:type                   :button
	:name                   key_default
	:owner                  controls4
	:help                   ""
	:x                      175
	:y                      104
	:width                  63
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Default"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (key_params_win key_default)
		:when                   (Notify )
		:to                     (key_params_win key_default)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("set_key_defaults();
")
		)
	)
)
(
	:type                   :button
	:name                   key_cancel
	:owner                  controls4
	:help                   ""
	:x                      277
	:y                      104
	:width                  59
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Cancel"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :popup-window
	:name                   required_win
	:owner                  base_window
	:width                  354
	:height                 323
	:background-color       ""
	:foreground-color       ""
	:label                  "Required systems"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls5
	:owner                  required_win
	:help                   ""
	:x                      0
	:y                      0
	:width                  354
	:height                 78
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   skip_icon
	:owner                  controls5
	:help                   ""
	:x                      20
	:y                      12
	:width                  64
	:height                 42
	:foreground-color       ""
	:label                  "skiptool_small.xbm"
	:label-type             :glyph
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   required_message
	:owner                  controls5
	:help                   ""
	:x                      100
	:y                      36
	:width                  196
	:height                 13
	:foreground-color       ""
	:label                  "0 addresses currently in use"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls11
	:owner                  required_win
	:help                   ""
	:x                      0
	:y                      71
	:width                  354
	:height                 210
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message5
	:owner                  controls11
	:help                   ""
	:x                      20
	:y                      12
	:width                  323
	:height                 13
	:foreground-color       ""
	:label                  "The addresses below are currently in use and should"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message13
	:owner                  controls11
	:help                   ""
	:x                      22
	:y                      28
	:width                  211
	:height                 13
	:foreground-color       ""
	:label                  "be added to the access control list:"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :scrolling-list
	:name                   required_list
	:owner                  controls11
	:help                   ""
	:x                      22
	:y                      52
	:width                  300
	:height                 128
	:value-x                22
	:value-y                52
	:rows                   6
	:foreground-color       ""
	:label                  ""
	:title                  ""
	:label-type             :string
	:layout-type            :horizontal
	:read-only              nil
	:multiple-selections    t
	:selection-required     nil
	:initial-state          :active
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:initial-list-values    ()
	:initial-list-glyphs    ()
	:initial-selections     ()
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls12
	:owner                  required_win
	:help                   ""
	:x                      0
	:y                      278
	:width                  354
	:height                 45
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   required_add
	:owner                  controls12
	:help                   ""
	:x                      106
	:y                      16
	:width                  42
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Add"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (required_win required_add)
		:when                   (Notify )
		:to                     (required_win required_add)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("required_systems_add();")
		)
	)
)
(
	:type                   :button
	:name                   required_cancel
	:owner                  controls12
	:help                   ""
	:x                      200
	:y                      16
	:width                  59
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Cancel"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (required_win required_cancel)
		:when                   (Notify )
		:to                     (required_win required_cancel)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("required_systems_done();")
		)
	)
)
(
	:type                   :popup-window
	:name                   about_win
	:owner                  base_window
	:width                  250
	:height                 88
	:background-color       ""
	:foreground-color       ""
	:label                  "About skiptool"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls2
	:owner                  about_win
	:help                   ""
	:x                      0
	:y                      0
	:width                  250
	:height                 88
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   skip_icon
	:owner                  controls2
	:help                   ""
	:x                      14
	:y                      16
	:width                  64
	:height                 42
	:foreground-color       ""
	:label                  "skiptool_small.xbm"
	:label-type             :glyph
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message8
	:owner                  controls2
	:help                   ""
	:x                      90
	:y                      36
	:width                  143
	:height                 13
	:foreground-color       ""
	:label                  "skiptool version 2.00"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
)
