/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_kvm.c	1.9 95/11/22 Sun Microsystems"

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stream.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <arpa/inet.h>

#include <bdcmod.h>
#include <skip_types.h>
#include <skip_proto.h>
#include <skip_conf.h>
#include <skip_ioctl.h>
#include <skip_lib.h>
#include <skip_crypt.h>
#include <skip_keymgrmsgs.h>
#include <skip_key.h>

#define STRSZ		256

int
skip_var_init(char *who)
{
	if (skip_get_kij_algs() < 0) {
		sprintf(skip_errmsg, "%s: failed to retrieve list of "
			"key encryption algorithms", SKIPNAME);
		return (-1);
	}
	if (skip_get_kp_algs() < 0) {
		sprintf(skip_errmsg, "%s: failed to retrieve list of "
			"traffic encryption algorithms", SKIPNAME);
		return (-1);
	}

	/*
	 * Initialize private Kij and Kp algs (locally defined)
	 */
	skip_kp_algs[SKIP_CRYPT_RC4_40] = "RC4-40";
	skip_kp_algs[SKIP_CRYPT_SIMPLECRYPT] = "simplecrypt";
	skip_kij_algs[SKIP_KIJ_SIMPLECRYPT] = "simplecrypt";
	
	return (0);
}

/*ARGSUSED*/
int
skip_get_kij_algs()
{
	extern boolean_t	skip_supported_kij_algs[];
	extern boolean_t	skip_supported_kij_algs_v1[];
	ioctl_alg_list_t	kij_algs_list;
	char			*if_name = skip_default_if();
	int			idx;

	if (skip_get_kij_list(if_name, &kij_algs_list)) {
		fprintf(stderr, "%s\n", skip_errmsg);
		return(-1);
	}

	for (idx = 0; idx < SKIP_MAXCRYPTORS; idx++) {
		skip_supported_kij_algs[idx] = 
				kij_algs_list.flag_alg[idx];
		skip_supported_kij_algs_v1[idx] = 
				kij_algs_list.flag_alg_v1[idx];

        }

	return(0);
}

int
skip_get_kp_algs()
{

	extern boolean_t	skip_supported_kp_algs[];
	extern boolean_t	skip_supported_kp_algs_v1[];
	ioctl_alg_list_t	kp_algs_list;
	int			idx;
	char			*if_name = skip_default_if();

	if (skip_get_crypt_list(if_name, &kp_algs_list)) {
		fprintf(stderr, "%s\n", skip_errmsg);
		return(-1);
	}

	for (idx = 0; idx < SKIP_MAXCRYPTORS; idx++) {
		skip_supported_kp_algs[idx] = 
				kp_algs_list.flag_alg[idx];
		skip_supported_kp_algs_v1[idx] = 
				kp_algs_list.flag_alg_v1[idx];

        }

	return(0);
}

int
skip_bytes_percent(ioctl_key_status_t *kp)
{
	if (kp->max_obytes > 0) {
		return (kp->obytes*100/kp->max_obytes);
	} else {
		return (0);
	}
}
