/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_keymgrmsgs.h	1.7 95/11/15 Sun Microsystems"

#ifndef SKIP_KEYMGRMSGS_H
#define SKIP_KEYMGRMSGS_H

#ifdef  __cplusplus
extern "C" {
#endif

enum skip_msgs {
	SKIP_ENCRYPTED_PKT_KEY_REQ = 1,
	SKIP_ENCRYPTED_PKT_KEY_RSP,
	SKIP_DECRYPTED_PKT_KEY_REQ,
	SKIP_DECRYPTED_PKT_KEY_RSP,
	SKIP_DH_CERTIFICATE_REQ,
	SKIP_DH_CERTIFICATE_RSP,
	SKIP_SET_LOCAL_KEYID ,
	SKIP_SET_SUPPORTED_KIJ };

struct Commonmsg {
	unsigned int	msgtype;
};

struct Encrypted_key_req {
	unsigned int	msgtype;	/* SKIP_ENCRYPTED_PKT_KEY_REQ */
	skip_param_t	params;
};

struct Encrypted_key_rsp {
	unsigned int	msgtype;	/* SKIP_ENCRYPTED_PKT_KEY_RSP */
	skip_param_t	params;
	unsigned int    kp_keylen;
	unsigned int 	kp_offset;
	unsigned int 	iv_len;
	unsigned int 	iv_offset;	
	unsigned int    ekp_keylen;
	unsigned int 	ekp_offset;
	unsigned int    E_kp_keylen;	/* ESP mode only...*/
	unsigned int 	E_kp_offset;	/* ESP mode only...*/
	unsigned int    A_kp_keylen;	/* AH mode only...*/
	unsigned int 	A_kp_offset;	/* AH mode only...*/
};

struct Decrypted_key_req {
	unsigned int	msgtype;	/* SKIP_DECRYPTED_PKT_KEY_REQ */
	skip_param_t	params;
	unsigned int    ekp_keylen;
	unsigned int 	ekp_offset;
};

struct Decrypted_key_rsp {
	unsigned int	msgtype;	/* SKIP_DECRYPTED_PKT_KEY_RSP */
	skip_param_t	params;
	unsigned int    kp_keylen;
	unsigned int 	kp_offset;
	unsigned int    ekp_keylen;
	unsigned int 	ekp_offset;
	unsigned int    E_kp_keylen;	/* ESP mode only...*/
	unsigned int 	E_kp_offset;	/* ESP mode only...*/
	unsigned int    A_kp_keylen;	/* AH mode only...*/
	unsigned int 	A_kp_offset;	/* AH mode only...*/
};

struct Set_local_keyid {
	unsigned int	msgtype;	/* SKIP_SET_LOCAL_KEYID */
	unsigned char	nsid;
	skip_key_var_t	mkeyid;
};

struct Set_supported_kij {
	unsigned int	msgtype;	/* SKIP_SET_SUPPORTED_KIJ */
	unsigned char	version;
	unsigned char	kij_alg;
};

union skip_messages {
	unsigned int			msgtype;
	struct Commonmsg		cmn_msg;
	struct Encrypted_key_req	enc_req;
	struct Encrypted_key_rsp	enc_rsp;
	struct Decrypted_key_req	dec_req;
	struct Decrypted_key_rsp	dec_rsp;
	struct Set_local_keyid		set_keyid;
	struct Set_supported_kij	set_kij_alg;
};

#ifdef  __cplusplus
}
#endif

#endif
