/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_key.h	1.15 95/11/23 Sun Microsystems"

#ifdef  __cplusplus
extern "C" {
#endif

/* 
 * max number of bytes to encrypt before changing key
 */ 
#define	SKIP_KEY_MAX_BYTES      512*1024

/* 
 * timer granularity (seconds)
 */ 
#define	SKIP_KEY_TICK           1 

/* 
 * max number of packets to hold while waiting for a key
 */ 
#define	SKIP_KEY_MAX_PKTS	20

/*
 * max time to wait for a response from the key manager (seconds)
 */
#define	SKIP_KEY_MAX_KM_WAIT	10

/*
 * delete an unused key after this time (seconds)
 */
#define	SKIP_KEY_MAX_IDLE	30

/*
 * XXX
 */
#define SKIP_KEY_MAX_USE	30

/*
 * maximum number of cipher states to have open at one time
 */
#define	SKIP_KEY_MAX_ENTRIES	512

/*
 * max number of crypto systems supported (== sizeof unsigned char)
 */
#define	SKIP_MAXCRYPTORS	256

/*
 * Max number of AH systems supported (== sizeof unsigned char)
 */
#define	SKIP_MAX_AH_CRYPTORS	256

/*
 * Max number of NSID supported
 */
#define	SKIP_MAX_NSID		SKIP_NSID_MD5_NIS + 1
/*
 * size of SKIP hash table size.  Don't change this without also
 * modifying the hashing functions SKIP_ENCRYPT_HASH()/SKIP_DECRYPT_HASH()
 */
#define	SKIP_HASH_TABLESZ	64
#define	SKIP_ENCRYPT_HASH(x)	(((unsigned char *)(x))[3] & 0x3f)
#define	SKIP_DECRYPT_HASH(x)	(((unsigned char *)(x))[3] & 0x3f)
#define	SKIP_IGNORE_VAL		(-1)

/*
 * structure describing a SKIP client
 */
typedef struct {
	void			*client_data;
	void			(*encrypt_done)();
	void			(*decrypt_done)();
} skip_client_t;

/*
 * structure describing skip header information
 */
#define	SKIP_INIT_HDR_LG	84

typedef struct {
	skip_param_t		params;
	skip_key_var_t		ekp;
	skip_key_var_t		mid;
	/*
	 * preinitialised packet header
	 */
	unsigned char		info[SKIP_INIT_HDR_LG];
	unsigned short		hdrlen;
} skip_hdr_t;

/*
 * structure describing queued callback information
 */
typedef struct skip_queue {
	struct skip_queue	*next;
	SKIP_BUF_T		*in;			/* input pkt  */
	SKIP_BUF_T		*out;			/* output pkt */
	skip_client_t		*client;		/* callback client */
	void			*arg;			/* argument */
	int			rc;			/* return code */
	struct sockaddr		dst;			/* XXX 4.x only */
} skip_queue_t;

/*
 * structure describing a key control block
 */
typedef struct skip_key {
	struct skip_key		*next;
	struct skip_key		*prev;
	void			*cs;			/* channel state */
	skip_hdr_t		hdr;			/* skip header info */
	skip_key_var_t		kp;			/* plain kp */
	int			ttl;			/* time to live */
	unsigned int		obytes;			/* bytes xmited */
	unsigned int		last_obytes;		/* last bytes xmited */
	int			max_obytes;		/* max bytes allowed */
	unsigned int		hash;			/* hash location */
	skip_queue_t		*queue;			/* queue of callbacks */
	int			data_offset;		/* Payload offset */
	skip_key_var_t		E_kp;			/* ESP derived E_kp */
	skip_key_var_t		A_kp;			/* AH derived A_kp */
} skip_keycb_t;

/*
 * Get the crypto module ID from SKIP version and Kp alg
 */
#define GETCRYPTMOD(version, kp) \
	(version == SKIP_V2 ? &skip_cryptors[kp] : &skip_cryptors_v1[kp])

/*
 * shared exported functions
 */
void		*skip_open();
void		skip_close();
void		skip_encrypt(void *, SKIP_BUF_T *, SKIP_BUF_T *,
			skip_param_t *, void *);
void		skip_decrypt(void *, SKIP_BUF_T *, SKIP_BUF_T *,
			skip_hdr_t *hdr, int, void *);
int		skip_key_check(skip_keycb_t *);
void		skip_key_iterate(int (*)(), void *);
int		skip_hdr_encode(skip_hdr_t *, unsigned char *);
int		skip_iv_encode(skip_hdr_t *, unsigned char *);
void		skip_hdr_init(skip_keycb_t *);

void		skip_key_tellkm(enum skip_msgs, skip_keycb_t *);
void		skip_key_fromkm(union skip_messages *, unsigned int);
void		skip_update_encrypt_key(struct Encrypted_key_rsp *);
void		skip_update_decrypt_key(struct Decrypted_key_rsp *);

/*
 * exported functions for SunScreen Mode 
 */
int		skip_hdr_v1_decode(unsigned char *, unsigned char *, 
			struct in_addr *, skip_hdr_t *);
int		skip_iv_v1_decode(skip_hdr_t *, unsigned char *,
							unsigned char *);

/*
 * exported functions for IPSP mode
 */
int		skip_hdr_ipsp_decode(unsigned char *, unsigned char *, 
					struct in_addr *, skip_hdr_t *);
int		skip_iv_esp_decode(skip_hdr_t *, unsigned char *,
							unsigned char *);


#if defined(_KERNEL) || defined(KERNEL)
/*
 * function prototypes
 */
static void	skip_key_inittimers();
static void	skip_key_uninittimers();
static void	skip_key_initstats();
static void	skip_key_uninitstats();
static int	skip_key_destroy(skip_keycb_t *, void *);
void		skip_key_fromkm(union skip_messages *, unsigned int);
static void	skip_key_timer();
#endif


/*
 * external variables
 */
extern skip_key_var_t	skip_local_keys[];
extern unsigned char	skip_nsid[];
extern int		skip_key_max_bytes;
extern int		skip_key_max_pkts;
extern int		skip_key_max_km_wait;
extern int		skip_key_max_idle;
extern int		skip_key_max_use;
extern const int	skip_key_tick;
extern int		skip_key_debug;
/*
 * Supported Kij algorithms by the key manager
 */
extern boolean_t	skip_kmgr_kij_alg[];
extern boolean_t	skip_kmgr_kij_alg_v1[];

#ifdef  __cplusplus
}
#endif
