/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_crypt.h	1.11 95/11/15 Sun Microsystems"

#ifdef  __cplusplus
extern "C" {
#endif
/*
 * structure describing an encrypt/decrypt engine
 */
typedef struct {
	char			*name;
	void			*(*open)(
					char *,		/* key */
					unsigned int,	/* key len */
					char *,		/* iv */
					unsigned int	/* iv len */
				);
	void			(*close)(
					void *		/* cipher state */
				);
	void			(*encrypt)(
					void *,		/* cipher state */
					char *,		/* in */
					unsigned int *,	/* in lenp */
					char *,		/* out */
					char *,		/* mid */
					unsigned int,	/* mid len */
					unsigned char *	/* payload type */
				);
	void			(*decrypt)(
					void *,		/* cipher state */
					char *,		/* in */
					unsigned int *,	/* in lenp */
					char *,		/* out */
					char *,		/* mid */
					unsigned int,	/* mid len */
					unsigned char *	/* payload type */
				);
	unsigned int		(*getoutputlen)(
					unsigned int	/* in size */
				);
	int			kp_len;			/* kp len */
	int			ekp_len;		/* encrypted kp len */
	int			mid_len;		/* iv/mid len */
	int			flags;			/* characteristics */
	int			kij_algno;		/* Kij algorithm ID */
	int			kp_algno;		/* Kp algorithm ID */

	/*
	 * do not initialize the rest of this structure...
	 */
	unsigned long		encrypts;
	unsigned long		encrypterrs;
	unsigned long		decrypts;
	unsigned long		decrypterrs;
} skip_cryptor_t;

#define	CRYPT_NOT_PRESENT		"not present"

/*
 * flags definitions, used to identify cipher characteristics
 */
#define	SKIP_STREAM_CIPHER		(1)
#define	SKIP_BLOCK_CIPHER		(2)
#define SKIP_KEYED_STREAM_CIPHER	(4)

/*
 * extern declarations
 */
extern skip_cryptor_t		skip_cryptors[];
extern skip_cryptor_t		skip_cryptors_v1[];
extern int			skip_install_cryptmod(const skip_cryptor_t *,
						unsigned int, unsigned char);
extern void			skip_remove_cryptmod(unsigned int,
						unsigned char);

#ifdef  __cplusplus
}
#endif
