/* randomchallenge.c: The opierandomchallenge() library function.

Portions of this software are Copyright 1996 by Craig Metz, All Rights
Reserved. The Inner Net Copyright Notice and License Agreement applies to
these portions of the software.

Portions of this software are Copyright 1995 by Randall Atkinson and Dan
McDonald, All Rights Reserved. All Rights under this copyright are assigned
to the U.S. Naval Research Laboratory (NRL). The NRL Copyright Notice and
License Agreement applies to this software.

        History:

	Modified by cmetz for OPIE 2.2. Use FUNCTION declaration et al.
             Changed use of gethostname() to uname(). Ifdefed around some
             headers.
        Created at NRL for OPIE 2.2 from opiesubr2.c
*/

#include "opie_cfg.h"

#if DEBUG
#include <stdio.h>
#endif /* DEBUG */
#if HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */
#if HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif /* HAVE_SYS_PARAM_H */
#if HAVE_SYS_UTSNAME_H
#include <sys/utsname.h>
#endif /* HAVE_SYS_UTSNAME_H */

#include "opie.h"

/* Generate a random challenge */
/* This could grow into quite a monster, really. Random is good enough for
   most situations; it is certainly better than a fixed string */
VOIDRET opierandomchallenge FUNCTION((prompt), char *prompt)
{
  time_t now;
  struct utsname utsname;

  time(&now);
  srand(now);
  now = rand();

  if (uname(&utsname) < 0) {
    perror("uname");
    utsname.nodename[0] = 'k';
    utsname.nodename[1] = 'e';
  }
  utsname.nodename[2] = 0;
  sprintf(prompt, "otp-md%d %d %s%04d", MDX, (rand() % 499) + 1, utsname.nodename, (now % 9998) + 1);
}
