/* pkcrack - stage2.c
 *
 * (C) by Peter Conrad <conrad@unix-ag.uni-kl.de>
 *
 * $Id: stage2.c,v 1.3 1996/06/12 09:47:24 conrad Release $
 *
 * $Log: stage2.c,v $
 * Revision 1.3  1996/06/12 09:47:24  conrad
 * Release version
 *
 * Revision 1.2  1996/06/11 10:28:53  conrad
 * moved fflush() a couple of lines to the front, so key[012] values
 * get printed as soon as they are found.
 *
 * Revision 1.1  1996/06/10 18:04:36  conrad
 * Initial revision
 *
 */

static char RCSID[]="$Id: stage2.c,v 1.3 1996/06/12 09:47:24 conrad Release $";

#include <stdio.h>
#include "pkcrack.h"
#include "crc.h"
#include "mktemptbl.h"
#include "keystuff.h"
#include "stage3.h"

#define	CONST		0x08088405	/* 134775813 */
#define	INVCONST	0xd94fa8cd	/* CONST^{-1} */

#define	MULT(x)		((mulTab[((x)>>24)&0xff]<<24) + \
			 (mulTab[((x)>>16)&0xff]<<16) + \
			 (mulTab[((x)>> 8)&0xff]<< 8) + \
			 (mulTab[((x)    )&0xff]    ))

static uword	mulTab[256];
static byte	mTab2[256][16];
static int	mTab2Counter[256];

static uword key2list[13], key1list[13], key0list[13];

uword	loesung0, loesung1, loesung2;

static void buildkey0list( )
/* From 4 consecutive LSBs of key0 build a complete key0 value.
 * See section 3.4 of the Biham/Kocher paper.
 */
{
int	i;
uword	temp;

/*    if( key1list[3] == 0x411bdb9 )
	for( i = 3; i < 13; i++ )
	    printf( "%8x %8x %8x\n", key0list[i], key1list[i], key2list[i] );*/

    temp = key0 = key0list[4];
    updateKeys( plaintext[4+12] );
    temp ^= ((key0^key0list[5])&0xff)<<8;
    key0 = temp;
    updateKeys( plaintext[4+12] );

    temp = key0;
    updateKeys( plaintext[5+12] );
    temp ^= ((key0^key0list[6])&0xff)<<8;
    key0 = temp;
    updateKeys( plaintext[5+12] );

    temp = key0;
    updateKeys( plaintext[6+12] );
    temp ^= ((key0^key0list[7])&0xff)<<8;
    key0 = temp;
    updateKeys( plaintext[6+12] );

    temp = key0;
    updateKeys( plaintext[7+12] );
    temp ^= ((key0^key0list[8])&0xff)<<8;
    key0 = temp;

/*    if( key1list[3] == 0x411bdb9 )
	printf( "Found a possibility. key0_8 = %8x\n", key0 );*/

    /* Now we have the full value of key0_7 */
    /* Check if it is valid by computing key0_{[8..12]} and comparing to
     * the known LSBs */
    i = 7;
    key1 = key1list[i];
    key2 = key2list[i];
    do{
	updateKeys( plaintext[i+12] );
	i++;
    } while( i < 13 && (key0&0xff) == (key0list[i]&0xff) );

/*    if( key1list[3] == 0x411bdb9 )
	printf( "Found a possibility. Check worked for %d bytes.\n", i-8 );*/

    if( i == 13 )
    { /* Got it! Now calculate backwards 'til key0_0... */
	for( i += 12; i > 0; i-- )
	{
	    key2 = INVCRC32(key2,(key1>>24)&0xff);
	    temp = (key2 & 0xffff)|3;
	    key3 = ((temp*(temp^1))>>8)&0xff;
	    plaintext[i-1] = ciphertext[i-1]^key3;
	    key1 = MULT(key1-1)-(key0&0xff);
	    key0 = INVCRC32(key0,plaintext[i-1]);
	    /*printf( "%2d %8x %8x %8x\n", i-1, key0, key1, key2 );*/
	}
	loesung0 = key0;
	loesung1 = key1;
	loesung2 = key2;
	printf( "Ta-daaaaa! key0=%8x, key1=%8x, key2=%8x\007\n", key0, key1, key2 );
	fflush( stdout );
	initStage3Tab();
	findPwd( key0, key1, key2 );
	key2 = loesung2;
	key1 = loesung1;
	key0 = loesung0;
    }
}

static void recursion1( int i )
/* given a value for key1_i, compute all possible values of key1_{i-1} that
 * fit the MSB of key1_{i-2} */
{
int	k;
uword	MSBiminus1, MSBiminus2, lsbkey0, lsbkey0pluskey1iminus1, test, temp2;
byte	diff;

    if( i == 3 )
    {
	buildkey0list( );
	return;
    }
/*    if( key1list[12] == 0xc3066eb6 )
	printf( "%s%08x\n", "            "+i, key1list[i] );*/

    MSBiminus1 = key1list[i-1]&0xff000000;
    MSBiminus2 = key1list[i-2]&0xff000000;
    lsbkey0pluskey1iminus1 = MULT(key1list[i]-1);
    temp2 = MULT(lsbkey0pluskey1iminus1-1);
    diff = (((temp2&0xff000000)-MSBiminus2)>>24)&0xff;
    for( k = 0; k < mTab2Counter[diff]; k++ )
    {
	test = temp2 - mulTab[mTab2[diff][k]];
	if( test >= MSBiminus2 && test <= MSBiminus2 + 0x010000fe )
	{
	    lsbkey0 = mTab2[diff][k];
	    key1list[i-1] = lsbkey0pluskey1iminus1-lsbkey0;
	    key0list[i]   = lsbkey0;
	    recursion1( i-1 );
	}
    }
    diff--;
    for( k = 0; k < mTab2Counter[diff]; k++ )
    {
	test = temp2 - mulTab[mTab2[diff][k]];
	if( test >= MSBiminus2 && test <= MSBiminus2 + 0x010000fe )
	{
	    lsbkey0 = mTab2[diff][k];
	    key1list[i-1] = lsbkey0pluskey1iminus1-lsbkey0;
	    key0list[i]   = lsbkey0;
	    recursion1( i-1 );
	}
    }
    key1list[i-1] = MSBiminus1;
}

static void buildkey1list( )
/* Find all values for key1_12 that produce the correct MSB for key_11
 * See section 3.3 of the Biham-Kocher paper. */
{
uword	i, j, k;
uword	test, MSBi, MSBiminus1, temp, temp2;
byte	diff;

    MSBi = key1list[12] & 0xff000000;
    MSBiminus1 = key1list[11] & 0xff000000;
    test = (MSBi-1)*INVCONST;
    if( test >= MSBiminus1 && test <= MSBiminus1 + 0x010000fe )
    {
	key1list[12] = MSBi;
	recursion1( 12 );
    }

    /* There's 2^24 possible values for key1_12, given its MSB.
     * We check them all, substitution multiplications by table-lookup and add
     * to save time */
    temp = mulTab[(MSBi>>24)&0xff]<<24;
    for( i = 0; i < 256; i++ )
	for( j = 0; j < 256; j++ )
	{
	    temp2 = temp + (mulTab[i]<<16) + (mulTab[j]<<8);
	    diff = ((MSBiminus1 - (temp2&0xff000000))>>24)&0xff;
	    for( k = 0; k < mTab2Counter[diff]; k++ )
	    {
		test = temp2 + mulTab[mTab2[diff][k]];
		if( test >= MSBiminus1 && test <= MSBiminus1 + 0x010000fe )
		{
		    key1list[12] = MSBi + (i<<16) + (j<<8) + mTab2[diff][k] + 1;
		    recursion1( 12 );
		}
	    }
	    diff--;
	    for( k = 0; k < mTab2Counter[diff]; k++ )
	    {
		test = temp2 + mulTab[mTab2[diff][k]];
		if( test >= MSBiminus1 && test <= MSBiminus1 + 0x010000fe )
		{
		    key1list[12] = MSBi + (i<<16) + (j<<8) + mTab2[diff][k] + 1;
		    recursion1( 12 );
		}
	    }
	}
    key1list[12] = MSBi;
}

static void recursion2( int i )
/* Calculate key2_{i-1} from key2_i, key3_{i-1} and key3_{i-2},
 * calculate MSB of key1_i */
{
int	k, l;
byte	key3iminus1, key3iminus2, hadIt=0;
uword	key2j, key2iminus1, key2iminus2, newKey, oldValue;

    if( i == 1 )
    {
	buildkey1list( );
	return;
    }

    key3iminus1 = KEY3(i+12-1);
    key3iminus2 = KEY3(i+12-2);
    /* This works exactly like reduceKey2s in stage 1 */
    key2j = key2list[i];
    key2iminus1 = INVCRC32(key2j,0)&0xffffff00;
    for( k = 0; k < 64; k++ )
	if( (tempTable[key3iminus1][k]&0xff00) == (key2iminus1&0xff00) )
	{
	    newKey = key2iminus1|tempTable[key3iminus1][k]; /* b) */
	    key2iminus2 = INVCRC32(newKey,0)&0xfc00;
	    for( l = 0; l < 64; l++ )
		if( (tempTable[key3iminus2][l]&0xfc00) == key2iminus2 )
		{
		    newKey = key2iminus1|(((tempTable[key3iminus2][l]^crcinvtab[(key2iminus1>>24)&0xff])>>8)&0xff); /* c) (and b) */
		    if( !hadIt || oldValue != newKey )
		    {
			key2list[i-1] = newKey;
			key1list[i] = (((key2j<<8)^crcinvtab[(key2j>>24)&0xff]^newKey)&0xff)<<24;
			recursion2( i-1 );
			oldValue = newKey;
			hadIt = 1;
		    }
		}
	}
}

void buildKey2Lists( uword aKey2_13 )
{
    key2list[12] = aKey2_13;
    recursion2( 12 );
}

void initMulTab( )
{
uword	i, prod;
byte	j;

    for( i = 0; i < 256; i++ )
    {
	mTab2Counter[i] = 0;
	mTab2[i][0] = 0;
    }

    for( i = 0; i < 256; i++ )
    {
	prod = i*INVCONST;
	mulTab[i] = prod;
	j = (prod>>24)&0xff;
	mTab2[j][mTab2Counter[j]++] = i;
	mTab2[j][mTab2Counter[j]] = 0;
	if( mTab2Counter[j] > 14 )
	    fprintf( stderr, "Error! Inverse mTab too small!\n" );
    }
}
