/*
This program is distributed in the hope that it will be useful,
but without any warranty; without even the implied warranty of
merchantability or fitness for a particular purpose. You use
this program at your own risk. The author disclaims responsibility for
any damages that might result from the use of this program, even
if they result from negligence on the part of the author.

Also, please don't use this program to steal software. The intended
use is for emergency situations where an application has to be moved from
one computer to another (e.g. in the event of a hardware malfunction)
and licence keys cannot be obtained quickly from the vendor. Many
vendors will not supply licence keys outside of business hours.
*/

#include <sys/param.h>
#include <sys/syscall.h>
#include <sys/systm.h>
#include <sys/user.h>
#include <sys/kernel.h>
#include <sun/vddrv.h>
#include "hid_flags.h"

#define NHOSTID 10

static unsigned hostid[NHOSTID]={0};
static char xhostname[NHOSTID][MAXHOSTNAMELEN];
static int hid_flags[NHOSTID];

int sethostid();
int gethostname();

static struct sysent sethostid_sysent = { 5, sethostid } ;

static struct vdlsys vd = {
  VDMAGIC_SYS, /* magic number */
  "sethostid", /* name */
  0, /* syscall number (filled in automagically) */
  &sethostid_sysent /* description of syscall */
};

Gethostid()
{
    unsigned machineid;
    u_short gid;
    int i;

    gethostid();
    machineid = u.u_r.r_val1;

    gid = u.u_gid;
    if (gid >= 900 && gid < 900+NHOSTID) {
        if (hid_flags[gid-900] & HID_HOSTID) {
            u.u_r.r_val1 = hostid[gid-900] ? hostid[gid-900] : machineid;
            return;
        }
    }

    i = 0;
    while (gid=u.u_groups[i++]) {
        if (gid >= 900 && gid < 900+NHOSTID) {
            if (hid_flags[gid-900] & HID_HOSTID) {
                u.u_r.r_val1 = hostid[gid-900] ? hostid[gid-900] : machineid;
                return;
            }
        }
    }
    u.u_r.r_val1 = machineid;
    return;
}

Gethostname(uap)
    register struct a {
        char *namebuf;
        int namebuflen;
    } *uap;
{
    char *hp;
    int hl,i;
    u_short gid;

    gid = u.u_gid;
    hp = hostname;
    hl = hostnamelen;
    if (gid >= 900 && gid < 900+NHOSTID) {
        if (hid_flags[gid-900] & HID_HOSTNAME) {
            hp = xhostname[gid-900]; hl = strlen(xhostname[gid-900]);
        }
    }

    i = 0;
    while (gid=u.u_groups[i++]) {
        if (gid >= 900 && gid < 900+NHOSTID) {
            if (hid_flags[gid-900] & HID_HOSTNAME) {
                hp = xhostname[gid-900]; hl = strlen(xhostname[gid-900]);
            }
        }
    }
    hl++;
    if (hl > uap->namebuflen) 
        hl = uap->namebuflen;
    if (copyout(hp, uap->namebuf, hl) < 0) {
         u.u_r.r_val1 = (-1); u.u_error = EFAULT; return;
    }
    u.u_r.r_val1 = 0;
    u.u_error = 0;
    return;
}

sethostid(uap)
    register struct a {
        int n;
        int flags;
        char *hostname;
        int hostnamelen;
        unsigned hostid;
    } *uap;
{
    if (!suser()) {
        u.u_r.r_val1 = (-1); u.u_error = EACCES; return;
    }

    if ((uap->n >= NHOSTID )||(uap->n < 0)) {  
        u.u_r.r_val1 = (-1); u.u_error = EINVAL; return;
    }

    hid_flags[uap->n] = uap->flags;
    if (uap->flags & HID_HOSTID) {
        hostid[uap->n] = uap->hostid;
    }
    if (uap->flags & HID_HOSTNAME) {
        if (uap->hostnamelen >= MAXHOSTNAMELEN || uap->hostnamelen < 0) {
            u.u_r.r_val1 = (-1); u.u_error = EINVAL; return;
        }
        if ((copyin(uap->hostname,xhostname[uap->n],uap->hostnamelen) < 0)) {
            u.u_r.r_val1 = (-1); u.u_error = EFAULT; return;
        }
        xhostname[uap->n][uap->hostnamelen] = '\0'; /* null terminate */
    }
    u.u_r.r_val1 = 0;
    u.u_error = 0;
    return;
}


sethostidinit(function_code, vdp, vdi, vds)
unsigned int function_code;
struct vddrv *vdp;
addr_t vdi;
struct vdstat *vds;
{
  int i;
  switch (function_code) {
  case VDLOAD:
    vdp->vdd_vdtab = (struct vdlinkage *)&vd;
    sysent[SYS_gethostid].sy_narg = 2;
    sysent[SYS_gethostid].sy_call = Gethostid;
    sysent[SYS_gethostname].sy_narg = 2;
    sysent[SYS_gethostname].sy_call = Gethostname;
    for (i=0; i<NHOSTID; i++) {
        xhostname[i][0] = '\0';
        hostid[i] = 0x0;
        hid_flags[i] = 0;
    }
    return 0;
  case VDUNLOAD:
    sysent[SYS_gethostname].sy_narg = 2;
    sysent[SYS_gethostname].sy_call = gethostname;
    sysent[SYS_gethostid].sy_narg = 2;
    sysent[SYS_gethostid].sy_call = gethostid;
    return 0;
  case VDSTAT:
    return 0;
  default:
    return EIO;
  }
}

