/* 
 * run a program with a group from the range 900,...,909 added to the
 *   group list
 * Mark Henderson <mch@squirrel.com>
 * 11 Aug 1994 
 * e.g.
 *  run 0 hostid
 * executes hostid with group 900 added to the group list
 *
 * must be installed setuid root. I recommend 4755 or 4711 for the
 *  permissions
 */


#include <unistd.h>
#include <limits.h>
#include <stdio.h>
#include <sys/types.h>

#ifdef SOLARIS2
#define GID_T gid_t
#else
#define GID_T int 
#endif
  /* should be gid_t for Solaris 2, but it really doesn't matter */

GID_T grouplist[NGROUPS_MAX];
#define NHOSTID 10
main(argc,argv)
int argc;
char *argv[];
{
    int i,j;

    if (argc < 3) {
        fprintf(stderr, "usage: run <int> command\n");
        exit(1);
    }
    
    i = getgroups(NGROUPS_MAX, grouplist);
#ifdef DEBUG
    for (j=0; j< i ; j++)
        fprintf(stderr, "%d\n", grouplist[j]);
#endif
    grouplist[i] = (GID_T)(atoi(argv[1]) + 900);
    if (grouplist[i] < 900 || grouplist[i] >= NHOSTID + 900) {
        fprintf(stderr, "usage: run <int> command\n<int> is out of range\n");
        exit(1);
    }

    if (i >= NGROUPS_MAX) {
        fprintf(stderr, "already in NGROUPS_MAX groups\n");
        exit(1);
    }
    i = setgroups(i+1, grouplist);
    if (i < 0) {
        fprintf(stderr, "setgroups failed\n");
        exit(1);
    }
    seteuid(getuid());
    execvp(argv[2], argv+2);
}
