/* modify hostid reported by gethostid and sysinfo for Solaris 2.3 
   dynamically linked binaries 
Basically a simpler version of sidump.c - this one doesn't have hooks for
   the HID environment variable. 
Placed in the public domain by the author 
Mark Henderson - mch@squirrel.com - 8 July 1994

This program is distributed in the hope that it will be useful,
but without any warranty; without even the implied warranty of
merchantability or fitness for a particular purpose. You use
this program at your own risk. The author disclaims responsibility for
any damages that might result from the use of this program, even
if they result from negligence on the part of the author.

Also, please don't use this program to steal software. The intended
use is for emergency situations where an application has to be moved from
one computer to another (e.g. in the event of a hardware malfunction)
and licence keys cannot be obtained quickly from the vendor. Many
vendors will not supply licence keys outside of business hours.

Instructions:
1. compile this program
    gcc -o sidump sidump_old.c
2. run it with the desired hostid as the first parameter and save the output
    in a file with the extension .c 
    ./sidump b0b1fb0b >foo.c
3. make foo.o from foo.c
      gcc -fpic -c foo.c
      ld foo.o  -G -o foo.so
4. export LD_PRELOAD=$PWD/foo.so      (ksh)
   setenv LD_PRELOAD $PWD/foo.so      (csh)
5. run the desired program

(Note: it actually seems enough to do the following in 3/4:
gcc -c foo.c
export LD_PRELOAD=$PWD/foo.o
)

here's a sample session:

ratatosk> gcc -o sidump sidump_old.c
ratatosk> ./sidump b0b1fb0b >foo.c
ratatosk> gcc -fpic -c foo.c
ratatosk> ld foo.o  -G -o foo.so
ratatosk> export LD_PRELOAD=$PWD/foo.so
ratatosk> hostid
b0b1fb0b
ratatosk> lmhostid
lmhostid - Copyright (C) 1989, 1991 Highland Software, Inc.
The FLEXlm host ID of this machine is "b0b1fb0b"

You could wrap this in a script for convenience (q.v. newhostid)
       Solaris 1.1)

*/


#include <stdio.h>
#include <sys/systeminfo.h>
int commands[] = {SI_HW_SERIAL, SI_SYSNAME,SI_HOSTNAME,
 SI_RELEASE,SI_VERSION,SI_MACHINE,SI_ARCHITECTURE,SI_HW_PROVIDER,
 SI_SRPC_DOMAIN};

#define NCOMMANDS (sizeof(commands)/sizeof(int))

main(argc,argv)
int argc;
char *argv[];
{
    int i,j;
    char buf[1024];
    unsigned int hostid;
    if (argc != 2) {
        fprintf(stderr, "usage: %s hostid\n", argv[0]);
        exit(1);
    }
    sscanf(argv[1], "%x", &hostid);
    printf("#include <string.h>\n");
    printf("gethostid() { return 0x%08x; }\n", hostid);
    printf("long sysinfo(command,buf,count)\nint command;\nchar *buf;\n");
    printf("long count;\n{\nchar *c = buf;\n");
    printf("switch(command) { \n");
    printf("case %u:\n", commands[0]);
    sprintf(buf,"%u",hostid);
    for (j=0; j < strlen(buf); j++)
        printf("if (c < (buf + count)) *c++ = '%c';\n", buf[j]);
    printf("if (c < (buf + count)) *c++ = 0;\n");
    printf("buf[count-1] = 0;\n");
    printf("break;\n");
    for (i=1; i< NCOMMANDS; i++) {
        sysinfo(commands[i], buf,1024);
        printf("case %u:\n", commands[i]);
        for (j=0; j < strlen(buf); j++)
            printf("if (c < (buf + count)) *c++ = '%c';\n", buf[j]);
        printf("if (c < (buf + count)) *c++ = 0;\n");
        printf("buf[count-1] = 0;\n");
        printf("break;\n");
    }
    printf("default: \nreturn(-1); \n}\n");
    printf("return(strlen(buf) + 1);}\n");
	return(0);
}
