/*
C and assembly code for NewDES encryption/decryption.
W. Ware, 3 Nov 94
*/

typedef unsigned char byte;
#define BUFFER_SIZE 24
byte key[15], key_unrav[60], buffer[BUFFER_SIZE];

/* ----------------------------------------------------------------------- */
#ifdef RUN_ON_PC
#include "stdio.h"
#include "time.h"
clock_t start, end;
long L;
int waves;
/* ----------------------------------------------------------------------- */
#else /* RUN_ON_PC */
int c_stack[40];
int L;
/* When compiled with my version of FUNC.ASM for the TI DSK board,
 * the "waves" variable switches between sine waves and PRNG static
 * coming out the audio output. Here, it is set up here to do sine
 * waves during encryption and noise during decryption.
 *
 * When compiling for the PC, it's a dummy variable.
 */
extern int waves;
#endif /* RUN_ON_PC */
/* ----------------------------------------------------------------------- */

/* ----------------------------------------------------------------------- */
#ifdef INCLUDE_C
    #ifdef RUN_ON_PC
    static byte rotor[] =
        {
         32, 137, 239, 188, 102, 125, 221,  72,
        212,  68,  81,  37,  86, 237, 147, 149,
         70, 229,  17, 124, 115, 207,  33,  20,
        122, 143,  25, 215,  51, 183, 138, 142,
        146, 211, 110, 173,   1, 228, 189,  14,
        103,  78, 162,  36, 253, 167, 116, 255,
        158,  45, 185,  50,  98, 168, 250, 235,
         54, 141, 195, 247, 240,  63, 148,   2,
        224, 169, 214, 180,  62,  22, 117, 108,
         19, 172, 161, 159, 160,  47,  43, 171,
        194, 175, 178,  56, 196, 112,  23, 220,
         89,  21, 164, 130, 157,   8,  85, 251,
        216,  44,  94, 179, 226,  38,  90, 119,
         40, 202,  34, 206,  35,  69, 231, 246,
         29, 109,  74,  71, 176,   6,  60, 145,
         65,  13,  77, 151,  12, 127,  95, 199,
         57, 101,   5, 232, 150, 210, 129,  24,
        181,  10, 121, 187,  48, 193, 139, 252,
        219,  64,  88, 233,  96, 128,  80,  53,
        191, 144, 218,  11, 106, 132, 155, 104,
         91, 136,  31,  42, 243,  66, 126, 135,
         30,  26,  87, 186, 182, 154, 242, 123,
         82, 166, 208,  39, 152, 190, 113, 205,
        114, 105, 225,  84,  73, 163,  99, 111,
        204,  61, 200, 217, 170,  15, 198,  28,
        192, 254, 134, 234, 222,   7, 236, 248,
        201,  41, 177, 156,  92, 131,  67, 249,
        245, 184, 203,   9, 241,   0,  27,  46,
        133, 174,  75,  18,  93, 209, 100, 120,
         76, 213,  16,  83,   4, 107, 140,  52,
         58,  55,   3, 244,  97, 197, 238, 227,
        118,  49,  79, 230, 223, 165, 153,  59,
        };

    #define lookup_rotor(c)  rotor[c]
    #endif /* RUN_ON_PC */
#define setup_rotor()
#define single_operation(x,y,dest) dest ^= lookup_rotor((x)^(y))

byte * nblock(byte *buf)
    {
    byte b0, b1, b2, b3, b4, b5, b6, b7;
    byte *kptr;
    int i;

    b0 = *buf++; b1 = *buf++; b2 = *buf++; b3 = *buf++;
    b4 = *buf++; b5 = *buf++; b6 = *buf++; b7 = *buf++;
    buf -= 8;

    kptr = &key_unrav[0];
    for (i = 0; i < 8; i++)
        {
        single_operation(*(kptr++), b0, b4);
        single_operation(*(kptr++), b1, b5);
        single_operation(*(kptr++), b2, b6);
        single_operation(*(kptr++), b3, b7);

        single_operation(*(kptr++), b4, b1);
        single_operation(b4,        b5, b2);
        single_operation(*(kptr++), b6, b3);
        single_operation(*(kptr++), b7, b0);
        }

    single_operation(*(kptr++), b0, b4);
    single_operation(*(kptr++), b1, b5);
    single_operation(*(kptr++), b2, b6);
    single_operation(*(kptr++), b3, b7);

    *buf++ = b0; *buf++ = b1; *buf++ = b2; *buf++ = b3;
    *buf++ = b4; *buf++ = b5; *buf++ = b6; *buf++ = b7;
    return buf;
    }
/* ----------------------------------------------------------------------- */
#else /* INCLUDE_C */
extern byte lookup_rotor(byte);
extern void setup_rotor(void);
extern byte * nblock(byte *);
#endif /* INCLUDE_C */
/* ----------------------------------------------------------------------- */

void newdes_set_key_encipher(void)
    {
    byte *p, *q = &key_unrav[0];
    int i = 4, j;

    while (i--)
        for (p = key, j = 15; j--; ) *(q++) = *(p++);
    }

void newdes_set_key_decipher(void)
    {
    byte *q = &key_unrav[0];
    int i = 4, j = 11;

    while (1)
        {
        *(q++) = key[j++];
        if (j == 15) j = 0;
        *(q++) = key[j++];
        if (j == 15) j = 0;
        *(q++) = key[j++];
        if (j == 15) j = 0;
        *(q++) = key[j];
        j += 9;
        if (j >= 15) j -= 15;
        /* j = (j + 9) % 15; */
        if (j == 12) break;
        *(q++) = key[j++];
        *(q++) = key[j++];
        *(q++) = key[j];
        j += 9;
        if (j >= 15) j -= 15;
        /* j = (j + 9) % 15; */
        }
    }

void main(void)
    {
    int i;
    byte *p;
    #ifdef RUN_ON_PC
    int j;
    #endif /* RUN_ON_PC */

    setup_rotor();

    for (i = 0; i < BUFFER_SIZE; i++)
        buffer[i] = (byte) i;

    for (i = 0; i < 15; i++)
        key[i] = (byte) i;

    #ifndef RUN_ON_PC
    while (1)
    #endif /* RUN_ON_PC */
        {
        waves = 1;
        newdes_set_key_encipher();

        #ifdef RUN_ON_PC
        start = clock();
        #endif /* RUN_ON_PC */

        p = &buffer[0];
        p = nblock(p);
        p = nblock(p);
        for (L = BLOCKS - 2; L--; ) nblock(p);

        #ifdef RUN_ON_PC
        end = clock() - start;
        for (i = 0; i < 16; i++) printf("%02X  ", buffer[i] & 0xFF);
        printf("\n");
        for (i = 0; i < 16; i++) printf("%-3d ", buffer[i] & 0xFF);
        printf("\n");
        for (i = 0; i < 40; i++) printf("-");
        printf("\n");
        #endif /* RUN_ON_PC */

        waves = 0;
        newdes_set_key_decipher();

        #ifdef RUN_ON_PC
        start = clock();
        #endif /* RUN_ON_PC */

        p = &buffer[0];
        p = nblock(p);
        p = nblock(p);
        for (L = BLOCKS - 2; L--; ) nblock(p);

        #ifdef RUN_ON_PC
        end += clock() - start;
        for (i = 0; i < 16; i++) printf("%02X  ", buffer[i] & 0xFF);
        printf("\n");
        for (i = 0; i < 16; i++) printf("%-3d ", buffer[i] & 0xFF);
        printf("\n");
        for (i = 0; i < 40; i++) printf("-");
        printf("\n");
        /* Compute elapsed time in milliseconds */
        L = (long) (end * 1000.0 / CLOCKS_PER_SEC);
        i = (int) (L / 1000);
        j = (int) (L % 1000);
        printf("%d.%03d seconds", i, j);
        if (L != 0)
            printf(" ==> %.0lf bytes per second",
                (1000.0 * 16.0 * BLOCKS) / L);
        printf("\n");
        #endif /* RUN_ON_PC */
        }
    }
