(*

   A demo program which samples a given number of bytes from the
   /dev/random driver and writes them to a file.

   Turbo Pascal specifics: the only way I know of the read from a
   character device in binary mode is to use the inline assembler
   code below (Turbo Pascal 7.0+, for earlier versions you'll have
   to assemble by hand and use the inline directive).

*)

{$G+}
program Sample;

  function OpenRand(var f: File): Word;
  { this could be adapted to take any device name, such as CON or COM1 }
    assembler;
  { Turbo Pascal has problems with Unix-style pathnames like /dev/random }
  const NoiseDevice: String[7] = '\dev\random'#0;
       asm
            lea  DX, NoiseDevice[1]
{ ds register is already set to right placer here }
            mov  AX, 3D80h
            Int  21h
            jnc  @ok
       @err:
            xor  AX,AX
            jmp  @quit
       @ok:
            les  BX, f
            mov  ES:[BX], AX     { save file handle }
            
            mov  BX, AX          { put file into binary mode }
            mov  AX, 4400h       { get device info }
            Int  21h
            jc   @err
            and  DX, 00FFh
            or   DX, 0020h       { "raw" mode }
            mov  AX, 4401h       { set device info }
            Int  21h
            jc   @err
            mov  AX, BX
       @quit:            
       end;
       
  procedure CloseRand(var f:File);
    assembler;
  asm
       les  BX, f
       mov  BX, ES:[BX]
       mov  AH, 3Eh
       Int  21h
  end;

  function GetRand(var f: File; var block; req: Word): Word;
    assembler;
  asm
       push  DS
       lds   BX, f
       mov   BX, DS:[BX]
       mov   CX, req
       lds   DX, block
       mov   AH, 3Fh
       Int   21h
       jnc   @ok
       xor   AX, AX
  @ok:
       pop   DS
  end;

const
     SIZE = 8192;  { buffer size }
var
     num: LongInt;
     i,j: Word;
     e: Integer;
     buff: array[0..(SIZE-1)] of Byte;
     randstream, ofile: File;
begin
     if ParamCount<>2
     then WriteLn('usage: sample file num'#13#10+
          'example: sample randseed.bin 64')
     else begin
          if (OpenRand(randstream)=0) { open random device in binary mode }
          then WriteLn('error opening /dev/random')
          else begin
               Assign(ofile,ParamStr(1));
               Rewrite(ofile,1);
               Val(ParamStr(2),num,e);
               WriteLn('creating file '+ParamStr(1)+' of ',num,' bytes.');
               repeat
                    if SIZE>num then i := num else i := SIZE;
                    { get i random bytes into buffer }
                    i:=GetRand(randstream,buff,i);
                    if i<>0 then BlockWrite(ofile,buff,i,j);
                    num := num-j;
               until num=0;
               CloseRand(randstream);
               Close(ofile);
          end
     end
end.
