/*

   A demo program which samples a given number of bytes from the
   /dev/random driver and writes them to a file.

*/
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#ifdef __MSDOS__
  #define SIZE 8192             /* size of buffer */
#else
  #define SIZE 1024
#endif

void main(int argc, char *argv[]) {

  FILE *randstream, *ofile;
  unsigned long num;
  int bytesread,needed;
  static char buff[SIZE], *ofname;

  if (argc<3) {
    fprintf(stderr, "usage: sample file num\n"
                  "example: sample randseed.bin 64\n"
                  "Reads num bytes from /dev/random and writes to file\n");
/* -------------------------------------------------------------------------
   WARNING: This doesn't check if a file exists already, so it's very
   possible to overwrite a file out of carelessness!
-------------------------------------------------------------------------- */
    return(1);
  }
  else {
    ofname=argv[1];
   /* ----- open random stream in binary mode ----- */
    if ((randstream=fopen("/dev/random","rb"))<0) {
      fprintf(stderr, "error opening /dev/random\n");
      return(1);
    } else if ((ofile=fopen(ofname,"wb"))<0) { 
        fprintf(stderr, "unable to create file %s\n", ofname);
        return(1);
    } else {
      num=0;
      sscanf(argv[2], "%ld", &num);
      fprintf(stderr, "creating file %s of %ld bytes\n", ofname, num);
      for(;;) {
        needed=(SIZE>num)?(needed=num):(needed=SIZE);
   /* ----- read bytes from the random stream ----- */
        if ((bytesread=fread(&buff, 1, needed, randstream))!=0) {
          num-=fwrite(&buff, 1, bytesread, ofile);
          if (num==0) break;
        } else {
          fprintf(stderr, "error reading from /dev/random "
                  "(device may not be loaded)\n");

       /* note: sometimes this will be successful and read meaningless
          garbage when the driver is not loaded, at least that is what
          happened sometimes while testing this... */

          exit(EXIT_FAILURE);
        }
      }
      fclose(ofile);
      exit(EXIT_SUCCESS);
    }
  }
}

