#ifndef SPH
#define SPH

/*	Copyright (C) 1992 Free Software Foundation, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this software; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
/*  t. lord	Thu Oct  8 00:07:26 1992	*/

#include "basics.h"

typedef int (*sp_comparer) P_((void * a, void * b));

struct sp_tree_node 
{
  void * key;
  void * data;
  struct sp_tree_node * kids[2];
};

struct sp_tree
{
  struct sp_tree_node * root;
  sp_comparer cmp;
};


typedef void (*sp_key_data_freer) P_((struct sp_tree_node *));
typedef void (*sp_popularity_notify) P_((int, struct sp_tree_node *,
					    void *));
extern struct sp_tree * sp_tree P_((sp_comparer));
extern struct sp_tree_node * sp_tree_find P_((struct sp_tree *,
						    void * key));
extern struct sp_tree_node * sp_tree_make P_((struct sp_tree *,
						    void * key));
extern struct sp_tree_node * sp_tree_find2 P_((struct sp_tree *,
						     void * key,
						     sp_popularity_notify,
						     void *));
extern struct sp_tree_node * sp_tree_make2 P_((struct sp_tree *,
						     void * key,
						     sp_popularity_notify,
						     void *));
extern void sp_tree_remove P_((struct sp_tree *, void *key));
extern void free_sp_tree P_((struct sp_tree *, sp_key_data_freer));


#endif

