/* Logic for handling backslashed in string literals. */
#ifndef YIELD_CHAR
#define YIELD_CHAR(ch) return ch
#endif

    int ch, d, i;
    GET_NEXT(ch);
    switch (ch) {
      case 0: case -2:
      case EOF:
	YIELD_CHAR(EOF);
#ifndef NO_HANDLE_CONTINUATION
      case ' ': case '\n': case '\t': /*Skip white space upto and after '\n' */
	i = ch == '\n'; /* i == 1 if '\n' has been seen */
	for (;;) {
	    GET_NEXT(ch);
	    if (ch == EOF) YIELD_CHAR(EOF);
	    if (ch == '\n')
		if (i) {YIELD_CHAR(ch);}
		else i = 1;
	    else if (ch != ' ' && ch != '\t')
		YIELD_CHAR(ch);
	}
#endif
      case '\\':
	YIELD_CHAR('\\');	/* '\' itself */
      case 'b':
	YIELD_CHAR('\b');	/* back-space */
      case 't':
	YIELD_CHAR('\t');	/* horizontal tab */
      case 'E':
	/* -allow \E, since termcap does */
      case 'e':
	YIELD_CHAR('\033');	/* escape */
      case 'd':			/* (Used in Icon language.) */
      case '?':
	YIELD_CHAR(127);	/* rub-out */
      case 'r':
	YIELD_CHAR('\r');	/* carriage return */
      case 'l':			/* (Used in Icon language.) */
      case 'n':
	YIELD_CHAR('\n');	/* line feed */
      case 'f':
	YIELD_CHAR('\f');	/* form feed */
      case 'v':
#ifdef __STDC__
	YIELD_CHAR('\v');	/* vertical tab; */
#else
	YIELD_CHAR(013);	/* vertical tab; */
#endif
      case 'a':
#ifdef __STDC__
	YIELD_CHAR('\a');	/* alarm (bell) */
#else
	YIELD_CHAR(7);		/* alarm (bell) */
#endif
#if 0
      case 'q':				/* quote */
	GET_NEXT(ch);
	if (ch == EOF) YIELD_CHAR('q'));
	YIELD_CHAR(ch);
#endif
      case '^':				/* ^a etc */
	GET_NEXT(ch);
	if (ch == EOF) YIELD_CHAR('^');
	YIELD_CHAR(ch & 037);
      case 'x':
	GET_NEXT(ch);			/* get 1st hex digit */
	if (ch < 0) YIELD_CHAR('^');
	d = GetNonDecimal(ch, 16);
	if (d < 0) {
	    UNDO_CHAR(ch);
	    YIELD_CHAR('x');
	}
	i = d;
	for (;;) {
	    GET_NEXT(ch);		/* get 2nd hex digit */
	    d = GetNonDecimal(ch, 16);
	    if (d < 0) {
		UNDO_CHAR(ch);
		YIELD_CHAR(i);
	    }
	    i <<= 4;
	    i += d;
	}
      default:
	if (ch < '0' || ch > '7')
#ifdef NO_BACKSLASH_DEFAULT
            YIELD_CHAR(-2);
#else
	    YIELD_CHAR(ch);
#endif
	i = ch - '0';
	GET_NEXT(ch);		/* get 2nd octal digit */
	if (ch < '0' || ch > '7') {
	    UNDO_CHAR(ch);
	    YIELD_CHAR(i);
	}
	i <<= 3;
	i += ch - '0';
	GET_NEXT(ch);		/* get 3rd octal digit */
	if (ch < '0' || ch > '7') {
	    UNDO_CHAR(ch);
	    YIELD_CHAR(i);
	}
	i <<= 3;
	i += ch - '0';
	YIELD_CHAR(i);
    }
