/*  Hey Emacs, switch to -*-C-*-, please 
------------

Copyright (C) 1997 Tage Stabell-Kul (tage@acm.org).  All rights
reserved.

This is a package, containing a library, that makes it possible for
programmers to include security functionality in their programs, in a
format compatible with PGP.

This library is free for commercial and non-commercial use as long as
the following conditions are aheared to:

Copyright remains Tage Stabell-Kul's, and as such any Copyright
notices in the code are not to be removed.
If this package is used in a product, Tage Stabell-Kul should be given
attribution as the author of the parts of the library used.
This can be in the form of a textual message at program startup or
in documentation (online or textual) provided with the package.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:
   "This product includes software written by
    Tage Stabell-Kul (tage@acm.org)"

THIS SOFTWARE IS PROVIDED BY TAGE STABELL-KUL ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The licence and distribution terms for any publically available
version or derivative of this code cannot be changed.  i.e. this code
cannot simply be copied and put under another distribution licence
[including the GNU Public Licence.]

The reason behind this being stated in this direct manner is past
experience in code simply being copied and the attribution removed
from it and then being distributed as part of other packages. This
implementation was a non-trivial and unpaid effort.
*/


/* We try to read in a packet from a file.  Some special handling is
 * required.  Returns are:
 *	 0: OK.
 * 	 1: No good PGP packet _or_ CTB_COMPRESSED_TYPE.  
 *	-1: Some error.  The file is advanced to where the error occurred 
 *	       	(more or less).
 * 
 * This code is very similar to packet_length; can't be helped.
 */


#include "pgplib.h"
#include "pgp_m.h"

int
read_packet(FILE	*fd,
	    int		*length,
	    u_char	**packet)
{
    u_char	*buf;
    int		howfar;
    fpos_t	pos;
    int		ll;
    int		i;
    int		p_len;
    u_long	ul;
    u_short	us;
    u_char	*p;

    fgetpos(fd, &pos);
    buf = malloc(1);
    if ( buf == NULL ) {
	fprintf(stderr, "Out of memory\n");
	return(-1);
    }
    howfar = 0;

    i = fread(buf, 1, 1, fd);
    if ( i != 1 ) {
	free(buf);
	if ( feof(fd) == 0 )
	    return(-1);
	else
	    return(1);
    }
    if ( ! is_ctb(buf[0]) || is_ctb_type(buf[0], CTB_COMPRESSED_TYPE) ) {
	ungetc(*buf, fd);
	free(buf);
	if ( feof(fd) == 0 )
	    return(-1);
	else
	    return(1);
    }

    howfar += 1;

    ll = ctb_llength(buf[0]);
    p = realloc(buf, howfar+ll);
    if ( p == NULL ) {
	free(buf);
	fprintf(stderr, "Out of memory\n");
	return(-1);
    }
    buf = p;

    p_len = 0;
    switch (ll) {
    case 1:
	p_len = 0;
	i = fread( buf+howfar, 1, 1, fd);
	if ( i != 1 ) {
	    free(buf);
	    fsetpos(fd, &pos);
	    if ( feof(fd) == 0 )
		return(-1);
	    else
		return(1);
	}
	p_len = (int)*(buf+howfar);
	howfar += 1;
	break;
    case 2:
	i = fread(&us, 2, 1, fd);
	if ( i != 1 ) {	
	    fsetpos(fd, &pos);
	    free(buf);
	    if ( feof(fd) == 0 )
		return(-1);
	    else
		return(1);
	}
	p_len = (int)ntohs(us);
	memcpy(buf+howfar, &us, 2);
	howfar += 2;
	break;
    case 4:
	i = fread(&ul, 4, 1, fd);
	if ( i != 1 ) {	
	    fsetpos(fd, &pos);
	    free(buf);
	    if ( feof(fd) == 0 )
		return(-1);
	    else
		return(1);
	}
	p_len = (int)ntohl(ul);
	memcpy(buf+howfar, &ul, 4);
	howfar += 4;
	break;
    default:
	fsetpos(fd, &pos);
	free(buf);
	break;
    }
    if ( p_len == 0 )
	return(1);

    p = realloc(buf, howfar + p_len);
    if ( p == NULL ) {
	free(buf);
	fsetpos(fd, &pos);
	fprintf(stderr, "Out of memory\n");
	return(-1);
    }
    buf = p;

    i = fread(buf+howfar, p_len, 1, fd);
    if ( i != 1 ) {
	fsetpos(fd, &pos);
	free(buf);
	if ( feof(fd) == 0 )
	    return(-1);
	else
	    return(1);
    }

    *length = howfar + p_len;
    *packet = buf;
    return(0);
}


/* We try to copy a packet from a buffer.  Some special handling is
 * required.  Returns are:
 *	 0: OK.
 * 	 1: No PGP packet _or_ CTB_COMPRESSED_TYPE.  
 *	-1: Some error.
 *
 */

int
find_packet_in_buffer(u_char	*buffer,
		      int	buf_len,
		      u_char	**packet,
		      int	*p_len)
{

    int	ll;

    if ( buffer == NULL || buf_len < 3 )
	return(-1);

    if ( ! is_ctb(buffer[0]) || is_ctb_type(buffer[0], CTB_COMPRESSED_TYPE) )
	return (1);

    ll = ctb_llength(buffer[0]);
    if ( ll + 1 >= buf_len) 
	return(1);

    *p_len = packet_length(buffer);
    if ( *p_len > buf_len ) {
	*p_len = 0;
	return(1);
    }

    *packet = calloc(1, *p_len);
    if ( *packet == NULL ) {
	fprintf(stderr, "Out of memory\n");
	return(-1);
    }
    
    memcpy(*packet, buffer, *p_len);
    return(0);
}
