/*
------------

Copyright (C) 1997 Tage Stabell-Kul (tage@acm.org).  All rights
reserved.

This is a package, containing a library, that makes it possible for
programmers to include security functionality in their programs, in a
format compatible with PGP.

This library is free for commercial and non-commercial use as long as
the following conditions are aheared to:

Copyright remains Tage Stabell-Kul's, and as such any Copyright
notices in the code are not to be removed.
If this package is used in a product, Tage Stabell-Kul should be given
attribution as the author of the parts of the library used.
This can be in the form of a textual message at program startup or
in documentation (online or textual) provided with the package.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:
   "This product includes software written by
    Tage Stabell-Kul (tage@acm.org)"

THIS SOFTWARE IS PROVIDED BY TAGE STABELL-KUL ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The licence and distribution terms for any publically available
version or derivative of this code cannot be changed.  i.e. this code
cannot simply be copied and put under another distribution licence
[including the GNU Public Licence.]

The reason behind this being stated in this direct manner is past
experience in code simply being copied and the attribution removed
from it and then being distributed as part of other packages. This
implementation was a non-trivial and unpaid effort.

*/

    /* ZIP, as snipped out from PGP, uses files rather than memory buffers 
     * to store data.  I would have liked to rewrite ZIP to use buffers,
     * but not today.
     *
     *
     * NOTE that these routines leaves private data on disk.
     *
     *
     */


#include <stdio.h>
#include <stdlib.h>
#include <sys/errno.h>

#include "pgplib.h"
#include "pgp_m.h"

#include "../pgpzip/zunzip.h"
#include "../pgpzip/zip.h"

int
decompress_buffer(u_char	*buf,
		  int 		buf_len,
		  int		*data_len,
		  u_char 	**data)
{



    FILE 	*tmp1, *tmp2;
    int 	count;
    byte	 alg;
    /* scratch variables */
    int i;

    if ( buf== NULL || buf_len == 0 )
	return(-1);

    if ( ! is_ctb(buf[0]) || ! is_ctb_type(buf[0], CTB_COMPRESSED_TYPE)) {
	fprintf(stderr, "Wrong Type\n");
	return(-1);
    }
    count = 1;

    alg = buf[count];
    count++;

    if (alg != ZIP2_ALGORITHM_BYTE ) {
	fprintf(stderr, "Wrong algorithm\n");
	return(-1);
    }
    
    /* PGP-zip works on files, rather in memory */
    errno = 0;
    tmp1 = tmpfile();
    tmp2 = tmpfile();
    if ( tmp1 == NULL || tmp2 == NULL ) {
	fprintf(stderr, "Error creating tmp\n");
	fclose(tmp1);
	fclose(tmp2);
	return(-1);
    }
    fwrite(buf+count, 1, buf_len - count, tmp1);
    rewind(tmp1);

    i = unzip(tmp1, tmp2);
    if ( i != 0 ) {
	fprintf(stderr, "Error from ZIP\n");
	fclose(tmp1);
	fclose(tmp2);
	return(-1);
    }
    fclose(tmp1);

    fseek(tmp2, 0L, SEEK_END);
    *data_len = ftell(tmp2);
    *data = malloc(*data_len);
    if ( *data == NULL ) {
	fprintf(stderr, "Out of memory on %s:%d\n", __FILE__, __LINE__);
	fclose(tmp1);
	fclose(tmp2);
	return(-1);
    }
    rewind(tmp2);
    i = fread(*data, *data_len, 1, tmp2);
    if ( i != 1 ) {
	fprintf(stderr, "Error reading\n");
	fclose(tmp2);
	free(*data);
	*data = NULL;
	return(-1);
    }
    fclose(tmp2);
    
    return(0);

}

int
decompress_file(FILE	*fin,
		FILE	*fout)
{

    u_char	alg;
    u_char	CTB;
    int		i;



    i  = fgetc(fin);
    if ( i == EOF )
	return(1);

    CTB = (u_char) i;

    if ( ! is_ctb_type(CTB,  CTB_COMPRESSED_TYPE) )
	return(1);

    i  = fgetc(fin);
    if ( i == EOF )
	return(1);
    alg = (u_char) i;

    switch ( alg ) {
    case ZIP2_ALGORITHM_BYTE:
	break;
    default:
	fprintf(stderr, "Unknown compression algorithm\n");
	return(1);
    }
    
    /* PGP-zip works on files, rather in memory */
    i = unzip(fin, fout);
    if ( i != 0 ) {
	fprintf(stderr, "unzip returned %d\n", i);
	return(1);
    }

    return(0);
}


/* **************************************************************
 * Take a buffer, compres it, and create a compressed packet.
 * 
 * This will leave your data in a file in /tmp.  A memory-based 
 * ZIP would be most welcome !
 * ************************************************************** */

int
compress_buffer(u_char	*inbuf,
		int	inbuflen,
		u_char	**outbuf,
		int	*outbuflen)
{
    
    FILE 	*tmp1, *tmp2;
    /* scratch variables */
    int i;

    if ( inbuf == NULL || inbuflen == 0 )
	return(-1);
    *outbuf = NULL;

    tmp1 = tmpfile();
    tmp2 = tmpfile();
    if ( tmp1 == NULL || tmp2 == NULL ) {
	fclose(tmp1);
	fclose(tmp2);
	fprintf(stderr, "Failed to create tmpfiles\n");
	return(-1);
    }
    fwrite(inbuf, 1, inbuflen, tmp1);
    rewind(tmp1);
    if ( (fputc(CTB_COMPRESSED, tmp2) != CTB_COMPRESSED) 
	 || ( fputc(ZIP2_ALGORITHM_BYTE, tmp2) != ZIP2_ALGORITHM_BYTE)) {
	fclose(tmp1);
	fclose(tmp2);
	fprintf(stderr, "Failed to write CTB bytes\n");
	return(-1);
    }

    i = zipup(tmp1, tmp2);
    if ( i != 0 ) {
	/* Data left on disk at this point */
	fclose(tmp1);
	fclose(tmp2);
	fprintf(stderr, "Failed compress proper\n");
	return(-1);
    }
    /* Data is left on disk at this point ! */
    fclose(tmp1);

    fseek(tmp2, 0L, SEEK_END);
    *outbuflen = ftell(tmp2);
    *outbuf = malloc(*outbuflen);
    if ( *outbuf == NULL ) {
	fprintf(stderr, "Out of memory on %s:%d\n", __FILE__, __LINE__);
	fclose(tmp2);
	return(-1);
    }
    rewind(tmp2);
    i = fread(*outbuf, *outbuflen, 1, tmp2);
    if ( i != 1 ) {
	fclose(tmp2);
	free(*outbuf);
	*outbuf = NULL;
	return(-1);
    }
    fclose(tmp2);

    return(0);
}
