/*  Hey Emacs, switch to -*-C-*-, please 

Copyright (C) 1997 Tage Stabell-Kul (tage@acm.org).  All rights
reserved.

This is a package, containing a library, that makes it possible for
programmers to include security functionality in their programs, in a
format compatible with PGP.

This library is free for commercial and non-commercial use as long as
the following conditions are aheared to:

Copyright remains Tage Stabell-Kul's, and as such any Copyright
notices in the code are not to be removed.
If this package is used in a product, Tage Stabell-Kul should be given
attribution as the author of the parts of the library used.
This can be in the form of a textual message at program startup or
in documentation (online or textual) provided with the package.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:
   "This product includes software written by
    Tage Stabell-Kul (tage@acm.org)"

THIS SOFTWARE IS PROVIDED BY TAGE STABELL-KUL ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The licence and distribution terms for any publically available
version or derivative of this code cannot be changed.  i.e. this code
cannot simply be copied and put under another distribution licence
[including the GNU Public Licence.]

The reason behind this being stated in this direct manner is past
experience in code simply being copied and the attribution removed
from it and then being distributed as part of other packages. This
implementation was a non-trivial and unpaid effort.


 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>

#include <pgp_m.h>
#include "pgplib.h"

static char *progname;
void
usage(void)
{
    fprintf(stderr, "usage : %s -f file -n num\n", progname);
    exit(1);
}

int
main(int argc, char *argv[])
{
    
    extern char	*optarg;
    int		ch;
    char	*pp;
    FILE *infile, *outfile;
    int		num;
    int		key_count, file_count;
    int		done;
    char	fname[8];
    u_char	*p_buf;
    int		p_len;
    /* scratch */
    int		i;

    infile = NULL;
    progname = argv[0];
    num = 0;
    while ((ch = getopt (argc, argv, "f:n:")) != -1) {
	switch (ch) {
	case 'f':
	    infile = fopen(optarg, "r");
	    if ( infile == NULL ) {
		perror("fopen");
		exit(1);
	    }
	    break;
	case 'n':
	    i = (int) strtol(optarg, &pp, 10);
	    if ( pp == NULL || *pp != 0)
		usage();
	    num = i;
	    break;
	case '?':
	default:
	    usage();
	}
    }
    if ( num == 0 || fname == NULL )
	usage();

    memset(fname, 0, 8);
    strcpy(fname, "split00");
    outfile = fopen(fname, "w+");
    if ( outfile == NULL ) {
	perror(fname);
	exit(1);
    }

    done = 0;
    file_count = 0;
    key_count  = 0;
    while ( ! done ) {
	i = read_packet(infile, &p_len, &p_buf);
	if ( i != 0 ) {
	    fclose(outfile);
	    if ( feof(infile) )
		exit(0);
	    else {
		fprintf(stderr, "Error reading file\n");
		exit(1);
	    }
	}
	if ( is_ctb_type(*p_buf, CTB_CERT_PUBKEY_TYPE) ) {
	    key_count += 1;
	    if ( key_count % num == 0 ) {
		fclose(outfile);
		fname[5] = file_count / 10 + '0';
		fname[6] = file_count % 10 + '0';
		file_count += 1;
		outfile = fopen(fname, "w+");
		if ( outfile == NULL ) {
		    perror(fname);
		    exit(1);
		}
	    }
	}
	i = fwrite(p_buf, p_len, 1, outfile);
	free(p_buf);
	if ( i != 1 ) {
	    fprintf(stderr, "Error while writing\n");
	    exit(1);
	}
    }
}
