/*  Hey Emacs, switch to -*-C-*-, please 

Copyright (C) 1997 Tage Stabell-Kul (tage@acm.org).  All rights
reserved.

This is a package, containing a library, that makes it possible for
programmers to include security functionality in their programs, in a
format compatible with PGP.

This library is free for commercial and non-commercial use as long as
the following conditions are aheared to:

Copyright remains Tage Stabell-Kul's, and as such any Copyright
notices in the code are not to be removed.
If this package is used in a product, Tage Stabell-Kul should be given
attribution as the author of the parts of the library used.
This can be in the form of a textual message at program startup or
in documentation (online or textual) provided with the package.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:
   "This product includes software written by
    Tage Stabell-Kul (tage@acm.org)"

THIS SOFTWARE IS PROVIDED BY TAGE STABELL-KUL ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The licence and distribution terms for any publically available
version or derivative of this code cannot be changed.  i.e. this code
cannot simply be copied and put under another distribution licence
[including the GNU Public Licence.]

The reason behind this being stated in this direct manner is past
experience in code simply being copied and the attribution removed
from it and then being distributed as part of other packages. This
implementation was a non-trivial and unpaid effort.


 */


#include <sys/types.h>
#include <stdio.h>
#include "pgplib.h"
#include <md5.h>
#include <sys/uio.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <sys/stat.h>

char *Progname;

void
usage()
{
    fprintf(stderr,
	    "usage: %s [-a] -f file -k keyring -p password [-u KeyID]\n", Progname);
    exit(1);
}

void
main(int argc, char *argv[])
{
    int		ch;
    extern char	*optarg;
    FILE	*secring;
    int		infile, outfile;
    char	*filename;
    u_char	passwdhash[16];
    int		digest_ok;
    u_char	*filebuf;
    int		armor;
    u_quad_t	keyid;
    struct stat sbuf;
    PGPseckey_t	*key;
    PGPsig_t	sig;
    int		armor_len, buflen;
    u_char	*sigbuf;
    char	*armor_buf;
    /* scratch */
    int		i, j;

    Progname = argv[0];

    armor = 0;
    secring = NULL;
    filename = NULL;
    outfile = infile = -1;
    digest_ok = 0;
    keyid = 0LL;

    while ((ch = getopt (argc, argv, "ak:f:p:u:")) != -1) {
	switch (ch) {
	case 'a': 
	    armor = 1;
	    break;
	case 'f':
	    i = access(optarg, R_OK);
	    if ( i < 0 ) {
		perror(optarg);
		usage();
	    }
	    infile = open(optarg, O_RDONLY);
	    if ( infile < 0 ) {
		perror(optarg);
		usage();
	    }
	    
	    filename = calloc(1, strlen(optarg) + 4 + 1);
	    if ( filename == NULL ) {
		fprintf(stderr, "Out of memory\n");
		exit(1);
	    }
	    strcpy(filename, optarg);
	    strcat(filename, ".pgp");
	    break;

	case 'k':
	    secring = fopen(optarg, "r");
	    if ( secring == NULL ) {
		perror(optarg);
		usage();
	    }
	    break;

	case 'p':
	    MD5(optarg, strlen(optarg), passwdhash);
	    digest_ok = 1;
	    break;
	case 'u':
	    i = sscanf(optarg, "%qx", &keyid);
	    if ( i != 1 ) {
		fprintf(stderr, "Error in keyid: %s\n", optarg);
		usage();
	    }
	    break;

	case '?':
	default:
	    usage();
	}
    }

    if ( secring == NULL || filename == NULL || digest_ok == 0)
	usage();

    while ( 1 ) {
	i = get_seckey_from_file(secring, &key);
	if ( i != 0 ) {
	    fprintf(stderr, "Could not find secret key\n");
	    exit(1);
	}
	if ( keyid == 0 )
	    break;
	else {
	    if ( keyid != BN_get_keyid(key->N)) 
		continue;
	    else
		break;
	}
    }

    /* If we get here, we're OK */
    
    i = fstat(infile, &sbuf);
    if ( i < 0 ) {
	perror("fstat");
	exit(1);
    }
    filebuf = malloc(sbuf.st_size);
    i = read(infile, filebuf, sbuf.st_size);
    (void) close(infile);

    /* Make the key ready */

    i = decrypt_seckey(key, passwdhash);
    if ( i != 0 ) {
	fprintf(stderr, "Password incorrect\n");
	exit(1);
    }
    memset(&sig, 0, sizeof(sig));
    i = sign_buffer(filebuf, sbuf.st_size, key, &sig);
    if ( i != 0 ) {
	fprintf(stderr, "Could not sign buffer\n");
	exit(1);
    }

    /* convert */
    i = signature2buf(&sig, &sigbuf);
    if ( i == 0 ) {
	fprintf(stderr, "Could not marshall signature\n");
	exit(1);
    }
    /* store */
    outfile = open(filename, O_WRONLY|O_CREAT, 0600);
    if ( outfile < 0 ) {
	perror(filename);
	fprintf(stderr, "Eror open\n");
	usage();
    }

    buflen = packet_length(sigbuf);
    if (armor) {
	i = armor_buffer(sigbuf, buflen, &armor_buf, &armor_len);
	if ( i != 0 ) {
	    fprintf(stderr, "Error armoring\n");
	    close(outfile);
	    unlink(filename);
	    exit(1);
	}
	free(sigbuf);
	sigbuf = armor_buf;
	buflen = armor_len;
    }
    i = write(outfile, sigbuf, buflen);
    if ( i != buflen) {
	fprintf(stderr, "Error writing\n");
	perror(filename);
	exit(1);
    }
    
    exit(0);
}
