/*  Hey Emacs, switch to -*-C-*-, please 

Copyright (C) 1997 Tage Stabell-Kul (tage@acm.org).  All rights
reserved.

This is a package, containing a library, that makes it possible for
programmers to include security functionality in their programs, in a
format compatible with PGP.

This library is free for commercial and non-commercial use as long as
the following conditions are aheared to:

Copyright remains Tage Stabell-Kul's, and as such any Copyright
notices in the code are not to be removed.
If this package is used in a product, Tage Stabell-Kul should be given
attribution as the author of the parts of the library used.
This can be in the form of a textual message at program startup or
in documentation (online or textual) provided with the package.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:
   "This product includes software written by
    Tage Stabell-Kul (tage@acm.org)"

THIS SOFTWARE IS PROVIDED BY TAGE STABELL-KUL ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The licence and distribution terms for any publically available
version or derivative of this code cannot be changed.  i.e. this code
cannot simply be copied and put under another distribution licence
[including the GNU Public Licence.]

The reason behind this being stated in this direct manner is past
experience in code simply being copied and the attribution removed
from it and then being distributed as part of other packages. This
implementation was a non-trivial and unpaid effort.

*/


/* **************************************************************
 * Format: get [0x01234576 | 0x0123456789012345 | foo bar]
 * ************************************************************** */


#include <pgplib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <malloc.h>

#include <assert.h>

extern char Arg[];

void
get_key( int argc, char *argv[])
{
    u_long	short_keyid;
    u_quad_t	key_id, *keyptr;
    int		num_keys;
    int		key_len;
    int		ret;
    char	*string;
    u_char 	*buf;
    int		buflen;
    /* scratch */
    int		i;

    if ( argc != 2 && argc != 3) {
	fprintf(stdout, "[0x12345767 | 0x1234567890123456 | Foo Bar]\n");
	return;
    }

    key_id = 0LL;
    short_keyid = 0L;

    if ( argv[1][0] == '0' && toupper(argv[1][1]) == 'X') {
	key_len = strlen(argv[1]);
	switch ( key_len ) {
	case 10:
	    ret = sscanf(argv[1], "%lx", &short_keyid);
	    break;
	case 18:{

#ifndef __FreeBSD__

	    ret = sscanf(argv[1], "%qx", &key_id);
#else

	    /* 
	     * arrrggghhhh.... this is FreeBSD
	     *
	     * We have verified that the string starts with 0[Xx], let us 
	     * discard two char's.  Then loop over the string ensuring
	     * the all chars are [0-9a-fA-F], then assign them two
	     * and two into a byte.
	     */
	    key_id = atoq(argv[1]);
	    assert(key_id != 0);
#endif

	    break;
	}
	default:
	    ret = 0;
	    break;
	}

	if ( ret != 1 ) {
	    fprintf(stdout, 
		    "[0x01234576 | 0x0123456789012345 | FooBar]\n");
	    return;
	}
	if ( short_keyid != 0 ) {
	    fprintf(stdout, "No short keys yet\n");
	    return;
	}
	i = get_pub_key_record(key_id, &buf, &buflen);
	switch ( i ) {
	case -1:
	    fprintf(stdout, "Some error\n");
	    return;
	case 1:
	    fprintf(stdout, "No (correct) key found\n");
	    return;
	case 0:
	    break;
	default:
	    assert(0);
	}
	/* Print what we found */
	print_keyrecords(buf, buflen, stdout);
	
	return;
    }
    else {
	/* 
	 * Start at the beginning of the command.  Skip the first word
	 * and any following white space.  Take it from there.
	 */
	string = index(Arg, ' ');
	assert(string != NULL);
	while ( isspace(*string) )
	    string += 1;
	
	/* First, see if the string has been saved exactly */
	
	num_keys = find_keys_from_string(string, 0, &keyptr);
	    
	if ( num_keys == -1) {
	    fprintf(stdout,  "Some error in find_userid\n");
	    return;
	}
	if ( num_keys == 0 ) {
	    fprintf(stdout, "Found no keys that matched\n");
	    return;
	}
	fprintf(stdout, "Found these keys:\n");
	for(i=0; i < num_keys; i++ )
	    fprintf(stdout, "\t%#.16llx\n", keyptr[i]);
	free(keyptr);
	return;
    }
}
