/*  Hey Emacs, switch to -*-C-*-, please 

Copyright (C) 1997 Tage Stabell-Kul (tage@acm.org).  All rights
reserved.

This is a package, containing a library, that makes it possible for
programmers to include security functionality in their programs, in a
format compatible with PGP.

This library is free for commercial and non-commercial use as long as
the following conditions are aheared to:

Copyright remains Tage Stabell-Kul's, and as such any Copyright
notices in the code are not to be removed.
If this package is used in a product, Tage Stabell-Kul should be given
attribution as the author of the parts of the library used.
This can be in the form of a textual message at program startup or
in documentation (online or textual) provided with the package.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:
   "This product includes software written by
    Tage Stabell-Kul (tage@acm.org)"

THIS SOFTWARE IS PROVIDED BY TAGE STABELL-KUL ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The licence and distribution terms for any publically available
version or derivative of this code cannot be changed.  i.e. this code
cannot simply be copied and put under another distribution licence
[including the GNU Public Licence.]

The reason behind this being stated in this direct manner is past
experience in code simply being copied and the attribution removed
from it and then being distributed as part of other packages. This
implementation was a non-trivial and unpaid effort.

 */

#include <ctype.h>
#include <stdlib.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <zlib.h>

#include <malloc.h>

#include "shell.h"
#include <pgplib.h>
#include <pgp_m.h>


#define STATISTICS

void
goodbye(void)
{
    keydb_end();
    exit(1);
}

void
add(int argc, char *argv[])
{
    int		fid;
    char	*p;
    int		armor;
    FILE	*file;
    u_char	CTB;
    u_char	*packet;
    int		p_len;

    PGPsig_t	sig;
    PGPpubkey_t	key;
    PGPuserid_t	uid;
    PGPliteral_t literal;
    int		how_much;
    int		have_key;


#ifdef STATISTICS
    int		packet_sofar, sig_sofar, key_sofar, uid_sofar;
#endif
    /* scratch */
    int		i;

    if ( argc > 3 || argc < 2) {
	fprintf(stderr, "ADD file [armor] .  Will add thnigs to a database\n");
	return;
    }
    if ( dbase_open == 0 ) {
	fprintf(stderr, "No database is open.\n");
	return;
    }
    armor = 0;
    if ( argc == 3 ) {
	for(p=argv[2]; *p; p++)
	    *p = tolower(*p);
	if ( strcmp(argv[2], "armor")) {
	    fprintf(stderr, "ADD: arg 3 MUST be \"armor\" (or \"ARMOR\") or nothing (not \"%s\")\n",
		    argv[2]);
	    return;
	}
	else {
	    armor = 1;
	}
    }

    if ( armor ) {

	FILE	*tmp1, *tmp2;
	char	*fname;

	tmp1 = fopen(argv[1], "r");
	if ( tmp1 == NULL ) {
	    fprintf(stderr, "Can't open %s\n", argv[1]);
	    return;
	}
	i  = mkstemp("/tmp/temp.XXXXXX");
	tmp2 = fdopen(i, "w+");
	if ( tmp2 == NULL ) {
	    fclose(tmp1);
	    fprintf(stderr, "Error in creating tmp-file\n");
	    return;
	}
	fprintf(stdout, "DeArmoring....\n");
	i = dearmor_file(tmp1, tmp2);
	if ( i != 0 ) {
	    fclose(tmp1);
	    fclose(tmp2);
	    fprintf(stderr, "Could not dearmor file %s\n", argv[1]);
	    return;
	}
	fclose(tmp2);
	fprintf(stdout, "....Done.\n");
	
	fid = open(fname, O_RDONLY);
    }
    else { /* not armored */
	fid = open(argv[1], O_RDONLY);
    }
    if ( fid < 0 ) {
	perror("open");
	return;
    }
    file = fdopen(fid, "r");
    if ( file == NULL ) {
	fprintf(stderr, "Canr fdopen file\n");
	return;
    }

    /* Turn it into a file we can handle */
more:
    i  = fgetc(file);
    if ( i == EOF ) {
	fprintf(stderr, "EOF reached\n");
	fclose(file);
	return;
    }
    CTB = (u_char) i;

    switch ( (CTB & CTB_TYPE_MASK) >> 2) {
    case CTB_SKE_TYPE:
    case CTB_CERT_PUBKEY_TYPE:
    case CTB_KEYCTRL_TYPE:
    case CTB_USERID_TYPE:
    case CTB_COMMENT_TYPE:
	ungetc(CTB, file);
	break;
    case CTB_COMPRESSED_TYPE: {
	/* We have to read from here and until EOF storing the
	 * result in a new file (to get rid of the CTB).
	 * Then we uncompreee and reopen.
	 */
	FILE    *tmp1;

	fprintf(stdout, "File is compressed.  Decompressing....");
	tmp1 = tmpfile();
        i = decompress_file(file, tmp1);
        if ( i != 0 ) {
            fprintf(stderr, "Compressed, but it wouldn't decompress\n");
            fclose(tmp1);
            return;
        }

	fprintf(stdout, "...Done\n");
	goto more;
    }
    case CTB_LITERAL_TYPE:
	fprintf(stdout, "File is literal.  Unpacking....\n");
	i = parse_literal_file(file, &literal);
	if ( i == -1 ) {
	    fprintf(stderr, "First package was literal, but would't unpack\n");
	    fclose(file);
	    return;
	}
	fprintf(stdout, "Literal info:\n");
	fprintf(stdout, "\tMode:\t\t%d\n", literal.mode);
	fprintf(stdout, "\tFilename:\t%s\n", literal.filename);
	fprintf(stdout, "\tTimestamp:\t%ld\n", literal.timestamp);
	fprintf(stdout, "\tLength:\t\t%d\n", literal.datalen);

	goto more;
	
    case CTB_CKE_TYPE:
	fprintf(stdout, "Encrypted data.\n");
	fclose(file);
	return;
    default:
	fprintf(stderr, "File contains packet of unknown type\n");
	fclose(file);
	return;
    }
    
#ifdef STATISTICS
    packet_sofar = sig_sofar = uid_sofar = key_sofar = 0;
#endif

    how_much = 0;
    packet = NULL;
    have_key = 0;

    while ( 1 ) {

#ifdef STATISTICS
	if ( packet_sofar % 500 == 0 )
	    fprintf(stderr, "%d: key=%d sig=%d uid=%d\n",
		    packet_sofar, key_sofar, sig_sofar, uid_sofar);
	packet_sofar += 1;

	/*if ( packet_sofar % 1000 == 0 ) {
	    keydb_sync();
	}*/
#endif

	i = read_packet(file, &p_len, &packet);
	switch( i ) {
	case -1:
	    fprintf(stderr, "Some error in read packet\n");
	    keydb_end();
	    return;
	case 1:
	    if ( feof(file) ) {
		fclose(file);
	    }
	    else
		fprintf(stderr, "Syntax error in the file\n");
	    return;
	case 0:
	    /* We found a package.  We consumed j bytes */
	    how_much += p_len;
	    break;
	default:
	    assert(0);
	}
	
 	CTB = (packet[0] & CTB_TYPE_MASK) >> 2;
    
	switch ( CTB ) {
	    
	case CTB_COMMENT_TYPE:
	case CTB_CKE_TYPE:
	case CTB_COMPRESSED_TYPE:
	    fprintf(stderr, "CTB = %x\n", packet[0]);
	    assert(0);

	case CTB_CERT_SECKEY_TYPE:
	    fprintf(stdout, "%d Secret key !! \n", how_much);
	    free(packet);
	    continue;
	    
 	case CTB_KEYCTRL_TYPE:
	    fprintf(stdout, "Key Control Packet\n");
	    free(packet);
	    continue;
	case CTB_CERT_PUBKEY_TYPE:
#ifdef STATISTICS
	    key_sofar += 1;
#endif
	    if (have_key == 1)
		free_pubkey(&key);
	    else
		have_key = 1;

	    i = buf2pubkey(packet, p_len, &key);
	    fprintf(stdout, "Storing Key: %#.16llx\n", BN_get_keyid(key.N));
	    i = store_pub_key(&key, INSERT);
	    switch (i) {
	    case -1:
		fprintf(stderr, "\tSome error storing key %#.16llx\n", 
			BN_get_keyid(key.N));
		goodbye();
	    case 1:
		fprintf(stdout, "\tKey exists, can-not store %#.16llx\n",
			BN_get_keyid(key.N));
		break;
	    case 0:
		break;
	    default: 
		assert(0);
	    }
	    free(packet);
	    continue;
 	case CTB_USERID_TYPE:
#ifdef STATISTICS
	    uid_sofar += 1;
#endif
	    i = buf2userid(packet, p_len, &uid);
	    fprintf(stdout, "Adding UserID: %s\n", uid.name);
	    i = add_user_id(BN_get_keyid(key.N), &uid);
	    if ( i != 0 ) {
		if ( i == 1 )
		    fprintf(stdout,
			    "Found an identical ID to %s on %#.16llx\n",
			    uid.name, BN_get_keyid(key.N));
		else {
		    fprintf(stderr, 
			    "\tError while adding userID \"%s\" to key %#.16llx\n",
			    uid.name, BN_get_keyid(key.N));
		    goodbye();
		}
	    }
	    free_uid(&uid);
	    free(packet);
	    continue;

	case CTB_SKE_TYPE: {
	    /* a local variable */
	    PGPuserid_t	**uidp;

#ifdef STATISTICS
	    sig_sofar += 1;
#endif

	    i = buf2signature(packet, p_len, &sig);
	    fprintf(stdout, "Adding Signature: %#.16llx\n", sig.key_id);
	    i = find_uids_with_key(sig.key_id, &uidp);
	    if ( i == -1 ) 
		goodbye();
	    if ( i == 1)
		fprintf(stdout, "\t\tUnknown\n");
	    else {
		for(i = 0; uidp[i] != NULL; i++) {
		    fprintf(stdout, "\t\t%s\n", uidp[i]->name);
		    free_uid(uidp[i]);
		}
		free(uidp);
	    }
	    i = add_sig_to_keyid(BN_get_keyid(key.N), &sig);
	    if ( i != 0 ) {
		if ( i == 1 ) {
		    fprintf(stdout, "\tCouldn't add sig %#.16llx to key %#.16llx\n",
			    sig.key_id, BN_get_keyid(key.N));

		    fprintf(stdout, "\t\tSignature already there\n");
		}
		else {
		    fprintf(stderr, "\tCouldn't add sig %#.16llx to key %#.16llx\n",
			    sig.key_id, BN_get_keyid(key.N));

		    fprintf(stderr, "\t\tError\n");
		    goodbye();
		}
	    }
	    (void) free_signature(&sig);
	    free(packet);
	    continue;
	}
	default:
	    fprintf(stderr, "%d Unknown CTB=%d\n", how_much, CTB);
	    assert(0);
	}
    } /* while */
    
    return;
}
