/* p12_lib.c */
/* Copyright (C) 1997-8 Dr S N Henson (shenson@bigfoot.com) 
 * All Rights Reserved.
 * Any software using this code must include the following message in its
 * startup code or documentation and in any advertising material:
 * "This Product includes cryptographic software written by Dr S N Henson
 *  (shenson@bigfoot.com)"
 */
#include <stdio.h>
#include <stdlib.h>
#include <asn1_mac.h>
#include <err.h>
#include "pkcs12.h"

/*
 *PKCS12err(PKCS12_F_PKCS12_NEW,PKCS12_R_DECODE_ERROR)
 *PKCS12err(PKCS12_F_D2I_PKCS12,PKCS12_R_DECODE_ERROR)
 */

int i2d_PKCS12(a,pp)
PKCS12 *a;
unsigned char **pp;
{
	M_ASN1_I2D_vars(a);

	M_ASN1_I2D_len (a->version, i2d_ASN1_INTEGER);
	M_ASN1_I2D_len (a->authsafes, i2d_PKCS7);
	M_ASN1_I2D_len (a->mac, i2d_PKCS12_MAC_DATA);

	M_ASN1_I2D_seq_total();

	M_ASN1_I2D_put (a->version, i2d_ASN1_INTEGER);
	M_ASN1_I2D_put (a->authsafes, i2d_PKCS7);
	M_ASN1_I2D_put (a->mac, i2d_PKCS12_MAC_DATA);

	M_ASN1_I2D_finish();
}

PKCS12 *d2i_PKCS12(a,pp,length)
PKCS12 **a;
unsigned char **pp;
long length;
{
	M_ASN1_D2I_vars(a,PKCS12 *,PKCS12_new);
	M_ASN1_D2I_Init();
	M_ASN1_D2I_start_sequence();
	M_ASN1_D2I_get (ret->version, d2i_ASN1_INTEGER);
	M_ASN1_D2I_get (ret->authsafes, d2i_PKCS7);
	M_ASN1_D2I_get_opt (ret->mac, d2i_PKCS12_MAC_DATA, V_ASN1_SEQUENCE);
	M_ASN1_D2I_Finish(a, PKCS12_free, PKCS12_F_D2I_PKCS12);
}

PKCS12 *PKCS12_new()
{
	PKCS12 *ret=NULL;
	M_ASN1_New_Malloc(ret, PKCS12);
	ret->version=NULL;
	ret->mac=NULL;
	ret->authsafes=NULL;
	return (ret);
	M_ASN1_New_Error(PKCS12_F_PKCS12_NEW);
}

void PKCS12_free (a)
PKCS12 *a;
{
	if (a == NULL) return;
	ASN1_INTEGER_free (a->version);
	PKCS12_MAC_DATA_free (a->mac);
	PKCS7_free (a->authsafes);
	Free ((char *)a);
}
