#! /bin/sh
#
#                         DES SOFTWARE PACKAGE
#                             Version 2.2
#
#                                        _
# Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
# All Rights Reserved
#
#
# The author takes no responsibility of actions caused by the use of this
# software package and does not guarantee the correctness of the functions.
#
# This software package may be freely distributed for non-commercial purpose
# as long as the copyright notice is kept. Any changes made should be
# accompanied by a comment indicating who made the change, when it was made
# and what was changed.
#
# This software package, or any parts of it, may not be used or in any way
# re-distributed for commercial purpose without the authors permission.
# The author keeps the right to decide between of what is commercial and
# what is non-commercial purpose.
#
# Restrictions due to national laws governing the use, import or export of
# cryptographic software is the responsibility of the software user/importer/
# exporter to follow.
#
#
#                                              _
#                                         Stig Ostholm
#                                         Chalmers University of Technology
#                                         Department of Computer Engineering
#                                         S-412 96 Gothenburg
#                                         Sweden
#                                         ----------------------------------
#                                         Email: ostholm@ce.chalmers.se
#                                         Phone: +46 31 772 1703
#                                         Fax:   +46 31 772 3663
# 


PROG="`IFS=/; set $0; eval echo '$'$#`"
USAGE="Usage: ${PROG} [VAR=value ...] [-s]"

DESVERIFY=./desverify

FLAGS=
ECHO=echo
VERBOSE=

while :; do
	case $# in
	0)      break;;
	esac
	case "$1" in
	[A-Z]*=*)
		if VAR="`expr \"$1\" : '^\([^=]*\)=.*$'`"; then
			case "$1" in
			"${VAR}=")
				eval "${VAR}="
				shift
				continue;;
			esac
			if VAL="`expr \"$1\" : \"^${VAR}=\(.*\)\$\"`"; then
				if eval "${VAR}=\"\${VAL}\""; then
					:
				else
					exit 1
				fi
			else
				exit 1
			fi
		else
			exit 1
		fi;;
	-*s*)	FLAGS="${FLAGS} -s" VERBOSE=:;;
	--)	shift
		break;;
	-*)	:;;
	*)      break;;
	esac
	shift
done
case $# in
[1-9]*)	echo "${USAGE}" >&2
	exit 1;;
esac
case "${VERBOSE}" in
'')	VERBOSE="${ECHO}";;
esac


MAX_TESTS=10

./deavrfy $FLAGS -f vrfy.data
ERRORS=$?

eval $VERBOSE

$VERBOSE "Encrypt then decrypt and compare with original data."
(
	ERRORS=0 N=0
	while read KEY; do
		$VERBOSE -n "  Key: \"${KEY}\" ... "
#		if ./desktest $FLAGS "${KEY}"; then
		if ./desktest -s "${KEY}"; then
			$VERBOSE Ok.
		else
			$VERBOSE Error.
			ERRORS=`expr $ERRORS + 1`
		fi
		N=`expr $N + 1`
		case $N in
		$MAX_TESTS)	break;;
		esac
	done
	MAX_TESTS=`expr $MAX_TESTS \* 2`
	while read KEY1; do
		if read KEY2; then
			$VERBOSE -n "  Key: \"${KEY1}\", \"${KEY2}\" ... "
#			if ./desktest -3 "${KEY1}" "${KEY2}"; then
			if ./desktest -3s "${KEY1}" "${KEY2}"; then
				$VERBOSE Ok.
			else
				$VERBOSE Error.
				ERRORS=`expr $ERRORS + 1`
			fi
			N=`expr $N + 1`
			case $N in
			$MAX_TESTS)	break;;
			esac
		else
			break
		fi
	done
	$VERBOSE "Passed ${N} tests with ${ERRORS} errors."
	exit $ERRORS
	$VERBOSE "Passed ${N} tests with ${ERRORS} errors."
	exit $ERRORS
) < /usr/dict/words
ERRORS=`expr $ERRORS + $?`

$VERBOSE

./ctest.sh $FLAGS
ERRORS=`expr $ERRORS + $?`

$VERBOSE
$VERBOSE "All tests passed with $ERRORS errors."

exit $ERRORS
