/*
 *
 *                         DES SOFTWARE PACKAGE
 *                             Version 2.2
 *
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software package and does not guarantee the correctness of the functions.
 *
 * This software package may be freely distributed for non-commercial purpose
 * as long as the copyright notice is kept. Any changes made should be
 * accompanied by a comment indicating who made the change, when it was made
 * and what was changed.
 *
 * This software package, or any parts of it, may not be used or in any way
 * re-distributed for commercial purpose without the authors permission.
 * The author keeps the right to decide between of what is commercial and
 * what is non-commercial purpose.
 *
 * Restrictions due to national laws governing the use, import or export of
 * cryptographic software is the responsibility of the software user/importer/
 * exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	<sys/types.h>
#include	<sys/times.h>
#include	<time.h>
#if !defined(DEA_TEST) && !defined(DEA3_TEST) && !defined(SCH_TEST)
# include	<string.h>
#endif  /* ! DEA_TEST && ! DEA3_TEST && ! SCH_TEST */
#include	<stdio.h>
#include	<des.h>
#include	"config.h"


#if !defined(DEA_TEST) && !defined(DEA3_TEST) && !defined(SCH_TEST)
char		*prog;

# define _3_FLAG	0x1L
# define k_FLAG		0x2L
# define s_FLAG		0x4L
unsigned long	flags = 0L;
#endif  /* ! DEA_TEST && ! DEA3_TEST && ! SCH_TEST */


main(argc, argv)
int	argc;
char	*argv[];
{
	register unsigned int	i;
	des_cblock		b;
	struct tms		tbuf0, tbuf1;
#if defined(DEA_TEST) || defined(DEA3_TEST) || defined(SCH_TEST)
# ifdef DEA3_TEST
	des_key_schedule	schedule[2];
# else  /* DEA3_TEST */
	des_key_schedule	schedule;
# endif /* DEA3_TEST */


	/* Run one round to page in all data */
# ifdef DEA_TEST
	(void) des_dea((des_cblock *) b, (des_cblock *) b, schedule, DES_ENCRYPT);
# else  /* DEA_TEST */
#  ifdef DEA3_TEST
	(void) des_dea3((des_cblock *) b, (des_cblock *) b, schedule[0], DES_ENCRYPT);
#  else  /* DEA3_TEST */
	(void) des_sched((des_cblock *) b, schedule);
#  endif /* DEA3_TEST */
# endif /* DEA_TEST */

	i = atoi(argv[1]);
	(void) times(&tbuf0);

	while (i-- > 0) {
# ifdef DEA_TEST
		(void) des_dea((des_cblock *) b, (des_cblock *) b, schedule, DES_ENCRYPT);
# else  /* DEA_TEST */
#  ifdef DEA3_TEST
		(void) des_dea3((des_cblock *) b, (des_cblock *) b, schedule[0], DES_ENCRYPT);
#  else  /* DEA3_TEST */
		(void) des_sched((des_cblock *) b, schedule);
#  endif /* DEA3_TEST */
# endif /* DEA_TEST */
	}

	(void) times(&tbuf1);
	printf("%lu", (unsigned long) (tbuf1.tms_utime - tbuf0.tms_utime));

	for (i = 2; i < argc; i++)
		printf(" %s", argv[i]);
	printf("\n");

	exit(0);

#else  /* DEA_TEST || DEA3_TEST || SCH_TEST */
	register int		n, o;
	register char		*alg = "des_dea()";
	des_key_schedule	schedule[DES_MAX_KEYS];
	extern int		optind;


	prog = (prog = strrchr(*argv, '/')) ? (prog + 1) : *argv;

	while ((o = getopt(argc, argv, "3ks")) != EOF)
		switch (o) {
		case '3':
			if (flags & (_3_FLAG | k_FLAG))
				goto usage;
			flags |= _3_FLAG;
			alg = "des_dea3()";
			break;
		case 'k':
			if (flags & (_3_FLAG | k_FLAG))
				goto usage;
			flags |= k_FLAG;
			alg = "des_sched()";
			break;
		case 's':
			if (flags & s_FLAG)
				goto usage;
			flags |= s_FLAG;
			break;
		case '?':
		default:
			goto usage;
		}
	if (optind + 1 != argc)
		goto usage;

	i = n = atoi(argv[optind]);

	if (flags & k_FLAG) {
		(void) times(&tbuf0);
		while (i-- > 0) 
			(void) des_sched((des_cblock *) b, schedule[0]);
		(void) times(&tbuf1);
	} else if (flags & _3_FLAG) {
		(void) times(&tbuf0);
		while (i-- > 0) 
			(void) des_dea3((des_cblock *) b, (des_cblock *) b,
					 schedule[0], DES_ENCRYPT);
		(void) times(&tbuf1);
	} else {
		(void) times(&tbuf0);
		while (i-- > 0) 
			(void) des_dea((des_cblock *) b, (des_cblock *) b,
				       schedule[0], DES_ENCRYPT);
		(void) times(&tbuf1);
	}

	if (!(flags & s_FLAG))
		printf("%d iterations for %s: %lu user clock ticks.\n",
		       n, alg,
		       (unsigned long) (tbuf1.tms_utime - tbuf0.tms_utime));

	exit(0);

usage:
	(void) fprintf(stderr, "Usage: %s [-3|-k] [-s] iterations\n", prog);
	exit(1);
#endif /* DEA_TEST || DEA3_TEST || SCH_TEST */
}
